/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ExtendedDialog
extends JDialog {
    private int result = 0;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable = false;
    private String rememberSizePref = "";
    private WindowGeometry defaultWindowGeometry = null;
    private String togglePref = "";
    private int toggleValue = -1;
    private String toggleCheckboxText = I18n.tr("Do not show again (remembers choice)");
    private JCheckBox toggleCheckbox = null;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bToolTipTexts;
    private String[] bIcons;
    private int cancelButtonIdx = -1;
    private int defaultButtonIdx = -1;
    private JButton defaultButton = null;
    private boolean showHelpButton;
    private String helpTopic;
    private boolean placeContentInScrollPane;
    protected Object contentConstraints = GBC.eol().anchor(10).fill(1).insets(5, 10, 5, 0);
    protected ArrayList<JButton> buttons = new ArrayList();
    private boolean setupDone = false;

    public ExtendedDialog(Component component, String string, String[] stringArray) {
        super(JOptionPane.getFrameForComponent(component), string, true);
        this.parent = component;
        this.bTexts = stringArray;
    }

    public ExtendedDialog(Component component, String string, String[] stringArray, boolean bl) {
        super(JOptionPane.getFrameForComponent(component), string, bl);
        this.parent = component;
        this.bTexts = stringArray;
    }

    public ExtendedDialog setButtonIcons(String[] stringArray) {
        this.bIcons = stringArray;
        return this;
    }

    public ExtendedDialog setToolTipTexts(String[] stringArray) {
        this.bToolTipTexts = stringArray;
        return this;
    }

    public ExtendedDialog setContent(Component component) {
        return this.setContent(component, true);
    }

    public ExtendedDialog setContent(Component component, boolean bl) {
        this.content = component;
        this.placeContentInScrollPane = bl;
        return this;
    }

    public ExtendedDialog setContent(String string) {
        return this.setContent(ExtendedDialog.string2label(string), false);
    }

    public ExtendedDialog showDialog() {
        if (this.toggleCheckState(this.togglePref)) {
            this.result = this.toggleValue;
            return this;
        }
        this.setupDialog();
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.setVisible(true);
        this.toggleSaveState();
        return this;
    }

    public int getValue() {
        return this.result;
    }

    public void setupDialog() {
        boolean bl;
        if (this.setupDone) {
            return;
        }
        this.setupDone = true;
        this.setupEscListener();
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            AbstractAction abstractAction = new AbstractAction(this.bTexts[i]){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExtendedDialog.this.buttonAction(actionEvent);
                }
            };
            JButton jButton = new JButton(abstractAction);
            if (i == this.defaultButtonIdx - 1) {
                this.defaultButton = jButton;
            }
            if (this.bIcons != null && this.bIcons[i] != null) {
                jButton.setIcon(ImageProvider.get(this.bIcons[i]));
            }
            if (this.bToolTipTexts != null && i < this.bToolTipTexts.length && this.bToolTipTexts[i] != null) {
                jButton.setToolTipText(this.bToolTipTexts[i]);
            }
            if (i == 0) {
                this.rootPane.setDefaultButton(jButton);
            }
            jPanel.add((Component)jButton, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(jButton);
        }
        if (this.showHelpButton) {
            jPanel.add((Component)new JButton(new HelpAction()), GBC.std().insets(2, 2, 2, 2));
            HelpUtil.setHelpContext(this.getRootPane(), this.helpTopic);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add(this.content, this.contentConstraints);
        if (this.toggleable) {
            this.toggleCheckbox = new JCheckBox(this.toggleCheckboxText);
            boolean bl2 = Main.pref.getBoolean("message." + this.togglePref, true);
            this.toggleCheckbox.setSelected(!bl2);
            jPanel2.add((Component)this.toggleCheckbox, GBC.eol().anchor(21).insets(5, 5, 5, 5));
        }
        jPanel2.add((Component)jPanel, GBC.eol().anchor(10).insets(5, 5, 5, 5));
        if (this.placeContentInScrollPane) {
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(null);
            this.setContentPane(jScrollPane);
        } else {
            this.setContentPane(jPanel2);
        }
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.findMaxDialogSize();
        boolean bl3 = dimension.width > dimension2.width;
        boolean bl4 = bl = dimension.height > dimension2.height;
        if (dimension2.width > 0 && dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > 0 && dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        if (!bl3 && bl) {
            dimension.width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize(dimension);
        this.setLocationRelativeTo(this.parent);
    }

    protected void buttonAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        for (int i = 0; i < this.bTexts.length; ++i) {
            if (!this.bTexts[i].equals(string)) continue;
            this.result = i + 1;
            break;
        }
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width * 2 / 3, dimension.height * 2 / 3);
        try {
            if (this.parent != null) {
                dimension2 = JOptionPane.getFrameForComponent(this.parent).getSize();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return dimension2;
    }

    private void setupEscListener() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                ExtendedDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.repaint();
        }
        if (this.rememberSizePref.length() != 0 && this.defaultWindowGeometry != null) {
            if (bl) {
                new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry).applySafe(this);
            } else {
                new WindowGeometry(this).remember(this.rememberSizePref);
            }
        }
        super.setVisible(bl);
    }

    public ExtendedDialog setRememberWindowGeometry(String string, WindowGeometry windowGeometry) {
        this.rememberSizePref = string == null ? "" : string;
        this.defaultWindowGeometry = windowGeometry;
        return this;
    }

    public ExtendedDialog toggleEnable(String string) {
        this.toggleable = true;
        this.togglePref = string;
        return this;
    }

    public ExtendedDialog toggleDisable() {
        this.toggleable = false;
        return this;
    }

    public ExtendedDialog setToggleCheckboxText(String string) {
        this.toggleCheckboxText = string;
        return this;
    }

    public ExtendedDialog setDefaultButton(int n) {
        this.defaultButtonIdx = n;
        return this;
    }

    public ExtendedDialog setCancelButton(int n) {
        this.cancelButtonIdx = n;
        return this;
    }

    private boolean toggleCheckState(String string) {
        this.toggleable = string != null && !string.equals("");
        this.toggleValue = Main.pref.getInteger("message." + string + ".value", -1);
        if (!this.toggleable || this.toggleValue == -1) {
            return false;
        }
        this.togglePref = string;
        return !Main.pref.getBoolean("message." + string, true);
    }

    private void toggleSaveState() {
        if (!this.toggleable || this.toggleCheckbox == null || this.result == this.cancelButtonIdx || this.result == 0) {
            return;
        }
        Main.pref.put("message." + this.togglePref, !this.toggleCheckbox.isSelected());
        Main.pref.putInteger("message." + this.togglePref + ".value", this.result);
    }

    private static JMultilineLabel string2label(String string) {
        JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jMultilineLabel.setMaxWidth(dimension.width / 2);
        return jMultilineLabel;
    }

    public ExtendedDialog configureContextsensitiveHelp(String string, boolean bl) {
        this.helpTopic = string;
        this.showHelpButton = bl;
        return this;
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information"));
            this.putValue("Name", I18n.tr("Help"));
            this.putValue("SmallIcon", ImageProvider.get("help"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.setUrlForHelpTopic(ExtendedDialog.this.helpTopic);
        }
    }
}

