/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    public void load() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        try {
            for (Preferences.Bookmark bookmark : Main.pref.loadBookmarks()) {
                defaultListModel.addElement(bookmark);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", Main.pref.getBookmarksFile(), iOException.getMessage()), I18n.tr("Error"), 0);
        }
    }

    public void save() {
        try {
            LinkedList<Preferences.Bookmark> linkedList = new LinkedList<Preferences.Bookmark>();
            for (Object object : ((DefaultListModel)this.getModel()).toArray()) {
                linkedList.add((Preferences.Bookmark)object);
            }
            Main.pref.saveBookmarks(linkedList);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not write bookmark.<br>{0}</html>", iOException.getMessage()), I18n.tr("Error"), 0);
        }
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon icon;

        public BookmarkCellRenderer() {
            this.setOpaque(true);
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.setIcon(this.icon);
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Preferences.Bookmark bookmark) {
            Bounds bounds = bookmark.getArea();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>min[latitude,longitude]=<strong>[").append(bounds.getMin().lat()).append(",").append(bounds.getMin().lon()).append("]</strong>").append("<br>").append("max[latitude,longitude]=<strong>[").append(bounds.getMax().lat()).append(",").append(bounds.getMax().lon()).append("]</strong>").append("</html>");
            return stringBuffer.toString();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Preferences.Bookmark bookmark = (Preferences.Bookmark)object;
            this.renderColor(bl);
            this.setText(bookmark.getName());
            this.setToolTipText(this.buildToolTipText(bookmark));
            return this;
        }
    }
}

