/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.PuwgData;
import org.openstreetmap.josm.tools.I18n;

class Epsg2180
implements PuwgData {
    private static final double Epsg2180FalseEasting = 500000.0;
    private static final double Epsg2180FalseNorthing = -5300000.0;
    private static final double Epsg2180ScaleFactor = 0.9993;
    private static final double Epsg2180CentralMeridian = 19.0;

    Epsg2180() {
    }

    public String toString() {
        return I18n.tr("PUWG 1992 (Poland)");
    }

    public String toCode() {
        return "EPSG:2180";
    }

    public String getCacheDirectoryName() {
        return "epsg2180";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(49.0, 14.12), new LatLon(54.84, 24.15));
    }

    public double getPuwgCentralMeridianDeg() {
        return 19.0;
    }

    public double getPuwgCentralMeridian() {
        return Math.toRadians(19.0);
    }

    public double getPuwgFalseEasting() {
        return 500000.0;
    }

    public double getPuwgFalseNorthing() {
        return -5300000.0;
    }

    public double getPuwgScaleFactor() {
        return 0.9993;
    }
}

