/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;

public class RelationMember
implements PrimitiveId {
    private final String role;
    private final OsmPrimitive member;

    public String getRole() {
        return this.role;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public boolean isRelation() {
        return this.member instanceof Relation;
    }

    public boolean isWay() {
        return this.member instanceof Way;
    }

    public boolean isNode() {
        return this.member instanceof Node;
    }

    public Relation getRelation() {
        return (Relation)this.member;
    }

    public Way getWay() {
        return (Way)this.member;
    }

    public Node getNode() {
        return (Node)this.member;
    }

    public OsmPrimitive getMember() {
        return this.member;
    }

    public RelationMember(String string, OsmPrimitive osmPrimitive) throws IllegalArgumentException {
        if (string == null) {
            string = "";
        }
        if (osmPrimitive == null) {
            throw new IllegalArgumentException("Relation member cannot be null");
        }
        this.role = string;
        this.member = osmPrimitive;
    }

    public RelationMember(RelationMember relationMember) {
        this(relationMember.role, relationMember.member);
    }

    public String toString() {
        return '\"' + this.role + "\"=" + this.member;
    }

    public boolean refersTo(OsmPrimitive osmPrimitive) {
        return this.member == osmPrimitive;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.member.hashCode();
        n = 31 * n + this.role.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof RelationMember) {
            RelationMember relationMember = (RelationMember)object;
            return this.member.equals(relationMember.getMember()) && this.role.equals(relationMember.getRole());
        }
        return false;
    }

    public OsmPrimitiveType getType() {
        return this.member.getType();
    }

    public long getUniqueId() {
        return this.member.getUniqueId();
    }

    public boolean isNew() {
        return this.member.isNew();
    }
}

