/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    private static boolean debug = false;
    private static final boolean consistency_testing = false;
    private final Object split_lock = new Object();
    long last_out = -1L;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    private QBLevel root;
    private QBLevel search_cache;
    private int size;

    static void abort(String string) {
        throw new AssertionError((Object)string);
    }

    static void out(String string) {
        System.out.println(string);
    }

    void pout(String string) {
        long l = System.currentTimeMillis();
        if (l - this.last_out < 300L) {
            return;
        }
        this.last_out = l;
        System.out.print(string + "\r");
    }

    void pout(String string, int n, int n2) {
        long l = System.currentTimeMillis();
        if (l - this.last_out < 300L && n + 1 < n2) {
            return;
        }
        this.last_out = l;
        System.out.print(string + " " + (float)((double)(n + 1) * 100.0 / (double)n2) + "% done    \r");
    }

    public QuadBuckets() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.split_lock;
        synchronized (object) {
            this.root = new QBLevel();
            this.search_cache = null;
            this.size = 0;
            if (debug) {
                QuadBuckets.out("QuadBuckets() cleared: " + this);
                QuadBuckets.out("root: " + this.root + " level: " + this.root.level + " bbox: " + this.root.bbox());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        Object object = this.split_lock;
        synchronized (object) {
            this.root.add(t);
            ++this.size;
            return true;
        }
    }

    public void unsupported() {
        QuadBuckets.out("unsupported operation");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        for (OsmPrimitive osmPrimitive : this) {
            if (collection.contains(osmPrimitive) || this.remove((T)osmPrimitive)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            bl |= this.add((T)osmPrimitive);
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    private T convert(Object object) {
        return (T)((OsmPrimitive)object);
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(this.convert(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T t) {
        Object object = this.split_lock;
        synchronized (object) {
            this.search_cache = null;
            QBLevel qBLevel = this.root.findBucket(((OsmPrimitive)t).getBBox());
            if (qBLevel.remove_content(t)) {
                --this.size;
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean contains(Object object) {
        QBLevel qBLevel = this.root.findBucket(((OsmPrimitive)this.convert(object)).getBBox());
        return qBLevel != null && qBLevel.content != null && qBLevel.content.contains(object);
    }

    public ArrayList<T> toArrayList() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this) {
            arrayList.add(osmPrimitive);
        }
        if (debug) {
            QuadBuckets.out("returning array list with size: " + arrayList.size());
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <A> A[] toArray(A[] AArray) {
        return this.toArrayList().toArray(AArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.split_lock;
        synchronized (object) {
            return this.size;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<T> search(BBox bBox) {
        if (debug) {
            QuadBuckets.out("qb root search at " + bBox);
            QuadBuckets.out("root bbox: " + this.root.bbox());
        }
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        if (bl) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (!this.search_cache.bbox().bounds(bBox)) {
                if (debug) {
                    QuadBuckets.out("bbox: " + bBox);
                }
                if (debug) {
                    QuadBuckets.out("search_cache: " + this.search_cache + " level: " + this.search_cache.level);
                    QuadBuckets.out("search_cache.bbox(): " + this.search_cache.bbox());
                }
                this.search_cache = this.search_cache.parent;
                if (!debug) continue;
                QuadBuckets.out("new search_cache: " + this.search_cache);
            }
        } else {
            this.search_cache = this.root;
        }
        QBLevel qBLevel = this.search_cache.parent;
        this.search_cache.search(bBox, arrayList);
        while (qBLevel != null) {
            qBLevel.search_contents(bBox, arrayList);
            qBLevel = qBLevel.parent;
        }
        if (debug) {
            QuadBuckets.out("search of QuadBuckets for " + bBox + " ret len: " + arrayList.size());
        }
        return arrayList;
    }

    public void printTree() {
        this.printTreeRecursive(this.root, 0);
    }

    private void printTreeRecursive(QBLevel qBLevel, int n) {
        if (qBLevel == null) {
            this.printIndented(n, "<empty child>");
            return;
        }
        this.printIndented(n, qBLevel);
        if (qBLevel.hasContent()) {
            for (OsmPrimitive osmPrimitive : qBLevel.content) {
                this.printIndented(n, osmPrimitive);
            }
        }
        if (qBLevel.children != null) {
            for (QBLevel qBLevel2 : qBLevel.children) {
                this.printTreeRecursive(qBLevel2, n + 2);
            }
        }
    }

    private void printIndented(int n, Object object) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.println(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuadBucketIterator
    implements Iterator<T> {
        QBLevel current_node;
        int content_index;
        int iterated_over;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        QBLevel next_content_node(QBLevel qBLevel) {
            QBLevel qBLevel2;
            if (qBLevel == null) {
                return null;
            }
            QBLevel qBLevel3 = qBLevel;
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                qBLevel2 = qBLevel.nextContentNode();
            }
            if (qBLevel3 == qBLevel2) {
                QuadBuckets.abort("got same leaf back leaf: " + qBLevel.isLeaf());
            }
            return qBLevel2;
        }

        public QuadBucketIterator(QuadBuckets<T> quadBuckets2) {
            if (debug) {
                QuadBuckets.out(this + " is a new iterator qb: " + quadBuckets2 + " size: " + quadBuckets2.size());
            }
            this.current_node = quadBuckets2.root.isLeaf() || quadBuckets2.root.hasContent() ? quadBuckets2.root : this.next_content_node(quadBuckets2.root);
            if (debug) {
                QuadBuckets.out("\titerator first leaf: " + this.current_node);
            }
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                if (debug) {
                    QuadBuckets.out(this + " no hasNext(), but iterated over so far: " + this.iterated_over);
                }
                return false;
            }
            return true;
        }

        T peek() {
            if (this.current_node == null) {
                if (debug) {
                    QuadBuckets.out("null current leaf, nowhere to go");
                }
                return null;
            }
            while (this.current_node.content == null || this.content_index >= this.current_node.content.size()) {
                if (debug) {
                    QuadBuckets.out("moving to next leaf");
                }
                this.content_index = 0;
                this.current_node = this.next_content_node(this.current_node);
                if (this.current_node != null) continue;
            }
            if (this.current_node == null || this.current_node.content == null) {
                if (debug) {
                    QuadBuckets.out("late nowhere to go " + this.current_node);
                }
                return null;
            }
            return (OsmPrimitive)this.current_node.content.get(this.content_index);
        }

        @Override
        public T next() {
            Object t = this.peek();
            ++this.content_index;
            if (debug) {
                QuadBuckets.out("iteration[" + this.iterated_over + "] " + this.content_index + " leaf: " + this.current_node);
            }
            ++this.iterated_over;
            if (t == null && debug) {
                QuadBuckets.out(this + " no next node, but iterated over so far: " + this.iterated_over);
            }
            return t;
        }

        @Override
        public void remove() {
            --this.content_index;
            Object t = this.peek();
            this.current_node.remove_content(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QBLevel {
        final int level;
        private final BBox bbox;
        final long quad;
        final QBLevel parent;
        public List<T> content;
        public QBLevel[] children;

        public String toString() {
            return super.toString() + "[" + this.level + "]: " + this.bbox();
        }

        public QBLevel() {
            this.level = 0;
            this.quad = 0L;
            this.parent = null;
            this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
        }

        public QBLevel(QBLevel qBLevel, int n) {
            this.parent = qBLevel;
            this.level = qBLevel.level + 1;
            int n2 = (QuadTiling.NR_LEVELS - this.level) * 2;
            long l = 1L;
            if (n2 >= 30) {
                n2 -= 30;
                l = 0x40000000L;
            }
            long l2 = l * (long)(n << n2);
            this.quad = qBLevel.quad | l2;
            this.bbox = this.calculateBBox();
            if (debug) {
                QuadBuckets.out("new level[" + this.level + "] bbox[" + n + "]: " + this.bbox() + " coor: " + this.coor() + " quadpart: " + Long.toHexString(l2) + " quad: " + Long.toHexString(this.quad));
            }
        }

        private BBox calculateBBox() {
            LatLon latLon = this.coor();
            double d = latLon.lat() + this.parent.height() / 2.0;
            double d2 = latLon.lon() + this.parent.width() / 2.0;
            LatLon latLon2 = new LatLon(d, d2);
            return new BBox(latLon, latLon2);
        }

        QBLevel findBucket(BBox bBox) {
            if (this.isLeaf()) {
                return this;
            }
            int n = this.get_index(bBox, this.level);
            if (n == -1) {
                return this;
            }
            if (this.children[n] == null) {
                this.children[n] = new QBLevel(this, n);
            }
            return this.children[n].findBucket(bBox);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove_content(T t) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                if (this.content == null) {
                    return false;
                }
                boolean bl = this.content.remove(t);
                if (this.content.size() == 0) {
                    this.content = null;
                }
                if (this.canRemove()) {
                    this.remove_from_parent();
                }
                return bl;
            }
        }

        QBLevel[] newChildren() {
            return (QBLevel[])Array.newInstance(this.getClass(), QuadTiling.TILES_PER_LEVEL);
        }

        int get_index(BBox bBox, int n) {
            int n2 = -1;
            for (LatLon latLon : bBox.points()) {
                if (debug) {
                    QuadBuckets.out("getting index for point: " + latLon);
                }
                if (n2 == -1) {
                    n2 = QuadTiling.index(latLon, n);
                    if (!debug) continue;
                    QuadBuckets.out("set initial index to: " + n2);
                    continue;
                }
                int n3 = QuadTiling.index(latLon, n);
                if (debug) {
                    QuadBuckets.out("other point index: " + n3);
                }
                if (n3 == n2) continue;
                return -1;
            }
            return n2;
        }

        void __split() {
            if (debug) {
                QuadBuckets.out("splitting " + this.bbox() + " level " + this.level + " with " + this.content.size() + " entries (my dimensions: " + this.bbox().width() + ", " + this.bbox().height() + ")");
            }
            List list = this.content;
            this.content = null;
            this.children = this.newChildren();
            for (OsmPrimitive osmPrimitive : list) {
                this.add(osmPrimitive);
            }
            if (!this.hasChildren()) {
                this.children[0] = new QBLevel(this, 0);
            }
        }

        boolean __add_content(T t) {
            boolean bl = false;
            if (this.content == null) {
                this.content = new ArrayList();
            }
            bl = this.content.add(t);
            if (debug && !this.isLeaf()) {
                QuadBuckets.this.pout("added " + t.getClass().getName() + " to non-leaf with size: " + this.content.size());
            }
            return bl;
        }

        boolean matches(T t, BBox bBox) {
            return ((OsmPrimitive)t).getBBox().intersects(bBox);
        }

        private void search_contents(BBox bBox, List<T> list) {
            if (debug) {
                QuadBuckets.out("searching contents (size: " + this.content == null ? "<null>" : this.content.size() + ") for " + bBox);
            }
            if (this.content == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : this.content) {
                if (!this.matches(osmPrimitive, bBox)) continue;
                list.add(osmPrimitive);
            }
            if (debug) {
                QuadBuckets.out("done searching quad " + Long.toHexString(this.quad));
            }
        }

        boolean isLeaf() {
            return this.children == null;
        }

        QBLevel next_sibling() {
            boolean bl = false;
            if (this.parent == null) {
                return null;
            }
            if (this.parent.children == null) {
                return null;
            }
            int n = 0;
            for (QBLevel qBLevel : this.parent.children) {
                int n2 = ++n - 1;
                if (qBLevel == null) {
                    if (!debug) continue;
                    QuadBuckets.out("[" + this.level + "] null child nr: " + n2);
                    continue;
                }
                if (qBLevel == this) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] I was child nr: " + n2);
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] next sibling was child nr: " + n2);
                    }
                    return qBLevel;
                }
                if (!debug) continue;
                QuadBuckets.out("[" + this.level + "] nr: " + n2 + " is before me, ignoring...");
            }
            return null;
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel nextSibling() {
            QBLevel qBLevel = this;
            QBLevel qBLevel2 = qBLevel.next_sibling();
            while (qBLevel2 == null) {
                if (debug) {
                    QuadBuckets.out("no siblings at level[" + qBLevel.level + "], moving to parent");
                }
                if ((qBLevel = qBLevel.parent) == null) break;
                qBLevel2 = qBLevel.next_sibling();
            }
            qBLevel = qBLevel2;
            return qBLevel;
        }

        QBLevel firstChild() {
            QBLevel qBLevel = null;
            for (QBLevel qBLevel2 : this.children) {
                if (qBLevel2 == null) continue;
                qBLevel = qBLevel2;
                break;
            }
            return qBLevel;
        }

        QBLevel nextNode() {
            if (this.isLeaf()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel nextContentNode() {
            QBLevel qBLevel = this.nextNode();
            if (qBLevel == null) {
                return qBLevel;
            }
            if (qBLevel.hasContent()) {
                return qBLevel;
            }
            return qBLevel.nextContentNode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAdd(T t) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                this.__add_content(t);
                if (this.isLeaf() && this.content.size() > MAX_OBJECTS_PER_LEVEL && this.level < QuadTiling.NR_LEVELS) {
                    this.__split();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(T t) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                this.findBucket(((OsmPrimitive)t).getBBox()).doAdd(t);
            }
        }

        private void search(BBox bBox, List<T> list) {
            if (debug) {
                System.out.print("[" + this.level + "] qb bbox: " + this.bbox() + " ");
            }
            if (!this.bbox().intersects(bBox)) {
                if (debug) {
                    QuadBuckets.out("miss " + Long.toHexString(this.quad));
                }
                return;
            }
            if (this.hasContent()) {
                this.search_contents(bBox, list);
            }
            if (this.isLeaf()) {
                return;
            }
            if (debug) {
                QuadBuckets.out("hit " + this.quads());
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] not leaf, moving down");
            }
            for (int i = 0; i < this.children.length; ++i) {
                QBLevel qBLevel = this.children[i];
                if (debug) {
                    QuadBuckets.out("child[" + i + "]: " + qBLevel);
                }
                if (qBLevel == null) continue;
                if (debug) {
                    System.out.print(i + ": ");
                }
                qBLevel.search(bBox, list);
                if (!qBLevel.bbox().bounds(bBox)) continue;
                QuadBuckets.this.search_cache = qBLevel;
                if (!debug) break;
                QuadBuckets.out("break early");
                break;
            }
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        int index_of(QBLevel qBLevel) {
            if (this.isLeaf()) {
                return -1;
            }
            for (int i = 0; i < QuadTiling.TILES_PER_LEVEL; ++i) {
                if (this.children[i] != qBLevel) continue;
                return i;
            }
            return -1;
        }

        double width() {
            return this.bbox.width();
        }

        double height() {
            return this.bbox.height();
        }

        public BBox bbox() {
            return this.bbox;
        }

        LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }

        boolean hasChildren() {
            if (this.children == null) {
                return false;
            }
            for (QBLevel qBLevel : this.children) {
                if (qBLevel == null) continue;
                return true;
            }
            return false;
        }

        void remove_from_parent() {
            if (this.parent == null) {
                return;
            }
            int n = 0;
            for (int i = 0; i < this.parent.children.length; ++i) {
                QBLevel qBLevel = this.parent.children[i];
                if (qBLevel != null) {
                    ++n;
                }
                if (qBLevel != this) continue;
                if (!this.canRemove()) {
                    QuadBuckets.abort("attempt to remove non-empty child: " + this.content + " " + Arrays.toString(this.children));
                }
                this.parent.children[i] = null;
                --n;
            }
            if (n == 0) {
                this.parent.children = null;
            }
            if (this.parent.canRemove()) {
                this.parent.remove_from_parent();
            }
        }

        boolean canRemove() {
            if (this.content != null && this.content.size() > 0) {
                return false;
            }
            return !this.hasChildren();
        }
    }
}

