/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters
extends AbstractTableModel {
    public int disabledCount;
    public int disabledAndHiddenCount;
    private List<Filter> filters = new LinkedList<Filter>();
    private OSDLabel lblOSD = new OSDLabel("");

    public Filters() {
        this.loadPrefs();
    }

    public void executeFilters() {
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet == null) {
            return;
        }
        Collection<OsmPrimitive> collection = dataSet.allNonDeletedCompletePrimitives();
        final HashSet hashSet = new HashSet();
        this.clearFilterFlags();
        block5: for (Filter object : this.filters) {
            if (!object.enable.booleanValue()) continue;
            hashSet.clear();
            boolean osmPrimitive = object.mode == SearchAction.SearchMode.replace || object.mode == SearchAction.SearchMode.add;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CollectProperty
            implements Property<OsmPrimitive, Boolean> {
                boolean collectValue;
                boolean hidden;

                public CollectProperty(boolean bl, boolean bl2) {
                    this.collectValue = bl;
                    this.hidden = bl2;
                }

                @Override
                public Boolean get(OsmPrimitive osmPrimitive) {
                    if (this.hidden) {
                        return osmPrimitive.isDisabledAndHidden();
                    }
                    return osmPrimitive.isDisabled();
                }

                @Override
                public void set(OsmPrimitive osmPrimitive, Boolean bl) {
                    if (this.collectValue == bl) {
                        hashSet.add(osmPrimitive);
                    }
                }
            }
            CollectProperty collectProperty = new CollectProperty(osmPrimitive, object.hiding);
            SearchAction.getSelection((SearchAction.SearchSetting)object, collection, collectProperty);
            switch (object.mode) {
                case replace: {
                    for (OsmPrimitive osmPrimitive2 : collection) {
                        osmPrimitive2.unsetDisabledState();
                    }
                }
                case add: {
                    if (!object.inverted.booleanValue()) {
                        for (OsmPrimitive osmPrimitive2 : hashSet) {
                            osmPrimitive2.setDisabledState(object.hiding);
                        }
                        for (OsmPrimitive osmPrimitive2 : hashSet) {
                            if (!(osmPrimitive2 instanceof Way)) continue;
                            block9: for (Node node : ((Way)osmPrimitive2).getNodes()) {
                                if (node.isDisabledAndHidden() || !object.hiding.booleanValue() && node.isDisabled() || node.isTagged()) continue;
                                for (OsmPrimitive osmPrimitive3 : node.getReferrers()) {
                                    if (!(osmPrimitive3 instanceof Way) || osmPrimitive3.isDisabled() && (!object.hiding.booleanValue() || osmPrimitive3.isDisabledAndHidden())) continue;
                                    continue block9;
                                }
                                node.setDisabledState(object.hiding);
                            }
                        }
                        continue block5;
                    }
                    for (OsmPrimitive osmPrimitive2 : hashSet) {
                        if (osmPrimitive2 instanceof Node) continue;
                        osmPrimitive2.setDisabledState(object.hiding);
                    }
                    block12: for (OsmPrimitive osmPrimitive2 : hashSet) {
                        if (!(osmPrimitive2 instanceof Node) || osmPrimitive2.isDisabledAndHidden() || !object.hiding.booleanValue() && osmPrimitive2.isDisabled()) continue;
                        for (OsmPrimitive osmPrimitive4 : osmPrimitive2.getReferrers()) {
                            if (!(osmPrimitive4 instanceof Way) || osmPrimitive4.isDisabled() && (!object.hiding.booleanValue() || osmPrimitive4.isDisabledAndHidden())) continue;
                            continue block12;
                        }
                        osmPrimitive2.setDisabledState(object.hiding);
                    }
                    continue block5;
                }
                case remove: 
                case in_selection: {
                    if (!object.inverted.booleanValue()) {
                        for (OsmPrimitive osmPrimitive2 : hashSet) {
                            osmPrimitive2.unsetDisabledState();
                        }
                        for (OsmPrimitive osmPrimitive2 : hashSet) {
                            if (!(osmPrimitive2 instanceof Way)) continue;
                            for (Node node : ((Way)osmPrimitive2).getNodes()) {
                                node.unsetDisabledState();
                            }
                        }
                        continue block5;
                    }
                    for (OsmPrimitive osmPrimitive2 : hashSet) {
                        osmPrimitive2.unsetDisabledState();
                    }
                    for (OsmPrimitive osmPrimitive2 : hashSet) {
                        if (!(osmPrimitive2 instanceof Way)) continue;
                        for (Node node : ((Way)osmPrimitive2).getNodes()) {
                            node.unsetDisabledState();
                        }
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.disabledCount = 0;
        this.disabledAndHiddenCount = 0;
        HashSet hashSet2 = new HashSet();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isDisabled()) continue;
            ++this.disabledCount;
            if (osmPrimitive.isSelected()) {
                hashSet2.add(osmPrimitive);
            }
            if (!osmPrimitive.isDisabledAndHidden()) continue;
            ++this.disabledAndHiddenCount;
        }
        this.disabledCount -= this.disabledAndHiddenCount;
        if (!hashSet2.isEmpty()) {
            dataSet.clearSelection(hashSet2);
        }
        Main.map.mapView.repaint();
    }

    public void clearFilterFlags() {
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
                osmPrimitive.unsetDisabledState();
            }
        }
        this.disabledCount = 0;
        this.disabledAndHiddenCount = 0;
    }

    private void loadPrefs() {
        Map<String, String> map = Main.pref.getAllPrefix("filters.filter");
        for (String string : map.values()) {
            this.filters.add(new Filter(string));
        }
    }

    private void savePrefs() {
        Map<String, String> map = Main.pref.getAllPrefix("filters.filter");
        for (String object : map.keySet()) {
            String[] stringArray = object.split("\\.");
            if (stringArray.length != 3) {
                throw new Error("Incompatible filter preferences");
            }
            Main.pref.put("filters.filter." + stringArray[2], null);
        }
        int n = 0;
        for (Filter filter : this.filters) {
            Main.pref.put("filters.filter." + n++, filter.getPrefString());
        }
    }

    private void savePref(int n) {
        if (n >= this.filters.size()) {
            Main.pref.put("filters.filter." + n, null);
        } else {
            Main.pref.put("filters.filter." + n, this.filters.get(n).getPrefString());
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        this.savePref(this.filters.size() - 1);
        this.executeFilters();
        this.fireTableRowsInserted(this.filters.size() - 1, this.filters.size() - 1);
    }

    public void moveDownFilter(int n) {
        if (n >= this.filters.size() - 1) {
            return;
        }
        this.filters.add(n + 1, this.filters.remove(n));
        this.savePref(n);
        this.savePref(n + 1);
        this.executeFilters();
        this.fireTableRowsUpdated(n, n + 1);
    }

    public void moveUpFilter(int n) {
        if (n == 0) {
            return;
        }
        this.filters.add(n - 1, this.filters.remove(n));
        this.savePref(n);
        this.savePref(n - 1);
        this.executeFilters();
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void removeFilter(int n) {
        this.filters.remove(n);
        this.savePrefs();
        this.executeFilters();
        this.fireTableRowsDeleted(n, n);
    }

    public void setFilter(int n, Filter filter) {
        this.filters.set(n, filter);
        this.savePref(n);
        this.executeFilters();
        this.fireTableRowsUpdated(n, n);
    }

    public Filter getFilter(int n) {
        return this.filters.get(n);
    }

    @Override
    public int getRowCount() {
        return this.filters.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        String[] stringArray = new String[]{I18n.trc("filter", "E"), I18n.trc("filter", "H"), I18n.trc("filter", "Text"), I18n.trc("filter", "I"), I18n.trc("filter", "M")};
        return stringArray[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class[] classArray = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, String.class};
        return classArray[n];
    }

    public boolean isCellEnabled(int n, int n2) {
        return this.filters.get((int)n).enable != false || n2 == 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.filters.get((int)n).enable.booleanValue() && n2 != 0) {
            return false;
        }
        return n2 < 4;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Filter filter = this.filters.get(n);
        switch (n2) {
            case 0: {
                filter.enable = (Boolean)object;
                this.savePref(n);
                this.executeFilters();
                this.fireTableRowsUpdated(n, n);
                break;
            }
            case 1: {
                filter.hiding = (Boolean)object;
                this.savePref(n);
                this.executeFilters();
                break;
            }
            case 2: {
                filter.text = (String)object;
                this.savePref(n);
                break;
            }
            case 3: {
                filter.inverted = (Boolean)object;
                this.savePref(n);
                this.executeFilters();
            }
        }
        if (n2 != 0) {
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Filter filter = this.filters.get(n);
        switch (n2) {
            case 0: {
                return filter.enable;
            }
            case 1: {
                return filter.hiding;
            }
            case 2: {
                return filter.text;
            }
            case 3: {
                return filter.inverted;
            }
            case 4: {
                switch (filter.mode) {
                    case replace: {
                        return I18n.trc("filter", "R");
                    }
                    case add: {
                        return I18n.trc("filter", "A");
                    }
                    case remove: {
                        return I18n.trc("filter", "D");
                    }
                    case in_selection: {
                        return I18n.trc("filter", "F");
                    }
                }
            }
        }
        return null;
    }

    public void drawOSDText(Graphics2D graphics2D) {
        String string = "<html>" + I18n.tr("<h2>Filter active</h2>");
        if (this.disabledCount == 0 && this.disabledAndHiddenCount == 0) {
            return;
        }
        if (this.disabledAndHiddenCount != 0) {
            string = string + I18n.tr("<p><b>{0}</b> objects hidden", this.disabledAndHiddenCount);
        }
        if (this.disabledAndHiddenCount != 0 && this.disabledCount != 0) {
            string = string + "<br>";
        }
        if (this.disabledCount != 0) {
            string = string + I18n.tr("<b>{0}</b> objects disabled", this.disabledCount);
        }
        string = string + I18n.tr("</p><p>Close the filter dialog to see all objects.<p></html>");
        this.lblOSD.setText(string);
        this.lblOSD.setSize(this.lblOSD.getPreferredSize());
        int n = Main.map.mapView.getWidth() - this.lblOSD.getPreferredSize().width - 15;
        int n2 = 15;
        graphics2D.translate(n, n2);
        this.lblOSD.paintComponent(graphics2D);
        graphics2D.translate(-n, -n2);
    }

    private static class OSDLabel
    extends JLabel {
        public OSDLabel(String string) {
            super(string);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setFont(this.getFont().deriveFont(0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(255, 255, 255, 140));
            graphics.fillRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 10, 10);
            super.paintComponent(graphics);
        }
    }
}

