/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletedStateConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public DeletedStateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType mergeDecisionType) {
        this.conflict = conflict;
        this.decision = mergeDecisionType;
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.tr("Resolve conflicts in deleted state in {0}", this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        OsmDataLayer osmDataLayer = this.getLayer();
        if (this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.conflict.getMy().isDeleted() || this.conflict.isMyDeleted()) {
                osmDataLayer.data.unlinkReferencesToPrimitive(this.conflict.getMy());
                this.conflict.getMy().setDeleted(true);
            }
        } else if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
            if (this.conflict.getTheir().isDeleted()) {
                osmDataLayer.data.unlinkReferencesToPrimitive(this.conflict.getMy());
                this.conflict.getMy().setDeleted(true);
            } else {
                this.conflict.getMy().setDeleted(false);
            }
        } else {
            throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict."));
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
        collection.addAll(this.conflict.getMy().getReferrers());
    }
}

