/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways"), "wayflip", I18n.tr("Reverse the direction of all selected ways."), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways")), 82, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/ReverseWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection<Way> collection = this.getCurrentDataSet().getSelectedWays();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one way."), I18n.tr("Information"), 1);
            return;
        }
        boolean bl = false;
        ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Way way : collection) {
            Way way2 = new Way(way);
            List<Node> list = way2.getNodes();
            Collections.reverse(list);
            way2.setNodes(list);
            if (Main.pref.getBoolean("tag-correction.reverse-way", true)) {
                try {
                    Collection<Command> collection2 = reverseWayTagCorrector.execute(way, way2);
                    bl = bl || collection2 != null && !collection2.isEmpty();
                    linkedList.addAll(collection2);
                }
                catch (UserCancelException userCancelException) {
                    return;
                }
            }
            linkedList.add(new ChangeCommand(way, way2));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Reverse ways"), linkedList));
        if (bl) {
            this.getCurrentDataSet().fireSelectionChanged();
        }
        Main.map.repaint();
    }

    protected int getNumWaysInSelection() {
        if (this.getCurrentDataSet() == null) {
            return 0;
        }
        int n = 0;
        for (OsmPrimitive osmPrimitive : this.getCurrentDataSet().getSelected()) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        return n;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            this.setEnabled(false);
            return;
        }
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        this.setEnabled(n > 0);
    }
}

