/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CopyAction
extends JosmAction {
    private LinkedList<JosmAction> listeners;

    public CopyAction() {
        super(I18n.tr("Copy"), "copy", I18n.tr("Copy selected objects to paste buffer."), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy")), 67, 2), true);
        this.putValue("help", HelpUtil.ht("/Action/Copy"));
        this.listeners = new LinkedList();
    }

    @Override
    public void addListener(JosmAction josmAction) {
        this.listeners.add(josmAction);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEmptySelection()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        StringBuilder stringBuilder = new StringBuilder();
        for (OsmPrimitive object : collection) {
            stringBuilder.append(object.getId() + ",");
        }
        String string = stringBuilder.substring(0, stringBuilder.length() - 1);
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string.toString()), new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Main.pasteBuffer.makeCopy(collection);
        Main.pasteSource = this.getEditLayer();
        Main.main.menu.paste.setEnabled(true);
        for (JosmAction josmAction : this.listeners) {
            josmAction.pasteBufferChanged(Main.pasteBuffer);
        }
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private boolean isEmptySelection() {
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy."), I18n.tr("Information"), 1);
            return true;
        }
        return false;
    }
}

