/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import oauth.signpost.signature.SignatureBaseString;
import oauth.signpost.signature.SignatureMethod;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAuthMessageSigner
implements Serializable {
    private transient Base64 base64 = new Base64();
    private String consumerSecret;
    private String tokenSecret;

    public static OAuthMessageSigner create(SignatureMethod signatureMethod) {
        switch (signatureMethod) {
            case PLAINTEXT: {
                return new PlainTextMessageSigner();
            }
            case HMAC_SHA1: {
                return new HmacSha1MessageSigner();
            }
        }
        return null;
    }

    public abstract String sign(HttpRequest var1, Map<String, String> var2) throws OAuthMessageSignerException;

    protected String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    protected byte[] decodeBase64(String s) {
        return this.base64.decode(s.getBytes());
    }

    protected String base64Encode(byte[] b) {
        return new String(this.base64.encode(b));
    }

    protected String computeSignatureBaseString(HttpRequest request, Map<String, String> oauthParameters) throws OAuthMessageSignerException {
        SignatureBaseString sbs = new SignatureBaseString(request, oauthParameters);
        return sbs.compute();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.base64 = new Base64();
    }
}

