/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends FileImporter {
    public NMEAImporter() {
        super(new ExtensionFileFilter("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files") + " (*.nmea *.nme *.nma *.log *.txt)"));
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String string = file.getName();
        NmeaReader nmeaReader = new NmeaReader(new FileInputStream(file), file.getAbsoluteFile().getParentFile());
        if (nmeaReader.getNumberOfCoordinates() > 0) {
            nmeaReader.data.storageFile = file;
            GpxLayer gpxLayer = new GpxLayer(nmeaReader.data, string, true);
            Main.main.addLayer(gpxLayer);
            if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                MarkerLayer markerLayer = new MarkerLayer(nmeaReader.data, I18n.tr("Markers from {0}", string), file, gpxLayer);
                if (markerLayer.data.size() > 0) {
                    Main.main.addLayer(markerLayer);
                }
            }
        }
        this.showNmeaInfobox(nmeaReader.getNumberOfCoordinates() > 0, nmeaReader);
    }

    private void showNmeaInfobox(boolean bl, NmeaReader nmeaReader) {
        String string = I18n.tr("Coordinates imported: ") + nmeaReader.getNumberOfCoordinates() + "\n" + I18n.tr("Malformed sentences: ") + nmeaReader.getParserMalformed() + "\n" + I18n.tr("Checksum errors: ") + nmeaReader.getParserChecksumErrors() + "\n";
        if (!bl) {
            string = string + I18n.tr("Unknown sentences: ") + nmeaReader.getParserUnknown() + "\n";
        }
        string = string + I18n.tr("Zero coordinates: ") + nmeaReader.getParserZeroCoordinates();
        if (bl) {
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("NMEA import success"), 1);
        } else {
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("NMEA import failure!"), 0);
        }
    }
}

