/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.I18n;

public class BackupPreferencesPanel
extends VerticallyScrollablePanel {
    private JCheckBox keepBackup;

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keepBackup = new JCheckBox(I18n.tr("Keep backup files"));
        this.keepBackup.setSelected(Main.pref.getBoolean("save.keepbackup"));
        this.keepBackup.setToolTipText(I18n.tr("When saving, keep backup files ending with a ~"));
        this.add((Component)this.keepBackup, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public void saveToPreferences() {
        Main.pref.put("save.keepbackup", this.keepBackup.isSelected());
    }

    public void initFromPreferences() {
        this.keepBackup.setSelected(Main.pref.getBoolean("save.keepbackup", true));
    }

    public BackupPreferencesPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#BackupSettings"));
    }
}

