/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class CredentialDialog
extends JDialog {
    private boolean canceled;
    private CredentialPanel pnlCredentials;

    public static CredentialDialog getOsmApiCredentialDialog(String string, String string2) {
        CredentialDialog credentialDialog = new CredentialDialog();
        credentialDialog.prepareForOsmApiCredentials(string, string2);
        credentialDialog.pack();
        return credentialDialog;
    }

    public static CredentialDialog getHttpProxyCredentialDialog(String string, String string2) {
        CredentialDialog credentialDialog = new CredentialDialog();
        credentialDialog.prepareForProxyCredentials(string, string2);
        credentialDialog.pack();
        return credentialDialog;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            WindowGeometry.centerInWindow(Main.parent, new Dimension(350, 300)).apply(this);
        }
        super.setVisible(bl);
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new SideButton(new OKAction()));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/PasswordDialog"))));
        return jPanel;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.addWindowListener(new WindowEventHander());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getRootPane().getActionMap().put("escape", new CancelAction());
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public CredentialDialog() {
        this.setModal(true);
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            System.out.println(I18n.tr("Warning: failed to put Credential Dialog always on top. Caught security exception."));
        }
        this.build();
    }

    public void prepareForOsmApiCredentials(String string, String string2) {
        this.setTitle(I18n.tr("Enter credentials for OSM API"));
        this.pnlCredentials = new OsmApiCredentialsPanel();
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(string, string2);
        this.validate();
    }

    public void prepareForProxyCredentials(String string, String string2) {
        this.setTitle(I18n.tr("Enter credentials for HTTP proxy"));
        this.pnlCredentials = new HttpProxyCredentialsPanel();
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(string, string2);
        this.validate();
    }

    public String getUsername() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getUserName();
    }

    public char[] getPassword() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getPassword();
    }

    public boolean isSaveCredentials() {
        if (this.pnlCredentials == null) {
            return false;
        }
        return this.pnlCredentials.isSaveCredentials();
    }

    class WindowEventHander
    extends WindowAdapter {
        WindowEventHander() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (CredentialDialog.this.pnlCredentials != null) {
                CredentialDialog.this.pnlCredentials.startUserInput();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancel();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel authentication"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        public void cancel() {
            CredentialDialog.this.setCanceled(true);
            CredentialDialog.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("Authenticate"));
            this.putValue("ShortDescription", I18n.tr("Authenticate with the supplied username and password"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CredentialDialog.this.setCanceled(false);
            CredentialDialog.this.setVisible(false);
        }
    }

    private static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private SelectAllOnFocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTextField) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        }
    }

    private static class HttpProxyCredentialsPanel
    extends CredentialPanel {
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name for authenticating at your proxy server"));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password for authenticating at your proxy server"));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the HTTP proxy ''{0}'' failed. Please enter a valid username and a valid password.", System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort")) + "</html>");
            this.lblWarning.setText("<html>" + I18n.tr("Warning: depending on the authentication method the proxy server uses the password may be transferred unencrypted.") + "</html>");
        }

        public HttpProxyCredentialsPanel() {
            this.build();
        }
    }

    private static class OsmApiCredentialsPanel
    extends CredentialPanel {
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name of your OSM account"));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password of your OSM account"));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the OSM API ''{0}'' failed. Please enter a valid username and a valid password.", OsmApi.getOsmApi().getBaseUrl()) + "</html>");
            this.lblWarning.setText(I18n.tr("Warning: The password is transferred unencrypted."));
        }

        public OsmApiCredentialsPanel() {
            this.build();
        }
    }

    private static class CredentialPanel
    extends JPanel {
        protected JTextField tfUserName;
        protected JPasswordField tfPassword;
        protected JCheckBox cbSaveCredentials;
        protected JMultilineLabel lblHeading;
        protected JMultilineLabel lblWarning;

        protected void build() {
            this.tfUserName = new JTextField(20);
            this.tfPassword = new JPasswordField(20);
            this.tfUserName.addFocusListener(new SelectAllOnFocusHandler());
            this.tfPassword.addFocusListener(new SelectAllOnFocusHandler());
            this.cbSaveCredentials = new JCheckBox(I18n.tr("Save user and password (unencrypted)"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.lblHeading = new JMultilineLabel("");
            this.add((Component)this.lblHeading, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.add((Component)new JLabel(I18n.tr("Username")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.tfUserName, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Password")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.tfPassword, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.lblWarning = new JMultilineLabel("");
            this.lblWarning.setFont(this.lblWarning.getFont().deriveFont(2));
            this.add((Component)this.lblWarning, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)this.cbSaveCredentials, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        public void init(String string, String string2) {
            string = string == null ? "" : string;
            string2 = string2 == null ? "" : string2;
            this.tfUserName.setText(string);
            this.tfPassword.setText(string2);
            this.cbSaveCredentials.setSelected(!string.equals("") && !string2.equals(""));
        }

        public void startUserInput() {
            this.tfUserName.requestFocusInWindow();
        }

        public String getUserName() {
            return this.tfUserName.getText();
        }

        public char[] getPassword() {
            return this.tfPassword.getPassword();
        }

        public boolean isSaveCredentials() {
            return this.cbSaveCredentials.isSelected();
        }
    }
}

