/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User {
    private static AtomicLong uidCounter = new AtomicLong();
    private static HashMap<Long, User> userMap = new HashMap();
    private final HashSet<String> names = new HashSet();
    private final long uid;

    private static long getNextLocalUid() {
        return uidCounter.decrementAndGet();
    }

    public static User createLocalUser(String string) {
        User user = new User(User.getNextLocalUid(), string);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User createOsmUser(long l, String string) {
        User user = userMap.get(l);
        if (user == null) {
            user = new User(l, string);
            userMap.put(user.getId(), user);
        }
        user.addName(string);
        return user;
    }

    public static void clearUserMap() {
        userMap.clear();
    }

    public static User getById(long l) {
        return userMap.get(l);
    }

    public static List<User> getByName(String string) {
        if (string == null) {
            string = "";
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.names) {
            stringBuilder.append(string);
            stringBuilder.append('/');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public ArrayList<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String string) {
        this.names.add(string);
    }

    public boolean hasName(String string) {
        return this.names.contains(string);
    }

    public long getId() {
        return this.uid;
    }

    private User(long l, String string) {
        this.uid = l;
        if (string != null) {
            this.addName(string);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.uid == user.uid;
    }
}

