/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthogonalizeAction
extends JosmAction {
    private String USAGE = I18n.tr("<h3>When one or more ways are selected, the shape is adjusted such, that all angles are 90 or 180 degrees.</h3>You can add two nodes to the selection. Then, the direction is fixed by these two reference nodes. (Afterwards, you can undo the movement for certain nodes:<br>Select them and press the shortcut for Orthogonalize / Undo. The default is Shift-Q.)");
    private static final double TOLERANCE1 = Math.toRadians(45.0);
    private static final double TOLERANCE2 = Math.toRadians(45.0);
    private static final HashMap<Node, EastNorth> rememberMovements = new HashMap();

    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape"), "ortho", I18n.tr("Move nodes so all angles are 90 or 180 degrees"), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape")), 81, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/Orthogonalize"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        if ("EPSG:4326".equals(((Object)Main.proj).toString()) && !ConditionalOptionPaneUtil.showConfirmationDialog("align_rectangular_4326", Main.parent, object = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?</html>"), I18n.tr("Warning"), 0, 3, 0)) {
            return;
        }
        object = new ArrayList();
        ArrayList<WayData> arrayList = new ArrayList<WayData>();
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        try {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive instanceof Node) {
                    ((ArrayList)object).add((Node)osmPrimitive);
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) throw new InvalidUserInputException(I18n.tr("Selection must consist only of ways and nodes."));
                arrayList.add(new WayData((Way)osmPrimitive));
            }
            if (arrayList.isEmpty()) {
                throw new InvalidUserInputException("usage");
            }
            if (((ArrayList)object).size() != 2 && !((ArrayList)object).isEmpty()) throw new InvalidUserInputException("usage");
            rememberMovements.clear();
            LinkedList linkedList = new LinkedList();
            if (((ArrayList)object).size() == 2) {
                linkedList.addAll(OrthogonalizeAction.orthogonalize(arrayList, (ArrayList<Node>)object));
            } else {
                if (!((ArrayList)object).isEmpty()) throw new IllegalStateException();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (WayData wayData : arrayList) {
                    boolean bl = false;
                    for (ArrayList arrayList3 : arrayList2) {
                        for (WayData wayData2 : arrayList3) {
                            if (Collections.disjoint(wayData.way.getNodes(), wayData2.way.getNodes())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        arrayList3.add(wayData);
                    }
                    if (bl) continue;
                    ArrayList arrayList4 = new ArrayList();
                    arrayList4.add(wayData);
                    arrayList2.add(arrayList4);
                }
                for (ArrayList arrayList5 : arrayList2) {
                    linkedList.addAll(OrthogonalizeAction.orthogonalize(arrayList5, (ArrayList<Node>)object));
                }
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize"), linkedList));
            Main.map.repaint();
            return;
        }
        catch (InvalidUserInputException invalidUserInputException) {
            if (invalidUserInputException.getMessage().equals("usage")) {
                JOptionPane.showMessageDialog(Main.parent, "<html><h2>" + I18n.tr("Usage") + "</h2>" + this.USAGE + "</html>", I18n.tr("Orthogonalize Shape"), 1);
                return;
            }
            JOptionPane.showMessageDialog(Main.parent, "<html>" + invalidUserInputException.getMessage() + "<br><hr><h2>" + I18n.tr("Usage") + "</h2>" + this.USAGE + "</html>", I18n.tr("Selected Elements cannot be orthogonalized"), 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<Command> orthogonalize(ArrayList<WayData> arrayList, ArrayList<Node> arrayList2) throws InvalidUserInputException {
        Direction[][] directionArrayArray;
        void var7_18;
        double d;
        try {
            if (arrayList2.isEmpty()) {
                void var6_8;
                arrayList.get(0).calcDirections(Direction.RIGHT);
                double d2 = arrayList.get((int)0).heading;
                for (WayData wayData : arrayList) {
                    wayData.calcDirections(Direction.RIGHT);
                    int n = OrthogonalizeAction.angleToDirectionChange(wayData.heading - d2, TOLERANCE2);
                    wayData.calcDirections(Direction.RIGHT.changeBy(n));
                    if (OrthogonalizeAction.angleToDirectionChange(d2 - wayData.heading, TOLERANCE2) == 0) continue;
                    throw new RuntimeException();
                }
                EastNorth n = new EastNorth(0.0, 0.0);
                for (WayData wayData : arrayList) {
                    EastNorth eastNorth = EN.sum((EastNorth)var6_8, wayData.segSum);
                }
                d = EN.polar(new EastNorth(0.0, 0.0), (EastNorth)var6_8);
            } else {
                d = EN.polar(arrayList2.get(0).getEastNorth(), arrayList2.get(1).getEastNorth());
                for (WayData wayData : arrayList) {
                    wayData.calcDirections(Direction.RIGHT);
                    int n = OrthogonalizeAction.angleToDirectionChange(wayData.heading - d, TOLERANCE2);
                    wayData.calcDirections(Direction.RIGHT.changeBy(n));
                }
            }
        }
        catch (RejectedAngleException rejectedAngleException) {
            throw new InvalidUserInputException(I18n.tr("<html>Please make sure all selected ways head in a similar direction<br>or orthogonalize them one by one.</html>"));
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        for (WayData wayData : arrayList) {
            for (Node node : wayData.way.getNodes()) {
                hashSet.add(node);
            }
        }
        HashMap<Node, Double> hashMap = new HashMap<Node, Double>();
        HashMap<Node, Double> hashMap2 = new HashMap<Node, Double>();
        EastNorth eastNorth = new EastNorth(0.0, 0.0);
        for (Node node : hashSet) {
            EastNorth eastNorth2 = EN.sum((EastNorth)var7_18, node.getEastNorth());
        }
        EastNorth eastNorth3 = new EastNorth(var7_18.east() / (double)hashSet.size(), var7_18.north() / (double)hashSet.size());
        for (Node node : hashSet) {
            directionArrayArray = EN.rotate_cc(eastNorth3, node.getEastNorth(), -d);
            hashMap.put(node, directionArrayArray.east());
            hashMap2.put(node, directionArrayArray.north());
        }
        Direction[] directionArray = new Direction[]{Direction.RIGHT, Direction.LEFT};
        Direction[] directionArray2 = new Direction[]{Direction.UP, Direction.DOWN};
        directionArrayArray = new Direction[][]{directionArray, directionArray2};
        for (Direction[] directionArray3 : directionArrayArray) {
            HashSet hashSet2 = new HashSet(hashSet);
            int n = hashSet2.size();
            for (int i = 0; i < n && !hashSet2.isEmpty(); ++i) {
                Node node = (Node)hashSet2.iterator().next();
                HashSet<Object> hashSet3 = new HashSet<Object>();
                hashSet3.add(node);
                boolean bl = true;
                while (bl) {
                    bl = false;
                    for (WayData wayData : arrayList) {
                        for (int j = 0; j < wayData.nSeg; ++j) {
                            Iterator iterator = wayData.way.getNodes().get(j);
                            Node node2 = wayData.way.getNodes().get(j + 1);
                            if (!Arrays.asList(directionArray3).contains((Object)wayData.segDirections[j])) continue;
                            if (hashSet3.contains(iterator) && !hashSet3.contains(node2)) {
                                hashSet3.add(node2);
                                bl = true;
                            }
                            if (!hashSet3.contains(node2) || hashSet3.contains(iterator)) continue;
                            hashSet3.add(iterator);
                            bl = true;
                        }
                    }
                }
                HashMap<Node, Double> hashMap3 = directionArray3 == directionArray ? hashMap2 : hashMap;
                double d2 = 0.0;
                for (Node node3 : hashSet3) {
                    d2 += ((Double)hashMap3.get(node3)).doubleValue();
                }
                d2 /= (double)hashSet3.size();
                for (Node node4 : arrayList2) {
                    if (!hashSet3.contains(node4)) continue;
                    d2 = (Double)hashMap3.get(node4);
                }
                for (Node node5 : hashSet3) {
                    hashMap3.put(node5, d2);
                }
                for (Node node6 : hashSet3) {
                    hashSet2.remove(node6);
                }
            }
            if (hashSet2.isEmpty()) continue;
            throw new RuntimeException();
        }
        LinkedList linkedList = new LinkedList();
        for (Node node : hashSet) {
            EastNorth eastNorth5 = new EastNorth((Double)hashMap.get(node), (Double)hashMap2.get(node));
            eastNorth5 = EN.rotate_cc(eastNorth3, eastNorth5, d);
            double d3 = eastNorth5.east() - node.getEastNorth().east();
            double d4 = eastNorth5.north() - node.getEastNorth().north();
            if (arrayList2.contains(node)) {
                if (Math.abs(d3) > Math.abs(1.0E-6 * eastNorth5.east()) || Math.abs(d4) > Math.abs(1.0E-6 * eastNorth5.east())) {
                    throw new AssertionError();
                }
                continue;
            }
            rememberMovements.put(node, new EastNorth(d3, d4));
            linkedList.add(new MoveCommand(node, d3, d4));
        }
        return linkedList;
    }

    private static double standard_angle_0_to_2PI(double d) {
        while (d >= Math.PI * 2) {
            d -= Math.PI * 2;
        }
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    private static double standard_angle_mPI_to_PI(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d <= -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    private static int angleToDirectionChange(double d, double d2) throws RejectedAngleException {
        int n;
        d = OrthogonalizeAction.standard_angle_mPI_to_PI(d);
        double d3 = Math.abs(d);
        double d4 = Math.abs(d - 1.5707963267948966);
        double d5 = Math.abs(d + 1.5707963267948966);
        if (d3 < d2) {
            n = 0;
        } else if (d4 < d2) {
            n = 1;
        } else if (d5 < d2) {
            n = -1;
        } else {
            double d6 = Math.abs((d = OrthogonalizeAction.standard_angle_0_to_2PI(d)) - Math.PI);
            if (d6 < d2) {
                n = 2;
            } else {
                throw new RejectedAngleException();
            }
        }
        return n;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null);
    }

    private static class RejectedAngleException
    extends Exception {
        RejectedAngleException() {
        }
    }

    private static class InvalidUserInputException
    extends Exception {
        InvalidUserInputException(String string) {
            super(string);
        }

        InvalidUserInputException() {
        }
    }

    private static class EN {
        private EN() {
        }

        public static EastNorth rotate_cc(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = eastNorth2.east() - eastNorth.east();
            double d5 = eastNorth2.north() - eastNorth.north();
            double d6 = d2 * d4 - d3 * d5 + eastNorth.east();
            double d7 = d3 * d4 + d2 * d5 + eastNorth.north();
            return new EastNorth(d6, d7);
        }

        public static EastNorth sum(EastNorth eastNorth, EastNorth eastNorth2) {
            return new EastNorth(eastNorth.east() + eastNorth2.east(), eastNorth.north() + eastNorth2.north());
        }

        public static EastNorth diff(EastNorth eastNorth, EastNorth eastNorth2) {
            return new EastNorth(eastNorth.east() - eastNorth2.east(), eastNorth.north() - eastNorth2.north());
        }

        public static double polar(EastNorth eastNorth, EastNorth eastNorth2) {
            return Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        RIGHT,
        UP,
        LEFT,
        DOWN;


        public Direction changeBy(int n) {
            int n2 = (this.ordinal() + n) % 4;
            if (n2 < 0) {
                n2 += 4;
            }
            return Direction.values()[n2];
        }
    }

    private static class WayData {
        public final Way way;
        public final int nSeg;
        public final int nNode;
        public Direction[] segDirections;
        public EastNorth segSum;
        public double heading;

        public WayData(Way way) {
            this.way = way;
            this.nNode = this.way.getNodes().size();
            this.nSeg = this.nNode - 1;
        }

        public void calcDirections(Direction direction) throws InvalidUserInputException {
            Direction direction2;
            EastNorth[] eastNorthArray = new EastNorth[this.nNode];
            for (int i = 0; i < this.nNode; ++i) {
                eastNorthArray[i] = new EastNorth(this.way.getNodes().get(i).getEastNorth().east(), this.way.getNodes().get(i).getEastNorth().north());
            }
            this.segDirections = new Direction[this.nSeg];
            this.segDirections[0] = direction2 = direction;
            for (int i = 0; i < this.nSeg - 1; ++i) {
                double d = EN.polar(eastNorthArray[i], eastNorthArray[i + 1]);
                double d2 = EN.polar(eastNorthArray[i + 1], eastNorthArray[i + 2]);
                try {
                    direction2 = direction2.changeBy(OrthogonalizeAction.angleToDirectionChange(d2 - d, TOLERANCE1));
                }
                catch (RejectedAngleException rejectedAngleException) {
                    throw new InvalidUserInputException(I18n.tr("Please select ways with angles of approximately 90 or 180 degrees."));
                }
                this.segDirections[i + 1] = direction2;
            }
            EastNorth eastNorth = new EastNorth(0.0, 0.0);
            EastNorth eastNorth2 = new EastNorth(0.0, 0.0);
            for (int i = 0; i < this.nSeg; ++i) {
                EastNorth eastNorth3 = EN.diff(eastNorthArray[i + 1], eastNorthArray[i]);
                if (this.segDirections[i] == Direction.RIGHT) {
                    eastNorth = EN.sum(eastNorth, eastNorth3);
                    continue;
                }
                if (this.segDirections[i] == Direction.UP) {
                    eastNorth2 = EN.sum(eastNorth2, eastNorth3);
                    continue;
                }
                if (this.segDirections[i] == Direction.LEFT) {
                    eastNorth = EN.diff(eastNorth, eastNorth3);
                    continue;
                }
                if (this.segDirections[i] == Direction.DOWN) {
                    eastNorth2 = EN.diff(eastNorth2, eastNorth3);
                    continue;
                }
                throw new IllegalStateException();
            }
            this.segSum = EN.sum(eastNorth, new EastNorth(eastNorth2.north(), -eastNorth2.east()));
            this.heading = EN.polar(new EastNorth(0.0, 0.0), this.segSum);
        }
    }

    public static class Undo
    extends JosmAction {
        public Undo() {
            super(I18n.tr("Orthogonalize Shape / Undo"), "ortho", I18n.tr("Undo orthogonalization for certain nodes"), Shortcut.registerShortcut("tools:orthogonalizeUndo", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape / Undo")), 81, 3, 1), true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<Command> linkedList = new LinkedList<Command>();
            Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
            try {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!(osmPrimitive instanceof Node)) {
                        throw new InvalidUserInputException();
                    }
                    Node node = (Node)osmPrimitive;
                    if (!rememberMovements.containsKey(node)) continue;
                    EastNorth eastNorth = (EastNorth)rememberMovements.get(node);
                    linkedList.add(new MoveCommand(node, -eastNorth.east(), -eastNorth.north()));
                    rememberMovements.remove(node);
                }
                if (linkedList.size() <= 0) {
                    throw new InvalidUserInputException();
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize / Undo"), linkedList));
                Main.map.repaint();
            }
            catch (InvalidUserInputException invalidUserInputException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Orthogonalize Shape / Undo\nPlease select nodes that were moved by the previous Orthogonalize Shape action!"), I18n.tr("Undo Orthogonalize Shape"), 1);
            }
        }
    }
}

