/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oauth.signpost.OAuth;
import oauth.signpost.Parameter;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureBaseString {
    private HttpRequest request;
    private Map<String, String> oauthParams;

    public SignatureBaseString(HttpRequest request, Map<String, String> oauthParams) {
        this.request = request;
        this.oauthParams = oauthParams;
    }

    public String compute() throws OAuthMessageSignerException {
        try {
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            this.collectHeaderParameters(params);
            this.collectBodyParameters(params);
            String requestUrl = this.collectQueryParameters(params);
            return this.request.getMethod() + '&' + OAuth.percentEncode(this.normalizeUrl(requestUrl)) + '&' + OAuth.percentEncode(this.normalizeParameters(params));
        }
        catch (Exception e) {
            throw new OAuthMessageSignerException(e);
        }
    }

    public String normalizeUrl(String url) throws URISyntaxException {
        String path;
        int index;
        boolean dropPort;
        URI uri = new URI(url);
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    public String normalizeParameters(Collection<Parameter> parameters) throws IOException {
        if (parameters == null) {
            return "";
        }
        ArrayList<ComparableParameter> p = new ArrayList<ComparableParameter>(parameters.size());
        for (Parameter parameter : parameters) {
            if ("oauth_signature".equals(parameter.getKey())) continue;
            p.add(new ComparableParameter(parameter));
        }
        Collections.sort(p);
        return OAuth.formEncode(this.getParameters(p));
    }

    private void collectHeaderParameters(Collection<Parameter> parameters) {
        for (String key : this.oauthParams.keySet()) {
            parameters.add(new Parameter(key, this.oauthParams.get(key)));
        }
    }

    private void collectBodyParameters(Collection<Parameter> parameters) throws IOException {
        String contentType = this.request.getContentType();
        if (contentType != null && contentType.equals("application/x-www-form-urlencoded")) {
            InputStream payload = this.request.getMessagePayload();
            parameters.addAll(OAuth.decodeForm(payload));
        }
    }

    private String collectQueryParameters(Collection<Parameter> parameters) {
        String url = this.request.getRequestUrl();
        int q = url.indexOf(63);
        if (q >= 0) {
            parameters.addAll(OAuth.decodeForm(url.substring(q + 1)));
            url = url.substring(0, q);
        }
        return url;
    }

    private List<Parameter> getParameters(Collection<ComparableParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Parameter> list = new ArrayList<Parameter>(parameters.size());
        for (ComparableParameter parameter : parameters) {
            list.add(parameter.value);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Parameter value;
        private final String key;

        ComparableParameter(Parameter value) {
            this.value = value;
            String n = ComparableParameter.safeString(value.getKey());
            String v = ComparableParameter.safeString(value.getValue());
            this.key = OAuth.percentEncode(n) + ' ' + OAuth.percentEncode(v);
        }

        private static String safeString(String from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.key.compareTo(that.key);
        }

        public String toString() {
            return this.key;
        }
    }
}

