/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPainter {
    private final Graphics2D g;
    private final NavigatableComponent nc;
    private final boolean inactive;
    private final boolean useStrokes;
    private final boolean showNames;
    private final boolean showIcons;
    private final Color inactiveColor;
    private final Color textColor;
    private final Color selectedColor;
    private final Color areaTextColor;
    private final Color nodeColor;
    private final Color backgroundColor;
    private final Font orderFont;
    private final int fillAlpha;
    private final int virtualNodeSize;
    private final int virtualNodeSpace;
    private final int segmentNumberSpace;
    private final double circum;
    private final Collection<String> regionalNameOrder;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);

    public MapPainter(MapPaintSettings mapPaintSettings, Graphics2D graphics2D, boolean bl, NavigatableComponent navigatableComponent, boolean bl2, double d, double d2) {
        this.g = graphics2D;
        this.inactive = bl;
        this.nc = navigatableComponent;
        this.useStrokes = (double)mapPaintSettings.getUseStrokesDistance() > d;
        this.showNames = (double)mapPaintSettings.getShowNamesDistance() > d;
        this.showIcons = (double)mapPaintSettings.getShowIconsDistance() > d;
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.textColor = PaintColors.TEXT.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.areaTextColor = PaintColors.AREA_TEXT.get();
        this.nodeColor = PaintColors.NODE.get();
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Helvetica"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.fillAlpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
        this.virtualNodeSize = bl2 ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        String[] stringArray = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        this.regionalNameOrder = Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(stringArray));
        this.circum = d2;
    }

    public void drawWay(Way way, Color color, int n, float[] fArray, Color color2, boolean bl, boolean bl2, boolean bl3) {
        GeneralPath generalPath = new GeneralPath();
        Point point = null;
        Iterator<Node> iterator = way.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Point point2 = this.nc.getPoint(node);
            if (point != null) {
                this.drawSegment(generalPath, point, point2, bl3 ? !iterator.hasNext() : bl, bl2);
            }
            point = point2;
        }
        this.displaySegments(generalPath, color, n, fArray, color2);
    }

    private void displaySegments(GeneralPath generalPath, Color color, int n, float[] fArray, Color color2) {
        this.g.setColor(this.inactive ? this.inactiveColor : color);
        if (this.useStrokes) {
            if (fArray.length > 0) {
                this.g.setStroke(new BasicStroke(n, 0, 1, 0.0f, fArray, 0.0f));
            } else {
                this.g.setStroke(new BasicStroke(n, 1, 1));
            }
        }
        this.g.draw(generalPath);
        if (!this.inactive && this.useStrokes && color2 != null) {
            this.g.setColor(color2);
            if (fArray.length > 0) {
                float[] fArray2 = new float[fArray.length];
                System.arraycopy(fArray, 1, fArray2, 0, fArray.length - 1);
                fArray2[fArray.length - 1] = fArray[0];
                float f = fArray2[0];
                this.g.setStroke(new BasicStroke(n, 0, 1, 0.0f, fArray2, f));
            } else {
                this.g.setStroke(new BasicStroke(n, 1, 1));
            }
            this.g.draw(generalPath);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private void drawSegment(GeneralPath generalPath, Point point, Point point2, boolean bl, boolean bl2) {
        Object object;
        Cloneable cloneable;
        boolean bl3 = false;
        if (Main.isOpenjdk) {
            cloneable = this.g.getClipBounds();
            ((Rectangle)cloneable).grow(100, 100);
            object = new LineClip();
            bl3 = ((LineClip)object).cohenSutherland(point.x, point.y, point2.x, point2.y, ((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).x + ((Rectangle)cloneable).width, ((Rectangle)cloneable).y + ((Rectangle)cloneable).height);
            point = ((LineClip)object).getP1();
            point2 = ((LineClip)object).getP2();
        } else {
            bl3 = this.isSegmentVisible(point, point2);
        }
        if (bl3) {
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point2.x, point2.y);
            if (bl) {
                cloneable = point;
                object = point2;
                if (bl2) {
                    cloneable = point2;
                    object = point;
                    generalPath.moveTo(((Point)object).x, ((Point)object).y);
                }
                double d = 10.0 / ((Point2D)cloneable).distance((Point2D)object);
                double d2 = d * (double)(((Point)cloneable).x - ((Point)object).x);
                double d3 = d * (double)(((Point)cloneable).y - ((Point)object).y);
                generalPath.lineTo(((Point)object).x + (int)Math.round(cosPHI * d2 - sinPHI * d3), ((Point)object).y + (int)Math.round(sinPHI * d2 + cosPHI * d3));
                generalPath.moveTo(((Point)object).x + (int)Math.round(cosPHI * d2 + sinPHI * d3), ((Point)object).y + (int)Math.round(-sinPHI * d2 + cosPHI * d3));
                generalPath.lineTo(((Point)object).x, ((Point)object).y);
            }
        }
    }

    private boolean isSegmentVisible(Point point, Point point2) {
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.nc.getWidth() && point2.x > this.nc.getWidth()) {
            return false;
        }
        return point.y <= this.nc.getHeight() || point2.y <= this.nc.getHeight();
    }

    public void drawNodeIcon(Node node, ImageIcon imageIcon, boolean bl, boolean bl2, String string) {
        Point point = this.nc.getPoint(node);
        if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
            return;
        }
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        imageIcon.paintIcon(this.nc, this.g, point.x - n / 2, point.y - n2 / 2);
        if (string != null) {
            if (this.inactive || node.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(this.textColor);
            }
            Font font = this.g.getFont();
            this.g.setFont(this.orderFont);
            this.g.drawString(string, point.x + n / 2 + 2, point.y + n2 / 2 + 2);
            this.g.setFont(font);
        }
        if (bl2) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect(point.x - n / 2 - 2, point.y - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    public void drawNode(Node node, Color color, int n, boolean bl, String string) {
        if (n > 1) {
            int n2 = n / 2;
            Point point = this.nc.getPoint(node);
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            if (this.inactive || node.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            if (bl) {
                this.g.fillRect(point.x - n2, point.y - n2, n, n);
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            } else {
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            }
            if (string != null) {
                if (this.inactive || node.isDisabled()) {
                    this.g.setColor(this.inactiveColor);
                } else {
                    this.g.setColor(this.textColor);
                }
                Font font = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(string, point.x + n2 + 2, point.y + n2 + 2);
                this.g.setFont(font);
            }
        }
    }

    protected void drawArea(Polygon polygon, Color color, String string) {
        this.g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        this.g.fillPolygon(polygon);
        if (string != null) {
            Rectangle rectangle = polygon.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g);
            Rectangle rectangle2 = new Rectangle(rectangle.x + (int)(((double)rectangle.width - rectangle2D.getWidth()) / 2.0), rectangle.y + (int)(((double)rectangle.height - rectangle2D.getHeight()) / 2.0), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            if ((double)rectangle.width >= rectangle2D.getWidth() && (double)rectangle.height >= rectangle2D.getHeight() && polygon.contains(rectangle2)) {
                this.g.setColor(this.areaTextColor);
                Font font = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(string, (int)(rectangle2.getMinX() - rectangle2D.getMinX()), (int)(rectangle2.getMinY() - rectangle2D.getMinY()));
                this.g.setFont(font);
            }
        }
    }

    public void drawRestriction(ImageIcon imageIcon, Point point, double d, double d2, double d3, double d4, double d5, boolean bl) {
        ImageIcon imageIcon2 = ImageProvider.createRotatedImage(null, imageIcon, d5);
        ImageIcon imageIcon3 = new ImageIcon(imageIcon2.getImage().getScaledInstance(16, 16, 4));
        int n = imageIcon3.getIconWidth();
        int n2 = imageIcon3.getIconHeight();
        imageIcon3.paintIcon(this.nc, this.g, (int)((double)point.x + d + d2) - n / 2, (int)((double)point.y + d3 + d4) - n2 / 2);
        if (bl) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect((int)((double)point.x + d + d2) - n / 2 - 2, (int)((double)point.y + d3 + d4) - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    public void drawVirtualNodes(Collection<Way> collection) {
        if (this.virtualNodeSize != 0) {
            GeneralPath generalPath = new GeneralPath();
            for (Way way : collection) {
                if (!way.isUsable() || way.isFiltered()) continue;
                this.visitVirtual(generalPath, way);
            }
            this.g.setColor(this.nodeColor);
            this.g.draw(generalPath);
        }
    }

    public void visitVirtual(GeneralPath generalPath, Way way) {
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                if (this.isSegmentVisible(point, point2) && MapPainter.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                    int n = (point2.x + point.x) / 2;
                    int n2 = (point2.y + point.y) / 2;
                    generalPath.moveTo(n - this.virtualNodeSize, n2);
                    generalPath.lineTo(n + this.virtualNodeSize, n2);
                    generalPath.moveTo(n, n2 - this.virtualNodeSize);
                    generalPath.lineTo(n, n2 + this.virtualNodeSize);
                }
                point = point2;
            }
        }
    }

    private static boolean isLargeSegment(Point point, Point point2, int n) {
        int n2;
        int n3 = point.x - point2.x;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = point.y - point2.y) < 0) {
            n2 = -n2;
        }
        return n3 + n2 > n;
    }

    public void drawOrderNumber(Node node, Node node2, int n) {
        Point point = this.nc.getPoint(node);
        Point point2 = this.nc.getPoint(node2);
        this.drawOrderNumber(point, point2, n);
    }

    protected void drawOrderNumber(Point point, Point point2, int n) {
        if (this.isSegmentVisible(point, point2) && MapPainter.isLargeSegment(point, point2, this.segmentNumberSpace)) {
            String string = Integer.toString(n);
            int n2 = string.length();
            int n3 = (point.x + point2.x) / 2 - 4 * n2;
            int n4 = (point.y + point2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && MapPainter.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                n4 = (point.y + point2.y) / 2 - this.virtualNodeSize - 3;
            }
            Color color = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(n3 - 1, n4 - 12, 8 * n2 + 1, 14);
            this.g.setColor(color);
            this.g.drawString(string, n3, n4);
        }
    }

    public String getNodeName(Node node) {
        String string;
        block1: {
            String string2;
            string = null;
            if (!node.hasKeys()) break block1;
            Iterator<String> iterator = this.regionalNameOrder.iterator();
            while (iterator.hasNext() && (string = node.get(string2 = iterator.next())) == null) {
            }
        }
        return string;
    }

    public String getWayName(Way way) {
        String string;
        block1: {
            String string2;
            string = null;
            if (!way.hasKeys()) break block1;
            Iterator<String> iterator = this.regionalNameOrder.iterator();
            while (iterator.hasNext() && (string = way.get(string2 = iterator.next())) == null) {
            }
        }
        return string;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public double getCircum() {
        return this.circum;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }
}

