/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIDataSet {
    private LinkedList<OsmPrimitive> toAdd = new LinkedList();
    private LinkedList<OsmPrimitive> toUpdate = new LinkedList();
    private LinkedList<OsmPrimitive> toDelete = new LinkedList();

    public APIDataSet() {
    }

    public void init(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        this.toAdd.clear();
        this.toUpdate.clear();
        this.toDelete.clear();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (osmPrimitive.get("josm/ignore") != null) continue;
            if (osmPrimitive.isNew() && !osmPrimitive.isDeleted()) {
                this.toAdd.add(osmPrimitive);
                continue;
            }
            if (osmPrimitive.isModified() && !osmPrimitive.isDeleted()) {
                this.toUpdate.add(osmPrimitive);
                continue;
            }
            if (!osmPrimitive.isDeleted() || osmPrimitive.isNew() || !osmPrimitive.isModified()) continue;
            this.toDelete.add(osmPrimitive);
        }
        this.sortDeleted();
        this.sortNew();
    }

    protected void sortDeleted() {
        Collections.sort(this.toDelete, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                if (osmPrimitive instanceof Node && osmPrimitive2 instanceof Node) {
                    return 0;
                }
                if (osmPrimitive instanceof Node) {
                    return 1;
                }
                if (osmPrimitive2 instanceof Node) {
                    return -1;
                }
                if (osmPrimitive instanceof Way && osmPrimitive2 instanceof Way) {
                    return 0;
                }
                if (osmPrimitive instanceof Way && osmPrimitive2 instanceof Relation) {
                    return 1;
                }
                if (osmPrimitive2 instanceof Way && osmPrimitive instanceof Relation) {
                    return -1;
                }
                return 0;
            }
        });
    }

    protected void sortNew() {
        Collections.sort(this.toAdd, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                if (osmPrimitive instanceof Node && osmPrimitive2 instanceof Node) {
                    return 0;
                }
                if (osmPrimitive instanceof Node) {
                    return -1;
                }
                if (osmPrimitive2 instanceof Node) {
                    return 1;
                }
                if (osmPrimitive instanceof Way && osmPrimitive2 instanceof Way) {
                    return 0;
                }
                if (osmPrimitive instanceof Way && osmPrimitive2 instanceof Relation) {
                    return -1;
                }
                if (osmPrimitive2 instanceof Way && osmPrimitive instanceof Relation) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public APIDataSet(DataSet dataSet) {
        this();
        this.init(dataSet);
    }

    public boolean participatesInConflict(Conflict<?> conflict) {
        if (conflict == null) {
            return false;
        }
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!conflict.isParticipating(osmPrimitive)) continue;
            return true;
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (!conflict.isParticipating(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    public boolean participatesInConflict(ConflictCollection conflictCollection) {
        if (conflictCollection == null || conflictCollection.isEmpty()) {
            return false;
        }
        HashSet<PrimitiveId> hashSet = new HashSet<PrimitiveId>();
        for (OsmPrimitive osmPrimitive : conflictCollection.getMyConflictParties()) {
            hashSet.add(osmPrimitive.getPrimitiveId());
        }
        for (OsmPrimitive osmPrimitive : conflictCollection.getTheirConflictParties()) {
            hashSet.add(osmPrimitive.getPrimitiveId());
        }
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!hashSet.contains(osmPrimitive.getPrimitiveId())) continue;
            return true;
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (!hashSet.contains(osmPrimitive.getPrimitiveId())) continue;
            return true;
        }
        return false;
    }

    public APIDataSet(Collection<OsmPrimitive> collection) {
        this();
        this.toAdd.clear();
        this.toUpdate.clear();
        this.toDelete.clear();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isNew() && !osmPrimitive.isDeleted()) {
                this.toAdd.addLast(osmPrimitive);
                continue;
            }
            if (osmPrimitive.isModified() && !osmPrimitive.isDeleted()) {
                this.toUpdate.addLast(osmPrimitive);
                continue;
            }
            if (!osmPrimitive.isDeleted() || osmPrimitive.isNew() || !osmPrimitive.isModified()) continue;
            this.toDelete.addFirst(osmPrimitive);
        }
        this.sortNew();
        this.sortDeleted();
    }

    public boolean isEmpty() {
        return this.toAdd.isEmpty() && this.toUpdate.isEmpty() && this.toDelete.isEmpty();
    }

    public List<OsmPrimitive> getPrimitivesToAdd() {
        return this.toAdd;
    }

    public List<OsmPrimitive> getPrimitivesToUpdate() {
        return this.toUpdate;
    }

    public List<OsmPrimitive> getPrimitivesToDelete() {
        return this.toDelete;
    }

    public List<OsmPrimitive> getPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(this.toAdd);
        linkedList.addAll(this.toUpdate);
        linkedList.addAll(this.toDelete);
        return linkedList;
    }

    public int getSize() {
        return this.toAdd.size() + this.toUpdate.size() + this.toDelete.size();
    }

    public void removeProcessed(Collection<OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        this.toAdd.removeAll(collection);
        this.toUpdate.removeAll(collection);
        this.toDelete.removeAll(collection);
    }

    public void adjustRelationUploadOrder() throws CyclicUploadDependencyException {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(OsmPrimitive.getFilteredList(this.toAdd, Node.class));
        linkedList.addAll(OsmPrimitive.getFilteredList(this.toAdd, Way.class));
        List<Relation> list = OsmPrimitive.getFilteredList(this.toAdd, Relation.class);
        List<Relation> list2 = this.filterRelationsNotReferringToNewRelations(list);
        linkedList.addAll(list2);
        list.removeAll(list2);
        RelationUploadDependencyGraph relationUploadDependencyGraph = new RelationUploadDependencyGraph(list);
        linkedList.addAll(relationUploadDependencyGraph.computeUploadOrder());
        this.toAdd = linkedList;
    }

    protected List<Relation> filterRelationsNotReferringToNewRelations(Collection<Relation> collection) {
        LinkedList<Relation> linkedList = new LinkedList<Relation>();
        for (Relation relation : collection) {
            boolean bl = false;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isRelation() || !relationMember.getMember().isNew()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            linkedList.add(relation);
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationUploadDependencyGraph {
        private final Logger logger = Logger.getLogger(RelationUploadDependencyGraph.class.getName());
        private HashMap<Relation, Set<Relation>> children = new HashMap();
        private Collection<Relation> relations;
        private Set<Relation> visited = new HashSet<Relation>();
        private List<Relation> uploadOrder;

        public RelationUploadDependencyGraph() {
        }

        public RelationUploadDependencyGraph(Collection<Relation> collection) {
            this();
            this.build(collection);
        }

        public void build(Collection<Relation> collection) {
            this.relations = new HashSet<Relation>();
            for (Relation relation : collection) {
                if (!relation.isNew()) continue;
                this.relations.add(relation);
                for (RelationMember relationMember : relation.getMembers()) {
                    if (!relationMember.isRelation() || !relationMember.getMember().isNew()) continue;
                    this.addDependency(relation, (Relation)relationMember.getMember());
                }
            }
        }

        public Set<Relation> getChildren(Relation relation) {
            Set<Relation> set = this.children.get(relation);
            if (set == null) {
                set = new HashSet<Relation>();
                this.children.put(relation, set);
            }
            return set;
        }

        public void addDependency(Relation relation, Relation relation2) {
            this.getChildren(relation).add(relation2);
        }

        protected void visit(Stack<Relation> stack, Relation relation) throws CyclicUploadDependencyException {
            if (stack.contains(relation)) {
                stack.push(relation);
                throw new CyclicUploadDependencyException(stack);
            }
            if (!this.visited.contains(relation)) {
                stack.push(relation);
                this.visited.add(relation);
                for (Relation relation2 : this.getChildren(relation)) {
                    this.visit(stack, relation2);
                }
                this.uploadOrder.add(relation);
                stack.pop();
            }
        }

        public List<Relation> computeUploadOrder() throws CyclicUploadDependencyException {
            this.visited = new HashSet<Relation>();
            this.uploadOrder = new LinkedList<Relation>();
            Stack<Relation> stack = new Stack<Relation>();
            for (Relation relation : this.relations) {
                this.visit(stack, relation);
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(this.relations);
            Collections.sort(arrayList, new Comparator<Relation>(){

                @Override
                public int compare(Relation relation, Relation relation2) {
                    return Integer.valueOf(RelationUploadDependencyGraph.this.uploadOrder.indexOf(relation)).compareTo(RelationUploadDependencyGraph.this.uploadOrder.indexOf(relation2));
                }
            });
            return arrayList;
        }
    }
}

