/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.BasicUploadSettingsPanel;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSettingsPanel
extends JPanel
implements PropertyChangeListener,
TableModelListener {
    public static final String UPLOAD_COMMENT_PROP = TagSettingsPanel.class.getName() + ".uploadComment";
    private TagEditorPanel pnlTagEditor;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.pnlTagEditor = new TagEditorPanel();
        this.add((Component)this.pnlTagEditor, "Center");
    }

    public TagSettingsPanel() {
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected String getDefaultCreatedBy() {
        Object object = System.getProperties().get("http.agent");
        return object == null ? "JOSM" : object.toString();
    }

    public void setUploadComment(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).equals(string2 = this.getUploadComment())) {
            return;
        }
        if (string.equals("")) {
            this.pnlTagEditor.getModel().delete("comment");
            return;
        }
        TagModel tagModel = this.pnlTagEditor.getModel().get("comment");
        if (tagModel == null) {
            tagModel = new TagModel("comment", string);
            this.pnlTagEditor.getModel().add(tagModel);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tagModel, string);
        }
    }

    protected String getUploadComment() {
        TagModel tagModel = this.pnlTagEditor.getModel().get("comment");
        if (tagModel == null) {
            return null;
        }
        return tagModel.getValue();
    }

    protected void initNewChangeset() {
        String string = this.getUploadComment();
        this.pnlTagEditor.getModel().clear();
        if (string != null) {
            this.pnlTagEditor.getModel().add("comment", string);
        }
        this.pnlTagEditor.getModel().add("created_by", this.getDefaultCreatedBy());
    }

    protected void initFromExistingChangeset(Changeset changeset) {
        String string = this.getUploadComment();
        Map<String, String> map = changeset.getKeys();
        if (map.get("comment") == null) {
            map.put("comment", string);
        }
        map.put("created_by", this.getDefaultCreatedBy());
        this.pnlTagEditor.getModel().initFromTags(map);
    }

    public void initFromChangeset(Changeset changeset) {
        if (changeset == null) {
            this.initNewChangeset();
        } else {
            this.initFromExistingChangeset(changeset);
        }
    }

    public Map<String, String> getTags() {
        return this.pnlTagEditor.getModel().getTags();
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(Main.main.getEditLayer());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            Changeset changeset = (Changeset)propertyChangeEvent.getNewValue();
            this.initFromChangeset(changeset);
        } else if (propertyChangeEvent.getPropertyName().equals(BasicUploadSettingsPanel.UPLOAD_COMMENT_PROP)) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.setUploadComment(string);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        String string = this.getUploadComment();
        this.firePropertyChange(UPLOAD_COMMENT_PROP, null, string);
    }
}

