/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationNodeMap {
    private final List<RelationMember> members;
    private TreeMap<Node, TreeSet<Integer>> nodesMap;
    private TreeMap<Integer, TreeSet<Node>> waysMap;
    private TreeSet<Integer> remaining;
    private List<Integer> notSortable = new ArrayList<Integer>();

    RelationNodeMap(ArrayList<RelationMember> arrayList) {
        Comparable<OsmPrimitive> comparable;
        this.members = arrayList;
        this.nodesMap = new TreeMap();
        this.waysMap = new TreeMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            RelationMember object2 = arrayList.get(i);
            if (object2.getMember().isIncomplete() || !object2.isWay()) {
                this.notSortable.add(i);
                continue;
            }
            comparable = object2.getWay();
            if (MemberTableModel.roundaboutType(comparable) != WayConnectionType.Direction.NONE) {
                for (Node node : comparable.getNodes()) {
                    this.addPair(node, i);
                }
                continue;
            }
            this.addPair(comparable.firstNode(), i);
            this.addPair(comparable.lastNode(), i);
        }
        this.remaining = new TreeSet();
        for (Integer n : this.waysMap.keySet()) {
            this.remaining.add(n);
        }
        Iterator<Object> iterator = this.nodesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((TreeSet)entry.getValue()).size() >= 2) continue;
            if (((TreeSet)entry.getValue()).size() != 1) {
                throw new AssertionError();
            }
            comparable = (Integer)((TreeSet)entry.getValue()).iterator().next();
            TreeSet<Node> treeSet = this.waysMap.get(comparable);
            treeSet.remove(entry.getKey());
            iterator.remove();
        }
    }

    private void addPair(Node node, int n) {
        TreeSet<Integer> treeSet = this.nodesMap.get(node);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.nodesMap.put(node, treeSet);
        }
        treeSet.add(n);
        TreeSet<Node> treeSet2 = this.waysMap.get(n);
        if (treeSet2 == null) {
            treeSet2 = new TreeSet();
            this.waysMap.put(n, treeSet2);
        }
        treeSet2.add(node);
    }

    public Integer popAdjacent(Integer n) {
        TreeSet<Node> treeSet = this.waysMap.get(n);
        for (Node node : treeSet) {
            TreeSet<Integer> treeSet2 = this.nodesMap.get(node);
            if (treeSet2.isEmpty()) continue;
            Integer n2 = treeSet2.iterator().next();
            this.done(n2);
            this.waysMap.get(n2).remove(node);
            return n2;
        }
        return null;
    }

    public Integer pop() {
        if (this.remaining.isEmpty()) {
            return null;
        }
        Integer n = this.remaining.iterator().next();
        this.done(n);
        return n;
    }

    private void done(Integer n) {
        this.remaining.remove(n);
        TreeSet<Node> treeSet = this.waysMap.get(n);
        for (Node node : treeSet) {
            boolean bl = this.nodesMap.get(node).remove(n);
            if (!bl) {
                throw new AssertionError();
            }
        }
    }

    public List<Integer> getNotSortableMembers() {
        return this.notSortable;
    }
}

