/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class MemberTable
extends JTable
implements IMemberModelListener {
    protected OsmDataLayer layer;
    protected JPopupMenu popupMenu;
    private ZoomToAction zoomToAction;

    public MemberTable(OsmDataLayer osmDataLayer, MemberTableModel memberTableModel) {
        super(memberTableModel, new MemberTableColumnModel(), memberTableModel.getSelectionModel());
        this.layer = osmDataLayer;
        memberTableModel.addMemberModelListener(this);
        this.init();
    }

    protected void init() {
        this.setAutoResizeMode(4);
        this.setSelectionMode(2);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.addMouseListener(new PopupListener());
        this.addMouseListener(new DblClickHandler());
    }

    public Dimension getPreferredSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    public void makeMemberVisible(int n) {
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    protected JPopupMenu getPopUpMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.zoomToAction = new ZoomToAction();
            MapView.addLayerChangeListener(this.zoomToAction);
            this.getSelectionModel().addListSelectionListener(this.zoomToAction);
            this.popupMenu.add(this.zoomToAction);
        }
        return this.popupMenu;
    }

    public void unlinkAsListener() {
        MapView.removeLayerChangeListener(this.zoomToAction);
    }

    protected MemberTableModel getMemberTableModel() {
        return (MemberTableModel)this.getModel();
    }

    class DblClickHandler
    extends MouseAdapter {
        DblClickHandler() {
        }

        protected void setSelection(MouseEvent mouseEvent) {
            int n = MemberTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(n);
            MemberTable.this.getMemberTableModel().getLayer().data.setSelected(osmPrimitive.getPrimitiveId());
        }

        protected void addSelection(MouseEvent mouseEvent) {
            int n = MemberTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(n);
            MemberTable.this.getMemberTableModel().getSelectionModel().addSelectionInterval(n, n);
            MemberTable.this.getMemberTableModel().getLayer().data.addSelected(osmPrimitive.getPrimitiveId());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                if (mouseEvent.isControlDown()) {
                    this.addSelection(mouseEvent);
                } else {
                    this.setSelection(mouseEvent);
                }
            }
        }
    }

    class ZoomToAction
    extends AbstractAction
    implements MapView.LayerChangeListener,
    ListSelectionListener {
        public ZoomToAction() {
            this.putValue("Name", I18n.tr("Zoom to"));
            this.putValue("ShortDescription", I18n.tr("Zoom to the object the first selected member refers to"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int[] nArray = MemberTable.this.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int n = nArray[0];
            OsmPrimitive osmPrimitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(n);
            MemberTable.this.layer.data.setSelected(osmPrimitive);
            AutoScaleAction autoScaleAction = new AutoScaleAction("selection");
            autoScaleAction.autoScale();
        }

        protected void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() != MemberTable.this.layer) {
                this.setEnabled(false);
                this.putValue("ShortDescription", I18n.tr("Zooming disabled because layer of this relation is not active"));
                return;
            }
            if (MemberTable.this.getSelectedRowCount() == 0) {
                this.setEnabled(false);
                this.putValue("ShortDescription", I18n.tr("Zooming disabled because there is no selected member"));
                return;
            }
            this.setEnabled(true);
            this.putValue("ShortDescription", I18n.tr("Zoom to the object the first selected member refers to"));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MemberTable.this.getPopUpMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MemberTable.this.getSelectedColumn();
            int n2 = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if ((n > 0 || n2 > 0) && n2 > 0) {
                n = 0;
                --n2;
            }
            MemberTable.this.changeSelection(n2, n, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = MemberTable.this.getSelectedColumn();
            int n2 = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if (n == 0 && n2 < MemberTable.this.getRowCount() - 1) {
                ++n2;
            } else if (n2 < MemberTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            }
            MemberTable.this.changeSelection(n2, n, false, false);
        }
    }
}

