/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadRelationMemberTask
extends PleaseWaitRunnable {
    private boolean cancelled;
    private Exception lastException;
    private Relation parent;
    private Collection<OsmPrimitive> children;
    private OsmDataLayer curLayer;
    private MultiFetchServerObjectReader objectReader;

    public DownloadRelationMemberTask(Relation relation, Collection<OsmPrimitive> collection, OsmDataLayer osmDataLayer, MemberTableModel memberTableModel, Dialog dialog) {
        super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(dialog), false);
        this.parent = relation;
        this.children = collection;
        this.curLayer = osmDataLayer;
    }

    public DownloadRelationMemberTask(Relation relation, Collection<OsmPrimitive> collection, OsmDataLayer osmDataLayer, MemberTableModel memberTableModel) {
        super(I18n.tr("Download relation members"), false);
        this.parent = relation;
        this.children = collection;
        this.curLayer = osmDataLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.cancelled = true;
        DownloadRelationMemberTask downloadRelationMemberTask = this;
        synchronized (downloadRelationMemberTask) {
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        Main.map.repaint();
        if (this.cancelled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            Object object = this;
            synchronized (object) {
                if (this.cancelled) {
                    return;
                }
                this.objectReader = new MultiFetchServerObjectReader();
            }
            this.objectReader.append(this.children);
            this.progressMonitor.indeterminateSubTask(I18n.trn("Downloading {0} incomplete child of relation ''{1}''", "Downloading {0} incomplete children of relation ''{1}''", this.children.size(), this.children.size(), this.parent.getDisplayName(DefaultNameFormatter.getInstance())));
            object = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            if (object == null) {
                return;
            }
            DownloadRelationMemberTask downloadRelationMemberTask = this;
            synchronized (downloadRelationMemberTask) {
                if (this.cancelled) {
                    return;
                }
                this.objectReader = null;
            }
            SwingUtilities.invokeLater(new Runnable((DataSet)object){
                final /* synthetic */ DataSet val$dataSet;
                {
                    this.val$dataSet = dataSet;
                }

                public void run() {
                    DownloadRelationMemberTask.this.curLayer.mergeFrom(this.val$dataSet);
                    DownloadRelationMemberTask.this.curLayer.onPostDownloadFromServer();
                }
            });
        }
        catch (Exception exception) {
            if (this.cancelled) {
                System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", exception.toString()));
                return;
            }
            this.lastException = exception;
        }
    }
}

