/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Filters;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class FilterDialog
extends ToggleDialog
implements DataSetListenerAdapter.Listener,
TableModelListener {
    private JTable userTable;
    private Filters filters = new Filters();
    private SideButton addButton;
    private SideButton editButton;
    private SideButton deleteButton;
    private SideButton upButton;
    private SideButton downButton;
    private final DataSetListener listenerAdapter = new DataSetListenerAdapter(this);
    protected String[] columnToolTips = new String[]{I18n.tr("Enable filter"), I18n.tr("Hide elements"), null, I18n.tr("Apply also for children"), I18n.tr("Inverse filter"), I18n.tr("Filter mode")};

    public FilterDialog() {
        super(I18n.tr("Filter"), "filter", I18n.tr("Filter objects and hide/disable them."), Shortcut.registerShortcut("subwindow:filter", I18n.tr("Toggle: {0}", I18n.tr("Filter")), 70, 4, 1), 162);
        this.build();
    }

    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.listenerAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
    }

    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.listenerAdapter);
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = this.getButtonPanel(5);
        this.addButton = new SideButton(I18n.marktr("Add"), "add", "SelectionList", I18n.tr("Add filter."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Filter filter = (Filter)SearchAction.showSearchDialog(new Filter());
                if (filter != null) {
                    FilterDialog.this.filters.addFilter(filter);
                    FilterDialog.this.filters.filter();
                }
            }
        });
        jPanel.add(this.addButton);
        this.editButton = new SideButton(I18n.marktr("Edit"), "edit", "SelectionList", I18n.tr("Edit filter."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                Filter filter = FilterDialog.this.filters.getFilter(n);
                Filter filter2 = (Filter)SearchAction.showSearchDialog(filter);
                if (filter2 != null) {
                    FilterDialog.this.filters.setFilter(n, filter2);
                    FilterDialog.this.filters.filter();
                }
            }
        });
        jPanel.add(this.editButton);
        this.deleteButton = new SideButton(I18n.marktr("Delete"), "delete", "SelectionList", I18n.tr("Delete filter."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filters.removeFilter(n);
            }
        });
        jPanel.add(this.deleteButton);
        this.upButton = new SideButton(I18n.marktr("Up"), "up", "SelectionList", I18n.tr("Move filter up."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filters.moveUpFilter(n);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        });
        jPanel.add(this.upButton);
        this.downButton = new SideButton(I18n.marktr("Down"), "down", "SelectionList", I18n.tr("Move filter down."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filters.moveDownFilter(n);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        });
        jPanel.add(this.downButton);
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.userTable = new JTable(this.filters){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent mouseEvent) {
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return FilterDialog.this.columnToolTips[n2];
                    }
                };
            }
        };
        this.filters.addTableModelListener(this);
        this.userTable.setSelectionMode(0);
        this.userTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(4).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(5).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(0).setResizable(false);
        this.userTable.getColumnModel().getColumn(1).setResizable(false);
        this.userTable.getColumnModel().getColumn(3).setResizable(false);
        this.userTable.getColumnModel().getColumn(4).setResizable(false);
        this.userTable.getColumnModel().getColumn(5).setResizable(false);
        this.userTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.userTable.setDefaultRenderer(String.class, new StringRenderer());
        this.tableChanged(null);
        jPanel.add((Component)new JScrollPane(this.userTable), "Center");
        jPanel.add((Component)this.buildButtonRow(), "South");
        this.add((Component)jPanel, "Center");
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.filters.filter();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setTitle("Filter Hidden:" + this.filters.hiddenCount + " Disabled:" + this.filters.disabledCount);
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Filters filters = (Filters)jTable.getModel();
            this.setSelected((Boolean)object);
            this.setEnabled(filters.isCellEnabled(n, n2));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Filters filters = (Filters)jTable.getModel();
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setEnabled(filters.isCellEnabled(n, n2));
            return component;
        }
    }
}

