/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser {
    private static TileSource[] TILE_SOURCES = new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.TilesAtHome(), new OsmTileSource.CycleMap()};
    private Dimension iDownloadDialogDimension;
    private TileLoader cachedLoader;
    private TileLoader uncachedLoader;
    private SizeButton iSizeButton = new SizeButton();
    private SourceButton iSourceButton = new SourceButton();
    private Bounds bbox;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;

    public SlippyMapBBoxChooser() {
        try {
            this.cachedLoader = new OsmFileCacheTileLoader(this);
        }
        catch (SecurityException securityException) {
            this.cachedLoader = null;
        }
        this.uncachedLoader = new OsmTileLoader(this);
        this.setZoomContolsVisible(false);
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        String string = Main.pref.get("slippy_map_chooser.mapstyle", "mapnik");
        if (string.equals("osmarender")) {
            this.iSourceButton.setMapStyle(3);
            this.setTileSource(TILE_SOURCES[1]);
        } else if (string.equals("cyclemap")) {
            this.iSourceButton.setMapStyle(4);
            this.setTileSource(TILE_SOURCES[2]);
        } else if (!string.equals("mapnik")) {
            Main.pref.put("slippy_map_chooser", "mapnik");
        }
        new SlippyMapControler(this, this, this.iSizeButton, this.iSourceButton);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int n = 22 - this.zoom;
                Point point = this.getTopLeftCoordinates();
                int n2 = (this.iSelectionRectStart.x >> n) - point.x;
                int n3 = (this.iSelectionRectStart.y >> n) - point.y;
                int n4 = (this.iSelectionRectEnd.x >> n) - point.x;
                int n5 = (this.iSelectionRectEnd.y >> n) - point.y;
                int n6 = n4 - n2;
                int n7 = n5 - n3;
                graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                graphics.fillRect(n2, n3, n6, n7);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n2, n3, n6, n7);
            }
            this.iSizeButton.paint(graphics);
            this.iSourceButton.paint(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFileCacheEnabled(boolean bl) {
        if (bl) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void setMaxTilesInMemory(int n) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(n);
    }

    public void setSelection(Point point, Point point2) {
        if (point == null || point2 == null || point.x == point2.x || point.y == point2.y) {
            return;
        }
        Point point3 = new Point(Math.max(point2.x, point.x), Math.max(point2.y, point.y));
        Point point4 = new Point(Math.min(point2.x, point.x), Math.min(point2.y, point.y));
        Point point5 = this.getTopLeftCoordinates();
        int n = 22 - this.zoom;
        Point point6 = new Point(point3.x + point5.x, point3.y + point5.y);
        Point point7 = new Point(point4.x + point5.x, point4.y + point5.y);
        point6.x <<= n;
        point6.y <<= n;
        point7.x <<= n;
        point7.y <<= n;
        this.iSelectionRectStart = point7;
        this.iSelectionRectEnd = point6;
        Coordinate coordinate = this.getPosition(point3);
        Coordinate coordinate2 = this.getPosition(point4);
        Bounds bounds = new Bounds(new LatLon(Math.min(coordinate2.getLat(), coordinate.getLat()), Math.min(coordinate.getLon(), coordinate2.getLon())), new LatLon(Math.max(coordinate2.getLat(), coordinate.getLat()), Math.max(coordinate.getLon(), coordinate2.getLon())));
        Bounds bounds2 = this.bbox;
        this.bbox = bounds;
        this.firePropertyChange(BBOX_PROP, bounds2, this.bbox);
        this.repaint();
    }

    public void resizeSlippyMap() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.iDownloadDialogDimension == null) {
            int n = dimension.width * 90 / 100;
            int n2 = dimension.height * 90 / 100;
        } else {
            int n = this.iDownloadDialogDimension.width;
            int n3 = this.iDownloadDialogDimension.height;
            this.iDownloadDialogDimension = null;
        }
        this.repaint();
    }

    public void toggleMapSource(int n) {
        this.tileController.setTileCache(new MemoryTileCache());
        if (n == 2) {
            this.setTileSource(TILE_SOURCES[0]);
            Main.pref.put("slippy_map_chooser.mapstyle", "mapnik");
        } else if (n == 4) {
            this.setTileSource(TILE_SOURCES[2]);
            Main.pref.put("slippy_map_chooser.mapstyle", "cyclemap");
        } else {
            this.setTileSource(TILE_SOURCES[1]);
            Main.pref.put("slippy_map_chooser.mapstyle", "osmarender");
        }
    }

    public Bounds getBoundingBox() {
        return this.bbox;
    }

    public void setBoundingBox(Bounds bounds) {
        if (bounds == null) {
            Bounds bounds2 = this.bbox;
            this.bbox = null;
            this.firePropertyChange(BBOX_PROP, bounds2, this.bbox);
            return;
        }
        if (bounds.getMin().lat() == 0.0 && bounds.getMin().lon() == 0.0 && bounds.getMax().lat() == 0.0 && bounds.getMax().lon() == 0.0) {
            Bounds bounds3 = this.bbox;
            this.bbox = null;
            this.firePropertyChange(BBOX_PROP, bounds3, this.bbox);
        }
        int n = OsmMercator.LatToY(bounds.getMin().lat(), 22);
        int n2 = OsmMercator.LatToY(bounds.getMax().lat(), 22);
        int n3 = OsmMercator.LonToX(bounds.getMin().lon(), 22);
        int n4 = OsmMercator.LonToX(bounds.getMax().lon(), 22);
        this.iSelectionRectStart = new Point(Math.min(n3, n4), Math.min(n, n2));
        this.iSelectionRectEnd = new Point(Math.max(n3, n4), Math.max(n, n2));
        MapMarkerDot mapMarkerDot = new MapMarkerDot(bounds.getMin().lat(), bounds.getMin().lon());
        MapMarkerDot mapMarkerDot2 = new MapMarkerDot(bounds.getMax().lat(), bounds.getMax().lon());
        Vector<MapMarker> vector = new Vector<MapMarker>(2);
        vector.add(mapMarkerDot);
        vector.add(mapMarkerDot2);
        this.setMapMarkerList(vector);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        Bounds bounds4 = this.bbox;
        this.bbox = bounds;
        this.firePropertyChange(BBOX_PROP, bounds4, this.bbox);
    }
}

