/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.help.Helpful;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatableComponent
extends JComponent
implements Helpful {
    private static final CopyOnWriteArrayList<ZoomChangeListener> zoomChangeListeners = new CopyOnWriteArrayList();
    public static final int snapDistance = Main.pref.getInteger("node.snap-distance", 10);
    public static final int snapDistanceSq = NavigatableComponent.sqr(snapDistance);
    private double scale = Main.proj.getDefaultZoomInPPD();
    protected EastNorth center = this.calculateDefaultCenter();
    private Stack<ZoomData> zoomUndoBuffer = new Stack();
    private Stack<ZoomData> zoomRedoBuffer = new Stack();
    private Date zoomTimestamp = new Date();

    public static void removeZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        zoomChangeListeners.remove(zoomChangeListener);
    }

    public static void addZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        if (zoomChangeListener != null) {
            zoomChangeListeners.addIfAbsent(zoomChangeListener);
        }
    }

    protected static void fireZoomChanged() {
        for (ZoomChangeListener zoomChangeListener : zoomChangeListeners) {
            zoomChangeListener.zoomChanged();
        }
    }

    private static int sqr(int n) {
        return n * n;
    }

    public NavigatableComponent() {
        this.setLayout(null);
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    private EastNorth calculateDefaultCenter() {
        Bounds bounds = Main.proj.getWorldBoundsLatLon();
        double d = (bounds.getMax().lat() + bounds.getMin().lat()) / 2.0;
        double d2 = (bounds.getMax().lon() + bounds.getMin().lon()) / 2.0;
        return Main.proj.latlon2eastNorth(new LatLon(d, d2));
    }

    public String getDist100PixelText() {
        double d = this.getDist100Pixel();
        return d >= 2000.0 ? Math.round(d / 100.0) / 10L + " km" : (d >= 1.0 ? Math.round(d * 10.0) / 10L + " m" : "< 1 m");
    }

    public double getDist100Pixel() {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        LatLon latLon = this.getLatLon(n - 50, n2);
        LatLon latLon2 = this.getLatLon(n + 50, n2);
        return latLon.greatCircleDistance(latLon2);
    }

    public EastNorth getCenter() {
        return this.center;
    }

    public EastNorth getEastNorth(int n, int n2) {
        return new EastNorth(this.center.east() + ((double)n - (double)this.getWidth() / 2.0) * this.scale, this.center.north() - ((double)n2 - (double)this.getHeight() / 2.0) * this.scale);
    }

    public ProjectionBounds getProjectionBounds() {
        return new ProjectionBounds(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale), new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale));
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(bounds.getMin()), this.getProjection().latlon2eastNorth(bounds.getMax()));
    }

    public Bounds getRealBounds() {
        return new Bounds(this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale)), this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale)));
    }

    public LatLon getLatLon(int n, int n2) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(n, n2));
    }

    public Bounds getLatLonBounds(Rectangle rectangle) {
        EastNorth eastNorth = this.getEastNorth(rectangle.x, rectangle.y);
        EastNorth eastNorth2 = this.getEastNorth(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Bounds bounds = new Bounds(Main.proj.eastNorth2latlon(eastNorth));
        double d = Math.min(eastNorth.east(), eastNorth2.east());
        double d2 = Math.max(eastNorth.east(), eastNorth2.east());
        double d3 = Math.min(eastNorth.north(), eastNorth2.north());
        double d4 = Math.max(eastNorth.north(), eastNorth2.north());
        double d5 = (d2 - d) / 10.0;
        double d6 = (d4 - d3) / 10.0;
        for (int i = 0; i < 10; ++i) {
            bounds.extend(Main.proj.eastNorth2latlon(new EastNorth(d + (double)i * d5, d3)));
            bounds.extend(Main.proj.eastNorth2latlon(new EastNorth(d + (double)i * d5, d4)));
            bounds.extend(Main.proj.eastNorth2latlon(new EastNorth(d, d3 + (double)i * d6)));
            bounds.extend(Main.proj.eastNorth2latlon(new EastNorth(d2, d3 + (double)i * d6)));
        }
        return bounds;
    }

    public Point getPoint(EastNorth eastNorth) {
        if (null == eastNorth) {
            return new Point();
        }
        double d = (eastNorth.east() - this.center.east()) / this.scale + (double)(this.getWidth() / 2);
        double d2 = (this.center.north() - eastNorth.north()) / this.scale + (double)(this.getHeight() / 2);
        return new Point((int)d, (int)d2);
    }

    public Point getPoint(LatLon latLon) {
        if (latLon == null) {
            return new Point();
        }
        if (latLon instanceof CachedLatLon) {
            return this.getPoint(((CachedLatLon)latLon).getEastNorth());
        }
        return this.getPoint(this.getProjection().latlon2eastNorth(latLon));
    }

    public Point getPoint(Node node) {
        return this.getPoint(node.getEastNorth());
    }

    private void zoomTo(EastNorth eastNorth, double d) {
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        CachedLatLon cachedLatLon = new CachedLatLon(eastNorth);
        boolean bl = false;
        double d2 = cachedLatLon.lat();
        double d3 = cachedLatLon.lon();
        if (d2 < bounds.getMin().lat()) {
            bl = true;
            d2 = bounds.getMin().lat();
        } else if (d2 > bounds.getMax().lat()) {
            bl = true;
            d2 = bounds.getMax().lat();
        }
        if (d3 < bounds.getMin().lon()) {
            bl = true;
            d3 = bounds.getMin().lon();
        } else if (d3 > bounds.getMax().lon()) {
            bl = true;
            d3 = bounds.getMax().lon();
        }
        if (bl) {
            eastNorth = new CachedLatLon(d2, d3).getEastNorth();
        }
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        LatLon latLon = new LatLon(bounds.getMin().lat(), d3);
        LatLon latLon2 = new LatLon(bounds.getMax().lat(), d3);
        EastNorth eastNorth2 = this.getProjection().latlon2eastNorth(latLon);
        EastNorth eastNorth3 = this.getProjection().latlon2eastNorth(latLon2);
        double d4 = eastNorth3.north() - eastNorth2.north();
        if (d4 < (double)n2 * d) {
            double d5 = d4 / (double)n2;
            eastNorth2 = this.getProjection().latlon2eastNorth(new LatLon(d2, bounds.getMin().lon()));
            eastNorth3 = this.getProjection().latlon2eastNorth(new LatLon(d2, bounds.getMax().lon()));
            d4 = eastNorth3.east() - eastNorth2.east();
            if (d4 < (double)n * d) {
                d = Math.max(d5, d4 / (double)n);
            }
        } else if (d < (d4 /= latLon.greatCircleDistance(latLon2) * (double)n2 * 10.0)) {
            d = d4;
        }
        if (!eastNorth.equals(this.center) || this.scale != d) {
            this.pushZoomUndo(this.center, this.scale);
            this.zoomNoUndoTo(eastNorth, d);
        }
    }

    private void zoomNoUndoTo(EastNorth eastNorth, double d) {
        if (!eastNorth.equals(this.center)) {
            EastNorth eastNorth2 = this.center;
            this.center = eastNorth;
            this.firePropertyChange("center", eastNorth2, eastNorth);
        }
        if (this.scale != d) {
            double d2 = this.scale;
            this.scale = d;
            this.firePropertyChange("scale", d2, d);
        }
        this.repaint();
        NavigatableComponent.fireZoomChanged();
    }

    public void zoomTo(EastNorth eastNorth) {
        this.zoomTo(eastNorth, this.scale);
    }

    public void zoomTo(LatLon latLon) {
        if (latLon instanceof CachedLatLon) {
            this.zoomTo(((CachedLatLon)latLon).getEastNorth(), this.scale);
        } else {
            this.zoomTo(this.getProjection().latlon2eastNorth(latLon), this.scale);
        }
    }

    public void zoomToFactor(double d, double d2, double d3) {
        double d4 = this.scale * d3;
        this.zoomTo(new EastNorth(this.center.east() - (d - (double)this.getWidth() / 2.0) * (d4 - this.scale), this.center.north() + (d2 - (double)this.getHeight() / 2.0) * (d4 - this.scale)), d4);
    }

    public void zoomToFactor(EastNorth eastNorth, double d) {
        this.zoomTo(eastNorth, this.scale * d);
    }

    public void zoomToFactor(double d) {
        this.zoomTo(this.center, this.scale * d);
    }

    public void zoomTo(ProjectionBounds projectionBounds) {
        int n;
        int n2 = this.getWidth() - 20;
        if (n2 < 20) {
            n2 = 20;
        }
        if ((n = this.getHeight() - 20) < 20) {
            n = 20;
        }
        double d = (projectionBounds.max.east() - projectionBounds.min.east()) / (double)n2;
        double d2 = (projectionBounds.max.north() - projectionBounds.min.north()) / (double)n;
        double d3 = Math.max(d, d2);
        this.zoomTo(projectionBounds.getCenter(), d3);
    }

    public void zoomTo(Bounds bounds) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(bounds.getMin()), this.getProjection().latlon2eastNorth(bounds.getMax())));
    }

    private void pushZoomUndo(EastNorth eastNorth, double d) {
        Date date = new Date();
        if ((double)(date.getTime() - this.zoomTimestamp.getTime()) > Main.pref.getDouble("zoom.undo.delay", 1.0) * 1000.0) {
            this.zoomUndoBuffer.push(new ZoomData(eastNorth, d));
            if (this.zoomUndoBuffer.size() > Main.pref.getInteger("zoom.undo.max", 50)) {
                this.zoomUndoBuffer.remove(0);
            }
            this.zoomRedoBuffer.clear();
        }
        this.zoomTimestamp = date;
    }

    public void zoomPrevious() {
        if (!this.zoomUndoBuffer.isEmpty()) {
            ZoomData zoomData = this.zoomUndoBuffer.pop();
            this.zoomRedoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoomData.getCenterEastNorth(), zoomData.getScale());
        }
    }

    public void zoomNext() {
        if (!this.zoomRedoBuffer.isEmpty()) {
            ZoomData zoomData = this.zoomRedoBuffer.pop();
            this.zoomUndoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoomData.getCenterEastNorth(), zoomData.getScale());
        }
    }

    public boolean hasZoomUndoEntries() {
        return !this.zoomUndoBuffer.isEmpty();
    }

    public boolean hasZoomRedoEntries() {
        return !this.zoomRedoBuffer.isEmpty();
    }

    private BBox getSnapDistanceBBox(Point point) {
        return new BBox(this.getLatLon(point.x - snapDistance, point.y - snapDistance), this.getLatLon(point.x + snapDistance, point.y + snapDistance));
    }

    public final Node getNearestNode(Point point) {
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet == null) {
            return null;
        }
        double d = snapDistanceSq;
        Node node = null;
        for (Node node2 : dataSet.searchNodes(this.getSnapDistanceBBox(point))) {
            if (!node2.isUsable()) continue;
            Point point2 = this.getPoint(node2);
            double d2 = point.distanceSq(point2);
            if (d2 < d) {
                d = d2;
                node = node2;
                continue;
            }
            if (d2 != d || node == null || (!node2.isNew() || !dataSet.isSelected(node2)) && (dataSet.isSelected(node) || !dataSet.isSelected(node2) && !node2.isNew())) continue;
            node = node2;
        }
        return node;
    }

    public final List<WaySegment> getNearestWaySegments(Point point) {
        TreeMap treeMap = new TreeMap();
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet == null) {
            return null;
        }
        for (Way object : dataSet.searchWays(this.getSnapDistanceBBox(point))) {
            if (!object.isUsable()) continue;
            Object object2 = null;
            int n = -2;
            for (Node node : object.getNodes()) {
                double d;
                ++n;
                if (node.isDeleted() || node.isIncomplete()) continue;
                if (object2 == null) {
                    object2 = node;
                    continue;
                }
                Point point2 = this.getPoint((Node)object2);
                Point point3 = this.getPoint(node);
                double d2 = point2.distanceSq(point3);
                double d3 = point.distanceSq(point3);
                double d4 = d3 - (d3 - (d = point.distanceSq(point2)) + d2) * (d3 - d + d2) / 4.0 / d2;
                if (d4 < (double)snapDistanceSq && d3 < d2 + (double)snapDistanceSq && d < d2 + (double)snapDistanceSq) {
                    List<WaySegment> list;
                    if (dataSet.isSelected(object)) {
                        d4 -= 1.0E-5;
                    }
                    if (treeMap.containsKey(d4)) {
                        list = (List)treeMap.get(d4);
                    } else {
                        list = new LinkedList();
                        treeMap.put(d4, list);
                    }
                    list.add(new WaySegment(object, n));
                }
                object2 = node;
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : treeMap.values()) {
            arrayList.addAll(object2);
        }
        return arrayList;
    }

    public final WaySegment getNearestWaySegment(Point point, Collection<WaySegment> collection) {
        List<WaySegment> list = this.getNearestWaySegments(point);
        if (list == null) {
            return null;
        }
        if (collection != null) {
            list.removeAll(collection);
        }
        return list.isEmpty() ? null : list.get(0);
    }

    public final WaySegment getNearestWaySegment(Point point) {
        return this.getNearestWaySegment(point, null);
    }

    public final Way getNearestWay(Point point) {
        WaySegment waySegment = this.getNearestWaySegment(point);
        return waySegment == null ? null : waySegment.way;
    }

    public OsmPrimitive getNearest(Point point) {
        OsmPrimitive osmPrimitive = this.getNearestNode(point);
        if (osmPrimitive == null) {
            osmPrimitive = this.getNearestWay(point);
        }
        return osmPrimitive;
    }

    public Collection<OsmPrimitive> getNearestCollection(Point point) {
        OsmPrimitive osmPrimitive = this.getNearest(point);
        if (osmPrimitive == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(osmPrimitive);
    }

    public Collection<OsmPrimitive> getAllNearest(Point point) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet == null) {
            return null;
        }
        block0: for (Way osmPrimitive : dataSet.searchWays(this.getSnapDistanceBBox(point))) {
            if (!osmPrimitive.isUsable()) continue;
            Node node = null;
            for (Node node2 : osmPrimitive.getNodes()) {
                double d;
                if (!node2.isUsable()) continue;
                if (node == null) {
                    node = node2;
                    continue;
                }
                Point point2 = this.getPoint(node);
                Point point3 = this.getPoint(node2);
                double d2 = point2.distanceSq(point3);
                double d3 = point.distanceSq(point3);
                double d4 = d3 - (d3 - (d = point.distanceSq(point2)) + d2) * (d3 - d + d2) / 4.0 / d2;
                if (d4 < (double)snapDistanceSq && d3 < d2 + (double)snapDistanceSq && d < d2 + (double)snapDistanceSq) {
                    hashSet.add(osmPrimitive);
                    continue block0;
                }
                node = node2;
            }
        }
        for (Node node : dataSet.searchNodes(this.getSnapDistanceBBox(point))) {
            if (!node.isUsable() || !(this.getPoint(node).distanceSq(point) < (double)snapDistanceSq)) continue;
            hashSet.add(node);
        }
        return hashSet.isEmpty() ? null : hashSet;
    }

    public Collection<Node> getNearestNodes(Point point) {
        HashSet<Node> hashSet = new HashSet<Node>();
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet == null) {
            return null;
        }
        for (Node node : dataSet.searchNodes(this.getSnapDistanceBBox(point))) {
            if (!node.isUsable() || !(this.getPoint(node).distanceSq(point) < (double)snapDistanceSq)) continue;
            hashSet.add(node);
        }
        return hashSet.isEmpty() ? null : hashSet;
    }

    public final Collection<Node> getNearestNodes(Point point, Collection<Node> collection) {
        Collection<Node> collection2 = this.getNearestNodes(point);
        if (collection2 == null) {
            return null;
        }
        if (collection != null) {
            collection2.removeAll(collection);
        }
        return collection2.isEmpty() ? null : collection2;
    }

    public Projection getProjection() {
        return Main.proj;
    }

    @Override
    public String helpTopic() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private class ZoomData {
        LatLon center;
        double scale;

        public ZoomData(EastNorth eastNorth, double d) {
            this.center = new CachedLatLon(eastNorth);
            this.scale = d;
        }

        public EastNorth getCenterEastNorth() {
            return NavigatableComponent.this.getProjection().latlon2eastNorth(this.center);
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static interface ZoomChangeListener {
        public void zoomChanged();
    }
}

