/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends NavigatableComponent
implements PropertyChangeListener {
    private static final CopyOnWriteArrayList<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<EditLayerChangeListener> editLayerChangeListeners = new CopyOnWriteArrayList();
    private ArrayList<Layer> layers = new ArrayList();
    public PlayHeadMarker playHeadMarker = null;
    private Layer activeLayer;
    private OsmDataLayer editLayer;
    public MouseEvent lastMEvent;
    private LinkedList<MapViewPaintable> temporaryLayers = new LinkedList();
    private BufferedImage offscreenBuffer;
    private boolean virtualNodesEnabled = false;

    public static void removeLayerChangeListener(LayerChangeListener layerChangeListener) {
        layerChangeListeners.remove(layerChangeListener);
    }

    public static void removeEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        editLayerChangeListeners.remove(editLayerChangeListener);
    }

    public static void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        if (layerChangeListener != null) {
            layerChangeListeners.addIfAbsent(layerChangeListener);
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener, boolean bl) {
        MapView.addEditLayerChangeListener(editLayerChangeListener);
        if (bl && Main.map != null && Main.map.mapView != null && Main.map.mapView.getEditLayer() != null) {
            MapView.fireEditLayerChanged(null, Main.map.mapView.getEditLayer());
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        if (editLayerChangeListener != null) {
            editLayerChangeListeners.addIfAbsent(editLayerChangeListener);
        }
    }

    protected static void fireActiveLayerChanged(Layer layer, Layer layer2) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.activeLayerChange(layer, layer2);
        }
    }

    protected static void fireLayerAdded(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerAdded(layer);
        }
    }

    protected static void fireLayerRemoved(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerRemoved(layer);
        }
    }

    protected static void fireEditLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        for (EditLayerChangeListener editLayerChangeListener : editLayerChangeListeners) {
            editLayerChangeListener.editLayerChanged(osmDataLayer, osmDataLayer2);
        }
    }

    public MapView() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapSlider mapSlider = new MapSlider(MapView.this);
                MapView.this.add(mapSlider);
                mapSlider.setBounds(3, 0, 114, 30);
                MapScaler mapScaler = new MapScaler(MapView.this);
                MapView.this.add(mapScaler);
                mapScaler.setLocation(10, 30);
                OsmDataLayer osmDataLayer = MapView.this.getEditLayer();
                if (osmDataLayer != null) {
                    if (!MapView.this.zoomToDataSetBoundingBox(osmDataLayer.data)) {
                        new AutoScaleAction("data").actionPerformed(null);
                    }
                } else {
                    new AutoScaleAction("layer").actionPerformed(null);
                }
                new MapMover(MapView.this, Main.contentPane);
                MoveAction moveAction = new MoveAction(MoveAction.Direction.UP);
                if (moveAction.getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "UP");
                    Main.contentPane.getActionMap().put("UP", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.DOWN)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "DOWN");
                    Main.contentPane.getActionMap().put("DOWN", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.LEFT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "LEFT");
                    Main.contentPane.getActionMap().put("LEFT", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.RIGHT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "RIGHT");
                    Main.contentPane.getActionMap().put("RIGHT", moveAction);
                }
            }
        });
        DataSet.selListeners.add(new SelectionChangedListener(){

            @Override
            public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
                MapView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
    }

    protected void addGpxLayer(GpxLayer gpxLayer) {
        if (this.layers.isEmpty()) {
            this.layers.add(gpxLayer);
            return;
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (!(this.layers.get(i) instanceof OsmDataLayer)) continue;
            if (i == this.layers.size() - 1) {
                this.layers.add(gpxLayer);
            } else {
                this.layers.add(i + 1, gpxLayer);
            }
            return;
        }
        this.layers.add(gpxLayer);
    }

    public void addLayer(Layer layer) {
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        if (layer instanceof GpxLayer) {
            this.addGpxLayer((GpxLayer)layer);
        } else if (layer.isBackgroundLayer() || this.layers.isEmpty()) {
            this.layers.add(layer);
        } else {
            this.layers.add(0, layer);
        }
        MapView.fireLayerAdded(layer);
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            this.setActiveLayer(layer);
        }
        layer.addPropertyChangeListener(this);
        AudioPlayer.reset();
        this.repaint();
    }

    @Override
    protected DataSet getCurrentDataSet() {
        if (this.editLayer != null) {
            return this.editLayer.data;
        }
        return null;
    }

    public boolean isActiveLayerDrawable() {
        return this.editLayer != null;
    }

    public boolean isActiveLayerVisible() {
        return this.isActiveLayerDrawable() && this.editLayer.isVisible();
    }

    protected Layer determineNextActiveLayer(List<Layer> list) {
        for (Layer layer : list) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public void removeLayer(Layer layer) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>(this.layers);
        if (!arrayList.remove(layer)) {
            return;
        }
        this.setEditLayer(arrayList);
        if (layer == this.activeLayer) {
            this.setActiveLayer(this.determineNextActiveLayer(arrayList), false);
        }
        this.layers.remove(layer);
        MapView.fireLayerRemoved(layer);
        layer.removePropertyChangeListener(this);
        layer.destroy();
        AudioPlayer.reset();
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int n) {
        int n2 = this.layers.indexOf(layer);
        if (n2 == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list."));
        }
        if (n == n2) {
            return;
        }
        this.layers.remove(n2);
        if (n >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(n, layer);
        }
        this.setEditLayer(this.layers);
        AudioPlayer.reset();
        this.repaint();
    }

    public int getLayerPos(Layer layer) {
        int n = this.layers.indexOf(layer);
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list."));
        }
        return n;
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            arrayList.add(layer);
        }
        Collections.sort(arrayList, new Comparator<Layer>(){

            @Override
            public int compare(Layer layer, Layer layer2) {
                if (layer instanceof OsmDataLayer && layer2 instanceof OsmDataLayer) {
                    if (layer == MapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (layer2 == MapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return Integer.valueOf(MapView.this.layers.indexOf(layer)).compareTo(MapView.this.layers.indexOf(layer2));
                }
                return Integer.valueOf(MapView.this.layers.indexOf(layer)).compareTo(MapView.this.layers.indexOf(layer2));
            }
        });
        Collections.reverse(arrayList);
        return arrayList;
    }

    @Override
    public void paint(Graphics graphics) {
        double d;
        if (this.center == null) {
            return;
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setClip(graphics.getClip());
        graphics2D.setColor(PaintColors.BACKGROUND.get());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        Bounds bounds = this.getLatLonBounds(graphics.getClipBounds());
        for (Layer mapViewPaintable : this.getVisibleLayersInZOrder()) {
            mapViewPaintable.paint(graphics2D, this, bounds);
        }
        for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
            mapViewPaintable.paint(graphics2D, this, bounds);
        }
        graphics2D.setColor(Color.WHITE);
        Bounds bounds2 = this.getProjection().getWorldBoundsLatLon();
        double d2 = bounds2.getMin().lon();
        Point point = this.getPoint(bounds2.getMin());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(point.x, point.y);
        double d3 = bounds2.getMax().lat();
        for (d = bounds2.getMin().lat(); d <= d3; d += 1.0) {
            point = this.getPoint(new LatLon(d >= d3 ? d3 : d, d2));
            generalPath.lineTo(point.x, point.y);
        }
        d = d3;
        d3 = bounds2.getMax().lon();
        while (d2 <= d3) {
            point = this.getPoint(new LatLon(d, d2 >= d3 ? d3 : d2));
            generalPath.lineTo(point.x, point.y);
            d2 += 1.0;
        }
        d2 = d3;
        d3 = bounds2.getMin().lat();
        while (d >= d3) {
            point = this.getPoint(new LatLon(d <= d3 ? d3 : d, d2));
            generalPath.lineTo(point.x, point.y);
            d -= 1.0;
        }
        d = d3;
        d3 = bounds2.getMin().lon();
        while (d2 >= d3) {
            point = this.getPoint(new LatLon(d, d2 <= d3 ? d3 : d2));
            generalPath.lineTo(point.x, point.y);
            d2 -= 1.0;
        }
        int n = this.offscreenBuffer.getWidth();
        int n2 = this.offscreenBuffer.getHeight();
        Area area = new Area(generalPath);
        Area area2 = new Area(new Rectangle(-1, -1, n + 2, n2 + 2));
        area.intersect(area2);
        graphics2D.draw(area);
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(graphics);
    }

    public void recalculateCenterScale(BoundingXYVisitor boundingXYVisitor) {
        if (boundingXYVisitor == null) {
            boundingXYVisitor = new BoundingXYVisitor();
        }
        if (boundingXYVisitor.getBounds() == null) {
            boundingXYVisitor.visit(this.getProjection().getWorldBoundsLatLon());
        }
        if (!boundingXYVisitor.hasExtend()) {
            boundingXYVisitor.enlargeBoundingBox();
        }
        this.zoomTo(boundingXYVisitor.getBounds());
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public List<Layer> getAllLayersAsList() {
        return Collections.unmodifiableList(this.layers);
    }

    public <T> List<T> getLayersOfType(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Layer layer : this.getAllLayersAsList()) {
            if (!clazz.isInstance(layer)) continue;
            arrayList.add(clazz.cast(layer));
        }
        return arrayList;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    private void setEditLayer(List<Layer> list) {
        OsmDataLayer osmDataLayer = list.contains(this.editLayer) ? this.editLayer : null;
        OsmDataLayer osmDataLayer2 = this.editLayer;
        if (this.activeLayer != this.editLayer || !list.contains(this.editLayer)) {
            if (this.activeLayer instanceof OsmDataLayer && list.contains(this.activeLayer)) {
                osmDataLayer = (OsmDataLayer)this.activeLayer;
            } else {
                for (Layer layer : list) {
                    if (!(layer instanceof OsmDataLayer)) continue;
                    osmDataLayer = (OsmDataLayer)layer;
                    break;
                }
            }
        }
        if (osmDataLayer != this.editLayer) {
            if (osmDataLayer == null) {
                this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
            }
            this.editLayer = osmDataLayer;
            MapView.fireEditLayerChanged(osmDataLayer2, osmDataLayer);
            this.refreshTitle();
        }
    }

    public void setActiveLayer(Layer layer) {
        this.setActiveLayer(layer, true);
    }

    private void setActiveLayer(Layer layer, boolean bl) {
        if (layer != null && !this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' must be in list of layers", layer.toString()));
        }
        if (layer == this.activeLayer) {
            return;
        }
        Layer layer2 = this.activeLayer;
        this.activeLayer = layer;
        if (bl) {
            this.setEditLayer(this.layers);
        }
        MapView.fireActiveLayerChanged(layer2, layer);
        Enumeration<AbstractButton> enumeration = Main.map.toolGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.setEnabled(((MapMode)abstractButton.getAction()).layerIsSupported(layer));
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public OsmDataLayer getEditLayer() {
        return this.editLayer;
    }

    public boolean hasLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    public boolean zoomToDataSetBoundingBox(DataSet dataSet) {
        OsmDataLayer osmDataLayer = this.getEditLayer();
        if (osmDataLayer == null) {
            return false;
        }
        Collection<DataSource> collection = dataSet.dataSources;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : collection) {
            boundingXYVisitor.visit(dataSource.bounds);
        }
        if (boundingXYVisitor.hasExtend()) {
            this.recalculateCenterScale(boundingXYVisitor);
            return true;
        }
        return false;
    }

    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        if (this.temporaryLayers.contains(mapViewPaintable)) {
            return false;
        }
        return this.temporaryLayers.add(mapViewPaintable);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        return this.temporaryLayers.remove(mapViewPaintable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        OsmDataLayer osmDataLayer;
        if (propertyChangeEvent.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if ((propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) && (osmDataLayer = (OsmDataLayer)propertyChangeEvent.getSource()) == this.getEditLayer()) {
            this.refreshTitle();
        }
    }

    protected void refreshTitle() {
        boolean bl;
        boolean bl2 = bl = this.editLayer != null && (this.editLayer.requiresSaveToFile() || this.editLayer.requiresUploadToServer());
        if (bl) {
            JOptionPane.getFrameForComponent(Main.parent).setTitle("* " + I18n.tr("Java OpenStreetMap Editor"));
        } else {
            JOptionPane.getFrameForComponent(Main.parent).setTitle(I18n.tr("Java OpenStreetMap Editor"));
        }
    }

    public static interface EditLayerChangeListener {
        public void editLayerChanged(OsmDataLayer var1, OsmDataLayer var2);
    }

    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

