/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM
implements Projection,
ProjectionSubPrefs {
    public static final int DEFAULT_ZONE = 30;
    private int zone = 30;
    private static final double UTMScaleFactor = 0.9996;

    private double ArcLengthOfMeridian(double d) {
        double d2 = (Ellipsoid.GRS80.a - Ellipsoid.GRS80.b) / (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b);
        double d3 = (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b) / 2.0 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = -3.0 * d2 / 2.0 + 9.0 * Math.pow(d2, 3.0) / 16.0 + -3.0 * Math.pow(d2, 5.0) / 32.0;
        double d5 = 15.0 * Math.pow(d2, 2.0) / 16.0 + -15.0 * Math.pow(d2, 4.0) / 32.0;
        double d6 = -35.0 * Math.pow(d2, 3.0) / 48.0 + 105.0 * Math.pow(d2, 5.0) / 256.0;
        double d7 = 315.0 * Math.pow(d2, 4.0) / 512.0;
        return d3 * (d + d4 * Math.sin(2.0 * d) + d5 * Math.sin(4.0 * d) + d6 * Math.sin(6.0 * d) + d7 * Math.sin(8.0 * d));
    }

    private double UTMCentralMeridian(int n) {
        return Math.toRadians(-183.0 + (double)n * 6.0);
    }

    private double UTMCentralMeridianDeg(int n) {
        return -183.0 + (double)n * 6.0;
    }

    private double FootpointLatitude(double d) {
        double d2 = (Ellipsoid.GRS80.a - Ellipsoid.GRS80.b) / (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b);
        double d3 = (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b) / 2.0 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = d / d3;
        double d5 = 3.0 * d2 / 2.0 + -27.0 * Math.pow(d2, 3.0) / 32.0 + 269.0 * Math.pow(d2, 5.0) / 512.0;
        double d6 = 21.0 * Math.pow(d2, 2.0) / 16.0 + -55.0 * Math.pow(d2, 4.0) / 32.0;
        double d7 = 151.0 * Math.pow(d2, 3.0) / 96.0 + -417.0 * Math.pow(d2, 5.0) / 128.0;
        double d8 = 1097.0 * Math.pow(d2, 4.0) / 512.0;
        return d4 + d5 * Math.sin(2.0 * d4) + d6 * Math.sin(4.0 * d4) + d7 * Math.sin(6.0 * d4) + d8 * Math.sin(8.0 * d4);
    }

    public EastNorth mapLatLonToXY(double d, double d2, double d3) {
        double d4 = (Math.pow(Ellipsoid.GRS80.a, 2.0) - Math.pow(Ellipsoid.GRS80.b, 2.0)) / Math.pow(Ellipsoid.GRS80.b, 2.0);
        double d5 = d4 * Math.pow(Math.cos(d), 2.0);
        double d6 = Math.pow(Ellipsoid.GRS80.a, 2.0) / (Ellipsoid.GRS80.b * Math.sqrt(1.0 + d5));
        double d7 = Math.tan(d);
        double d8 = d7 * d7;
        double d9 = d2 - d3;
        double d10 = 1.0 - d8 + d5;
        double d11 = 5.0 - d8 + 9.0 * d5 + 4.0 * (d5 * d5);
        double d12 = 5.0 - 18.0 * d8 + d8 * d8 + 14.0 * d5 - 58.0 * d8 * d5;
        double d13 = 61.0 - 58.0 * d8 + d8 * d8 + 270.0 * d5 - 330.0 * d8 * d5;
        double d14 = 61.0 - 479.0 * d8 + 179.0 * (d8 * d8) - d8 * d8 * d8;
        double d15 = 1385.0 - 3111.0 * d8 + 543.0 * (d8 * d8) - d8 * d8 * d8;
        return new EastNorth(d6 * Math.cos(d) * d9 + d6 / 6.0 * Math.pow(Math.cos(d), 3.0) * d10 * Math.pow(d9, 3.0) + d6 / 120.0 * Math.pow(Math.cos(d), 5.0) * d12 * Math.pow(d9, 5.0) + d6 / 5040.0 * Math.pow(Math.cos(d), 7.0) * d14 * Math.pow(d9, 7.0), this.ArcLengthOfMeridian(d) + d7 / 2.0 * d6 * Math.pow(Math.cos(d), 2.0) * Math.pow(d9, 2.0) + d7 / 24.0 * d6 * Math.pow(Math.cos(d), 4.0) * d11 * Math.pow(d9, 4.0) + d7 / 720.0 * d6 * Math.pow(Math.cos(d), 6.0) * d13 * Math.pow(d9, 6.0) + d7 / 40320.0 * d6 * Math.pow(Math.cos(d), 8.0) * d15 * Math.pow(d9, 8.0));
    }

    public LatLon mapXYToLatLon(double d, double d2, double d3) {
        double d4;
        double d5 = this.FootpointLatitude(d2);
        double d6 = (Math.pow(Ellipsoid.GRS80.a, 2.0) - Math.pow(Ellipsoid.GRS80.b, 2.0)) / Math.pow(Ellipsoid.GRS80.b, 2.0);
        double d7 = Math.cos(d5);
        double d8 = d6 * Math.pow(d7, 2.0);
        double d9 = d4 = Math.pow(Ellipsoid.GRS80.a, 2.0) / (Ellipsoid.GRS80.b * Math.sqrt(1.0 + d8));
        double d10 = Math.tan(d5);
        double d11 = d10 * d10;
        double d12 = d11 * d11;
        double d13 = 1.0 / (d9 * d7);
        double d14 = d10 / (2.0 * (d9 *= d4));
        double d15 = 1.0 / (6.0 * (d9 *= d4) * d7);
        double d16 = d10 / (24.0 * (d9 *= d4));
        double d17 = 1.0 / (120.0 * (d9 *= d4) * d7);
        double d18 = d10 / (720.0 * (d9 *= d4));
        double d19 = 1.0 / (5040.0 * (d9 *= d4) * d7);
        double d20 = d10 / (40320.0 * (d9 *= d4));
        double d21 = -1.0 - d8;
        double d22 = -1.0 - 2.0 * d11 - d8;
        double d23 = 5.0 + 3.0 * d11 + 6.0 * d8 - 6.0 * d11 * d8 - 3.0 * (d8 * d8) - 9.0 * d11 * (d8 * d8);
        double d24 = 5.0 + 28.0 * d11 + 24.0 * d12 + 6.0 * d8 + 8.0 * d11 * d8;
        double d25 = -61.0 - 90.0 * d11 - 45.0 * d12 - 107.0 * d8 + 162.0 * d11 * d8;
        double d26 = -61.0 - 662.0 * d11 - 1320.0 * d12 - 720.0 * (d12 * d11);
        double d27 = 1385.0 + 3633.0 * d11 + 4095.0 * d12 + 1575.0 * (d12 * d11);
        return new LatLon(Math.toDegrees(d5 + d14 * d21 * (d * d) + d16 * d23 * Math.pow(d, 4.0) + d18 * d25 * Math.pow(d, 6.0) + d20 * d27 * Math.pow(d, 8.0)), Math.toDegrees(d3 + d13 * d + d15 * d22 * Math.pow(d, 3.0) + d17 * d24 * Math.pow(d, 5.0) + d19 * d26 * Math.pow(d, 7.0)));
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        EastNorth eastNorth = this.mapLatLonToXY(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon()), this.UTMCentralMeridian(this.getzone()));
        return new EastNorth(eastNorth.east() * 0.9996 + 3500000.0, eastNorth.north() * 0.9996);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return this.mapXYToLatLon((eastNorth.east() - 3500000.0) / 0.9996, eastNorth.north() / 0.9996, this.UTMCentralMeridian(this.getzone()));
    }

    @Override
    public String toString() {
        return I18n.tr("UTM");
    }

    public int getzone() {
        return this.zone;
    }

    @Override
    public String toCode() {
        return "EPSG:" + (325800 + this.getzone());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.zone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "epsg" + (325800 + this.getzone());
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-85.0, this.UTMCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(85.0, this.UTMCentralMeridianDeg(this.getzone()) + 5.0));
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel) {
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        for (int i = 1; i <= 60; ++i) {
            jComboBox.addItem(i);
        }
        jComboBox.setSelectedIndex(this.zone - 1);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("UTM Zone")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        int n = ((JComboBox)component).getSelectedIndex() + 1;
        return Collections.singleton(Integer.toString(n));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        this.zone = 30;
        if (collection != null) {
            try {
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext()) {
                    String string = iterator.next();
                    this.zone = Integer.parseInt(string);
                    if (this.zone <= 0 || this.zone > 60) {
                        this.zone = 30;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:3258")) {
            try {
                String string2 = string.substring(9);
                int n = Integer.parseInt(string2);
                if (n > 0 && n <= 60) {
                    return Collections.singleton(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

