/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.NTV2GridShift;
import org.openstreetmap.josm.data.projection.NTV2GridShiftFile;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lambert
implements Projection,
ProjectionSubPrefs {
    public static final double[] n = new double[]{0.7604059656, 0.7289686274, 0.6959127966, 0.6712679322};
    public static final double[] c = new double[]{1.160379698E7, 1.174579339E7, 1.194799252E7, 1.213628199E7};
    public static final double[] Xs = new double[]{600000.0, 600000.0, 600000.0, 234.358};
    public static final double[] Ys = new double[]{5657616.674, 6199695.768, 6791905.085, 7239161.542};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-11;
    public static final double cMaxLatZone1Radian = Math.toRadians(51.300000000000004);
    public static final double cMinLatZone1Radian = Math.toRadians(41.49);
    public static final double[][] zoneLimitsDegree = new double[][]{{Math.toDegrees(cMaxLatZone1Radian), 48.15}, {48.15, 45.45}, {45.45, 42.300000000000004}, {42.767667, Math.toDegrees(cMinLatZone1Radian)}};
    public static final double cMinLonZonesRadian = Math.toRadians(-4.416666666666665);
    public static final double cMaxLonZonesRadian = Math.toRadians(9.18);
    public static final double cMaxOverlappingZonesDegree = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private static int layoutZone = 0;
    private static NTV2GridShiftFile ntf_rgf93Grid = null;
    public static String[] lambert4zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, "51.30", "48.15"), I18n.tr("{0} ({1} to {2} degrees)", 2, "48.15", "45.45"), I18n.tr("{0} ({1} to {2} degrees)", 3, "45.45", "42.76"), I18n.tr("{0} (Corsica)", 4)};

    public static NTV2GridShiftFile getNtf_rgf93Grid() {
        return ntf_rgf93Grid;
    }

    public Lambert() {
        if (ntf_rgf93Grid == null) {
            try {
                String string = "ntf_r93_b.gsb";
                InputStream inputStream = Main.class.getResourceAsStream("/data/" + string);
                if (inputStream == null) {
                    System.err.println(I18n.tr("Warning: failed to open input stream for resource ''/data/{0}''. Cannot load NTF<->RGF93 grid", string));
                    return;
                }
                ntf_rgf93Grid = new NTV2GridShiftFile();
                ntf_rgf93Grid.loadGridShiftFile(inputStream, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        LatLon latLon2 = this.WGS84_to_NTF(latLon);
        double d = Math.toRadians(latLon2.lat());
        double d2 = Math.toRadians(latLon2.lon());
        if (d >= cMinLatZone1Radian && d <= cMaxLatZone1Radian && d2 >= cMinLonZonesRadian && d2 <= cMaxLonZonesRadian) {
            return this.ConicProjection(d, d2, Xs[layoutZone], Ys[layoutZone], c[layoutZone], n[layoutZone]);
        }
        return this.ConicProjection(d, d2, Xs[0], Ys[0], c[0], n[0]);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        LatLon latLon = this.Geographic(eastNorth, Xs[layoutZone], Ys[layoutZone], c[layoutZone], n[layoutZone]);
        return this.NTF_to_WGS84(latLon);
    }

    @Override
    public String toString() {
        return I18n.tr("Lambert 4 Zones (France)");
    }

    @Override
    public String toCode() {
        return "EPSG:" + (27561 + layoutZone);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + layoutZone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "lambert";
    }

    private EastNorth ConicProjection(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Ellipsoid.clarke.e * Math.sin(d);
        double d8 = Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow((1.0 - d7) / (1.0 + d7), Ellipsoid.clarke.e / 2.0));
        double d9 = d3 + d5 * Math.exp(-d6 * d8) * Math.sin(d6 * (d2 - 0.04079234433198));
        double d10 = d4 - d5 * Math.exp(-d6 * d8) * Math.cos(d6 * (d2 - 0.04079234433198));
        return new EastNorth(d9, d10);
    }

    private LatLon Geographic(EastNorth eastNorth, double d, double d2, double d3, double d4) {
        double d5 = eastNorth.east() - d;
        double d6 = d2 - eastNorth.north();
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = Math.atan(d5 / d6);
        double d9 = -1.0 / d4 * Math.log(Math.abs(d7 / d3));
        d9 = Math.exp(d9);
        double d10 = 0.04079234433198 + d8 / d4;
        double d11 = 2.0 * Math.atan(d9) - 1.5707963267948966;
        double d12 = 1.0;
        while (d12 > 1.0E-11) {
            double d13 = Ellipsoid.clarke.e * Math.sin(d11);
            double d14 = 2.0 * Math.atan(Math.pow((1.0 + d13) / (1.0 - d13), Ellipsoid.clarke.e / 2.0) * d9) - 1.5707963267948966;
            d12 = Math.abs(d14 - d11);
            d11 = d14;
        }
        return new LatLon(Math.toDegrees(d11), Math.toDegrees(d10));
    }

    private LatLon WGS84_to_NTF(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        if (ntf_rgf93Grid != null) {
            ntf_rgf93Grid.gridShiftReverse(nTV2GridShift);
            return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
        }
        return new LatLon(0.0, 0.0);
    }

    private LatLon NTF_to_WGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        if (ntf_rgf93Grid != null) {
            ntf_rgf93Grid.gridShiftForward(nTV2GridShift);
            return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
        }
        return new LatLon(0.0, 0.0);
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        Bounds bounds = new Bounds(new LatLon(zoneLimitsDegree[layoutZone][1] - 1.5, -4.907407407407406), new LatLon(zoneLimitsDegree[layoutZone][0] + 1.5, 10.2));
        return bounds;
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    public int getLayoutZone() {
        return layoutZone;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel) {
        JComboBox<String> jComboBox = new JComboBox<String>(lambert4zones);
        jComboBox.setSelectedIndex(layoutZone);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Lambert CC Zone")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        layoutZone = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Integer.toString(layoutZone + 1));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        layoutZone = 0;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((layoutZone = Integer.parseInt(string = iterator.next()) - 1) < 0 || layoutZone > 3)) {
                    layoutZone = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:2756") && string.length() == 9) {
            try {
                String string2 = string.substring(9);
                int n = Integer.parseInt(string2);
                if (n >= 1 && n <= 4) {
                    return Collections.singleton(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

