/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class GaussLaborde_Reunion
implements Projection {
    private static final double lon0 = Math.toRadians(55.53333333333333);
    private static final double lat0 = Math.toRadians(-21.116666666666667);
    private static final double x0 = 160000.0;
    private static final double y0 = 50000.0;
    private static final double k0 = 1.0;
    private static double sinLat0 = Math.sin(lat0);
    private static double cosLat0 = Math.cos(lat0);
    private static double n1 = Math.sqrt(1.0 + cosLat0 * cosLat0 * cosLat0 * cosLat0 * Ellipsoid.hayford.e2 / (1.0 - Ellipsoid.hayford.e2));
    private static double phic = Math.asin(sinLat0 / n1);
    private static double c = Ellipsoid.hayford.latitudeIsometric(phic, 0.0) - n1 * Ellipsoid.hayford.latitudeIsometric(lat0, Ellipsoid.hayford.e);
    private static double n2 = 1.0 * Ellipsoid.hayford.a * Math.sqrt(1.0 - Ellipsoid.hayford.e2) / (1.0 - Ellipsoid.hayford.e2 * sinLat0 * sinLat0);
    private static double xs = 160000.0;
    private static double ys = 50000.0 - n2 * phic;
    private static final double epsilon = 1.0E-11;
    private static final double scaleDiff = -3.23241E-5;
    private static final double Tx = 789.524;
    private static final double Ty = -626.486;
    private static final double Tz = -89.904;
    private static final double rx = Math.toRadians(1.6683333333333334E-4);
    private static final double ry = Math.toRadians(0.021331833333333335);
    private static final double rz = Math.toRadians(-0.0029385555555555554);
    private static final double rx2 = rx * rx;
    private static final double ry2 = ry * ry;
    private static final double rz2 = rz * rz;

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        LatLon latLon = this.Geographic(eastNorth);
        LatLon latLon2 = this.PTN2GRS80(latLon);
        return new LatLon(Math.toDegrees(latLon2.lat()), Math.toDegrees(latLon2.lon()));
    }

    private LatLon Geographic(EastNorth eastNorth) {
        double d = (eastNorth.east() - xs) / n2;
        double d2 = (eastNorth.north() - ys) / n2;
        double d3 = Math.atan(GaussLaborde_Reunion.sinh(d) / Math.cos(d2));
        double d4 = Ellipsoid.hayford.latitudeIsometric(Math.asin(Math.sin(d2) / GaussLaborde_Reunion.cosh(d)), 0.0);
        double d5 = lon0 + d3 / n1;
        double d6 = Ellipsoid.hayford.latitude((d4 - c) / n1, Ellipsoid.hayford.e, 1.0E-12);
        return new LatLon(d6, d5);
    }

    private LatLon PTN2GRS80(LatLon latLon) {
        double d = latLon.lat();
        double d2 = latLon.lon();
        double d3 = Ellipsoid.hayford.a / Math.sqrt(1.0 - Ellipsoid.hayford.e2 * Math.sin(d) * Math.sin(d));
        double d4 = d3 * Math.cos(d) * Math.cos(d2);
        double d5 = d3 * Math.cos(d) * Math.sin(d2);
        double d6 = d3 * (1.0 - Ellipsoid.hayford.e2) * Math.sin(d);
        double[] dArray = this.sevenParametersTransformation(d4, d5, d6);
        return this.cart2LatLon(dArray[0], dArray[1], dArray[2], Ellipsoid.GRS80);
    }

    private double[] sevenParametersTransformation(double d, double d2, double d3) {
        double d4 = 789.524 + d * 0.9999676759 + d3 * ry - d2 * rz;
        double d5 = -626.486 + d2 * 0.9999676759 + d * rz - d3 * rx;
        double d6 = -89.904 + d3 * 0.9999676759 + d2 * rx - d * ry;
        return new double[]{d4, d5, d6};
    }

    public EastNorth latlon2eastNorth(LatLon latLon) {
        LatLon latLon2 = this.GRS802Hayford(latLon);
        return this.GaussLabordeProjection(latLon2);
    }

    private LatLon GRS802Hayford(LatLon latLon) {
        double d = Math.toRadians(latLon.lat());
        double d2 = Math.toRadians(latLon.lon());
        double d3 = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(d) * Math.sin(d));
        double d4 = d3 * Math.cos(d) * Math.cos(d2);
        double d5 = d3 * Math.cos(d) * Math.sin(d2);
        double d6 = d3 * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(d);
        double[] dArray = this.invSevenParametersTransformation(d4, d5, d6);
        return this.Geographic(dArray[0], dArray[1], dArray[2], Ellipsoid.hayford);
    }

    private double[] invSevenParametersTransformation(double d, double d2, double d3) {
        double d4 = 0.9999676759;
        double d5 = d4 * d4;
        double d6 = d4 * (d5 + rx2 + ry2 + rz2);
        double d7 = ((d5 + rx2) * (d -= 789.524) + (d4 * rz + rx * ry) * (d2 -= -626.486) + (rx * rz - d4 * ry) * (d3 -= -89.904)) / d6;
        double d8 = ((-d4 * rz + rx * ry) * d + (d5 + ry2) * d2 + (d4 * rx + ry * rz) * d3) / d6;
        double d9 = ((d4 * ry + rx * rz) * d + (-d4 * rx + ry * rz) * d2 + (d5 + rz2) * d3) / d6;
        return new double[]{d7, d8, d9};
    }

    private LatLon Geographic(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double d4;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = 2.0 * Math.atan(d2 / (d + d5));
        double d7 = Math.atan(d3 / (d5 * (1.0 - ellipsoid.a * ellipsoid.e2 / Math.sqrt(d * d + d2 * d2 + d3 * d3))));
        double d8 = 1.0;
        while (d8 > 1.0E-11) {
            d4 = Math.sin(d7);
            d4 *= d4;
            double d9 = Math.atan(d3 / d5 / (1.0 - ellipsoid.a * ellipsoid.e2 * Math.cos(d7) / (d5 * Math.sqrt(1.0 - ellipsoid.e2 * d4))));
            d8 = Math.abs(d9 - d7);
            d7 = d9;
        }
        d4 = Math.sin(d7);
        d4 *= d4;
        return new LatLon(d7, d6);
    }

    private EastNorth GaussLabordeProjection(LatLon latLon) {
        double d = n1 * (latLon.lon() - lon0);
        double d2 = c + n1 * Ellipsoid.hayford.latitudeIsometric(latLon.lat());
        double d3 = xs + n2 * Ellipsoid.hayford.latitudeIsometric(Math.asin(Math.sin(d) / ((Math.exp(d2) + Math.exp(-d2)) / 2.0)), 0.0);
        double d4 = ys + n2 * Math.atan((Math.exp(d2) - Math.exp(-d2)) / 2.0 / Math.cos(d));
        return new EastNorth(d3, d4);
    }

    private LatLon cart2LatLon(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double d4;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = 2.0 * Math.atan(d2 / (d + d5));
        double d7 = Math.atan(d3 / (d5 * (1.0 - ellipsoid.a * ellipsoid.e2 / Math.sqrt(d * d + d2 * d2 + d3 * d3))));
        double d8 = 1.0;
        while (d8 > 1.0E-11) {
            d4 = Math.sin(d7);
            d4 *= d4;
            double d9 = Math.atan(d3 / d5 / (1.0 - ellipsoid.a * ellipsoid.e2 * Math.cos(d7) / (d5 * Math.sqrt(1.0 - ellipsoid.e2 * d4))));
            d8 = Math.abs(d9 - d7);
            d7 = d9;
        }
        d4 = Math.sin(d7);
        d4 *= d4;
        return new LatLon(d7, d6);
    }

    public static final double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static final double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public String getCacheDirectoryName() {
        return this.toString();
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-21.5, 55.14), new LatLon(-20.76, 55.94));
    }

    public String toCode() {
        return "EPSG::3727";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String toString() {
        return I18n.tr("Gauss-Laborde R\u00e9union 1947");
    }

    public double getDefaultZoomInPPD() {
        return 10.0;
    }
}

