/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MergeSourceBuildingVisitor
extends AbstractVisitor {
    private DataSet selectionBase;
    private DataSet hull;
    private HashMap<OsmPrimitive, PrimitiveData> mappedPrimitives;

    public MergeSourceBuildingVisitor(DataSet dataSet) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(dataSet, "selectionBase");
        this.selectionBase = dataSet;
        this.hull = new DataSet();
        this.mappedPrimitives = new HashMap();
    }

    protected boolean isInSelectionBase(OsmPrimitive osmPrimitive) {
        return this.selectionBase.getSelected().contains(osmPrimitive);
    }

    protected boolean isAlreadyRemembered(OsmPrimitive osmPrimitive) {
        return this.mappedPrimitives.keySet().contains(osmPrimitive);
    }

    protected void rememberNode(Node node) {
        if (this.isAlreadyRemembered(node)) {
            return;
        }
        this.mappedPrimitives.put(node, node.save());
    }

    protected void rememberWay(Way way) {
        if (this.isAlreadyRemembered(way)) {
            return;
        }
        WayData wayData = way.save();
        ArrayList<Long> arrayList = new ArrayList<Long>(way.getNodesCount());
        for (Node node : way.getNodes()) {
            arrayList.add(this.mappedPrimitives.get(node).getUniqueId());
        }
        wayData.setNodes(arrayList);
        this.mappedPrimitives.put(way, wayData);
    }

    protected void rememberRelation(Relation relation) {
        RelationData relationData;
        if (this.isAlreadyRemembered(relation)) {
            relationData = (RelationData)this.mappedPrimitives.get(relation);
        } else {
            relationData = relation.save();
            this.mappedPrimitives.put(relation, relationData);
        }
        ArrayList<RelationMemberData> arrayList = new ArrayList<RelationMemberData>();
        for (RelationMember relationMember : relation.getMembers()) {
            arrayList.add(new RelationMemberData(relationMember.getRole(), this.mappedPrimitives.get(relationMember.getMember())));
        }
        relationData.setMembers(arrayList);
    }

    protected void rememberRelationPartial(Relation relation) {
        if (this.isAlreadyRemembered(relation)) {
            return;
        }
        RelationData relationData = relation.save();
        relationData.getMembers().clear();
        this.mappedPrimitives.put(relation, relationData);
    }

    protected void rememberIncomplete(OsmPrimitive osmPrimitive) {
        if (this.isAlreadyRemembered(osmPrimitive)) {
            return;
        }
        PrimitiveData primitiveData = osmPrimitive.save();
        primitiveData.setIncomplete(true);
        this.mappedPrimitives.put(osmPrimitive, primitiveData);
    }

    public void visit(Node node) {
        this.rememberNode(node);
    }

    public void visit(Way way) {
        for (Node node : way.getNodes()) {
            node.visit(this);
        }
        this.rememberWay(way);
    }

    public void visit(Relation relation) {
        this.rememberRelationPartial(relation);
        for (RelationMember relationMember : relation.getMembers()) {
            if (this.isAlreadyRemembered(relationMember.getMember())) continue;
            if (this.isInSelectionBase(relationMember.getMember()) || relationMember.getMember().isNew()) {
                relationMember.getMember().visit(this);
                continue;
            }
            this.rememberIncomplete(relationMember.getMember());
        }
        this.rememberRelation(relation);
    }

    protected void buildHull() {
        for (PrimitiveData primitiveData : this.mappedPrimitives.values()) {
            this.hull.getPrimitiveById(primitiveData, true);
        }
        for (PrimitiveData primitiveData : this.mappedPrimitives.values()) {
            if (primitiveData.isIncomplete()) continue;
            this.hull.getPrimitiveById(primitiveData).load(primitiveData);
        }
    }

    public DataSet build() {
        for (OsmPrimitive osmPrimitive : this.selectionBase.getSelected()) {
            osmPrimitive.visit(this);
        }
        this.buildHull();
        return this.hull;
    }
}

