/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Way
extends OsmPrimitive {
    private Node[] nodes = new Node[0];
    private BBox bbox;
    public boolean isMappaintArea = false;
    public Integer mappaintDrawnAreaCode = 0;

    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    public void setNodes(List<Node> list) {
        for (Node node : this.nodes) {
            node.removeReferrer(this);
        }
        this.nodes = list == null ? new Node[0] : list.toArray(new Node[list.size()]);
        for (Node node : this.nodes) {
            node.addReferrer(this);
        }
        this.clearCached();
        this.fireNodesChanged();
    }

    public int getNodesCount() {
        return this.nodes.length;
    }

    public Node getNode(int n) {
        return this.nodes[n];
    }

    public boolean containsNode(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clearCached() {
        super.clearCached();
        this.isMappaintArea = false;
        this.mappaintDrawnAreaCode = 0;
    }

    public ArrayList<Pair<Node, Node>> getNodePairs(boolean bl) {
        ArrayList<Pair<Node, Node>> arrayList = new ArrayList<Pair<Node, Node>>();
        if (this.isIncomplete()) {
            return arrayList;
        }
        Node node = null;
        for (Node node2 : this.nodes) {
            if (node == null) {
                node = node2;
                continue;
            }
            Pair<Node, Node> pair = new Pair<Node, Node>(node, node2);
            if (bl) {
                Pair.sort(pair);
            }
            arrayList.add(pair);
            node = node2;
        }
        return arrayList;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    protected Way(long l, boolean bl) {
        super(l, bl);
    }

    public Way() {
        super(0L, false);
    }

    public Way(Way way, boolean bl) {
        super(way.getUniqueId(), true);
        this.cloneFrom(way);
        if (bl) {
            this.clearOsmId();
        }
    }

    public Way(Way way) {
        this(way, false);
    }

    public Way(long l) throws IllegalArgumentException {
        super(l, false);
    }

    public Way(long l, int n) {
        super(l, n, false);
    }

    @Override
    public void load(PrimitiveData primitiveData) {
        super.load(primitiveData);
        WayData wayData = (WayData)primitiveData;
        ArrayList<Node> arrayList = new ArrayList<Node>(wayData.getNodes().size());
        for (Long l : wayData.getNodes()) {
            Node node = (Node)this.getDataSet().getPrimitiveById(l, OsmPrimitiveType.NODE);
            if (node != null) {
                arrayList.add(node);
                continue;
            }
            throw new AssertionError((Object)"Data consistency problem - way with missing node detected");
        }
        this.setNodes(arrayList);
    }

    @Override
    public WayData save() {
        WayData wayData = new WayData();
        this.saveCommonAttributes(wayData);
        for (Node node : this.nodes) {
            wayData.getNodes().add(node.getUniqueId());
        }
        return wayData;
    }

    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        Way way = (Way)osmPrimitive;
        this.setNodes(way.getNodes());
    }

    public String toString() {
        String string = this.isIncomplete() ? "(incomplete)" : "nodes=" + Arrays.toString(this.nodes);
        return "{Way id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + string + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Way)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Way way = (Way)osmPrimitive;
        if (this.getNodesCount() != way.getNodesCount()) {
            return false;
        }
        for (int i = 0; i < this.getNodesCount(); ++i) {
            if (this.getNode(i).hasEqualSemanticAttributes(way.getNode(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Relation) {
            return 1;
        }
        return osmPrimitive instanceof Way ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : -1;
    }

    public void removeNode(Node node) {
        int n;
        if (this.isIncomplete()) {
            return;
        }
        boolean bl = this.lastNode() == node && this.firstNode() == node;
        List<Node> list = this.getNodes();
        while ((n = list.indexOf(node)) >= 0) {
            list.remove(n);
        }
        n = list.size();
        if (bl && n > 2) {
            list.add(list.get(0));
        } else if (n >= 2 && n <= 3 && list.get(0) == list.get(n - 1)) {
            list.remove(n - 1);
        }
        this.setNodes(list);
    }

    public void removeNodes(Collection<? extends OsmPrimitive> collection) {
        if (this.isIncomplete()) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.removeNode((Node)osmPrimitive);
        }
    }

    public void addNode(Node node) throws IllegalStateException {
        if (node == null) {
            return;
        }
        if (this.isIncomplete()) {
            throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
        }
        this.clearCached();
        node.addReferrer(this);
        Node[] nodeArray = new Node[this.nodes.length + 1];
        System.arraycopy(this.nodes, 0, nodeArray, 0, this.nodes.length);
        nodeArray[this.nodes.length] = node;
        this.nodes = nodeArray;
        this.fireNodesChanged();
    }

    public void addNode(int n, Node node) throws IllegalStateException, IndexOutOfBoundsException {
        if (node == null) {
            return;
        }
        if (this.isIncomplete()) {
            throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
        }
        this.clearCached();
        node.addReferrer(this);
        Node[] nodeArray = new Node[this.nodes.length + 1];
        System.arraycopy(this.nodes, 0, nodeArray, 0, n);
        System.arraycopy(this.nodes, n, nodeArray, n + 1, this.nodes.length - n);
        nodeArray[n] = node;
        this.nodes = nodeArray;
        this.fireNodesChanged();
    }

    @Override
    public void setDeleted(boolean bl) {
        for (Node node : this.nodes) {
            if (bl) {
                node.removeReferrer(this);
                continue;
            }
            node.addReferrer(this);
        }
        this.fireNodesChanged();
        super.setDeleted(bl);
    }

    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        return this.nodes.length >= 3 && this.lastNode() == this.firstNode();
    }

    public Node lastNode() {
        if (this.isIncomplete() || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[this.nodes.length - 1];
    }

    public Node firstNode() {
        if (this.isIncomplete() || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[0];
    }

    public boolean isFirstLastNode(Node node) {
        if (this.isIncomplete() || this.nodes.length == 0) {
            return false;
        }
        return node == this.firstNode() || node == this.lastNode();
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    private void checkNodes() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            for (Node node : this.nodes) {
                if (node.getDataSet() == dataSet) continue;
                throw new DataIntegrityProblemException("Nodes in way must be in the same dataset");
            }
            if (Main.pref.getBoolean("debug.checkDeleteReferenced")) {
                for (Node node : this.nodes) {
                    if (!node.isDeleted()) continue;
                    throw new DataIntegrityProblemException("Deleted node referenced: " + this.toString());
                }
            }
        }
    }

    private void fireNodesChanged() {
        this.checkNodes();
        if (this.getDataSet() != null) {
            this.getDataSet().fireWayNodesChanged(this);
        }
    }

    @Override
    public void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkNodes();
    }

    @Override
    public BBox getBBox() {
        if (this.getDataSet() == null) {
            return new BBox(this);
        }
        if (this.bbox == null) {
            this.bbox = new BBox(this);
        }
        return this.bbox;
    }

    @Override
    public void updatePosition() {
        this.bbox = new BBox(this);
    }

    public boolean hasIncompleteNodes() {
        for (Node node : this.nodes) {
            if (!node.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !this.hasIncompleteNodes();
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && !this.hasIncompleteNodes();
    }
}

