/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Relation
extends OsmPrimitive {
    private final List<RelationMember> members = new ArrayList<RelationMember>();
    private BBox bbox;

    public List<RelationMember> getMembers() {
        return new CopyList<RelationMember>(this.members.toArray(new RelationMember[this.members.size()]));
    }

    public void setMembers(List<RelationMember> list) {
        for (RelationMember relationMember : this.members) {
            relationMember.getMember().removeReferrer(this);
        }
        this.members.clear();
        if (list != null) {
            this.members.addAll(list);
        }
        for (RelationMember relationMember : this.members) {
            relationMember.getMember().addReferrer(this);
        }
        this.fireMembersChanged();
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public RelationMember getMember(int n) {
        return this.members.get(n);
    }

    public void addMember(RelationMember relationMember) {
        this.members.add(relationMember);
        relationMember.getMember().addReferrer(this);
        this.fireMembersChanged();
    }

    public void addMember(int n, RelationMember relationMember) {
        this.members.add(n, relationMember);
        relationMember.getMember().addReferrer(this);
        this.fireMembersChanged();
    }

    public RelationMember setMember(int n, RelationMember relationMember) {
        RelationMember relationMember2 = this.members.set(n, relationMember);
        if (relationMember2.getMember() != relationMember.getMember()) {
            relationMember.getMember().addReferrer(this);
            relationMember2.getMember().removeReferrer(this);
            this.fireMembersChanged();
        }
        return relationMember2;
    }

    public RelationMember removeMember(int n) {
        RelationMember relationMember = this.members.remove(n);
        for (RelationMember relationMember2 : this.members) {
            if (relationMember2.getMember() != relationMember.getMember()) continue;
            return relationMember;
        }
        relationMember.getMember().removeReferrer(this);
        this.fireMembersChanged();
        return relationMember;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    protected Relation(long l, boolean bl) {
        super(l, bl);
    }

    public Relation() {
        super(0L, false);
    }

    public Relation(Relation relation, boolean bl) {
        super(relation.getUniqueId(), true);
        this.cloneFrom(relation);
        if (bl) {
            this.clearOsmId();
        }
    }

    public Relation(Relation relation) {
        this(relation, false);
    }

    public Relation(long l) throws IllegalArgumentException {
        super(l, false);
    }

    public Relation(long l, int n) {
        super(l, n, false);
    }

    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.setMembers(((Relation)osmPrimitive).getMembers());
    }

    @Override
    public void load(PrimitiveData primitiveData) {
        super.load(primitiveData);
        RelationData relationData = (RelationData)primitiveData;
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMemberData relationMemberData : relationData.getMembers()) {
            OsmPrimitive osmPrimitive = this.getDataSet().getPrimitiveById(relationMemberData);
            if (osmPrimitive == null) {
                throw new AssertionError((Object)"Data consistency problem - relation with missing member detected");
            }
            arrayList.add(new RelationMember(relationMemberData.getRole(), osmPrimitive));
        }
        this.setMembers(arrayList);
    }

    @Override
    public RelationData save() {
        RelationData relationData = new RelationData();
        this.saveCommonAttributes(relationData);
        for (RelationMember relationMember : this.getMembers()) {
            relationData.getMembers().add(new RelationMemberData(relationMember.getRole(), relationMember.getMember()));
        }
        return relationData;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{Relation id=");
        stringBuilder.append(this.getUniqueId());
        stringBuilder.append(" version=");
        stringBuilder.append(this.getVersion());
        stringBuilder.append(" ");
        stringBuilder.append(this.getFlagsAsString());
        stringBuilder.append(" [");
        for (RelationMember relationMember : this.getMembers()) {
            stringBuilder.append((Object)OsmPrimitiveType.from(relationMember.getMember()));
            stringBuilder.append(" ");
            stringBuilder.append(relationMember.getMember().getUniqueId());
            stringBuilder.append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        stringBuilder.append("]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Relation)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Relation relation = (Relation)osmPrimitive;
        return ((Object)this.members).equals(relation.members);
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Relation ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : -1;
    }

    public RelationMember firstMember() {
        if (this.isIncomplete()) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(0);
    }

    public RelationMember lastMember() {
        if (this.isIncomplete()) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(this.members.size() - 1);
    }

    public void removeMembersFor(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return;
        }
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMember relationMember : this.members) {
            if (relationMember.getMember() != osmPrimitive) continue;
            arrayList.add(relationMember);
        }
        osmPrimitive.removeReferrer(this);
        this.members.removeAll(arrayList);
        this.fireMembersChanged();
    }

    @Override
    public void setDeleted(boolean bl) {
        for (RelationMember relationMember : this.members) {
            if (bl) {
                relationMember.getMember().removeReferrer(this);
                continue;
            }
            relationMember.getMember().addReferrer(this);
        }
        super.setDeleted(bl);
    }

    public void removeMembersFor(Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMember primitiveId : this.members) {
            if (!collection.contains(primitiveId.getMember())) continue;
            arrayList.add(primitiveId);
        }
        this.members.removeAll(arrayList);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.removeReferrer(this);
        }
        this.fireMembersChanged();
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.members) {
            if (relationMember.getMember() == null) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public BBox getBBox() {
        if (this.bbox == null) {
            this.calculateBBox(new HashSet<PrimitiveId>());
            if (this.bbox == null) {
                this.bbox = new BBox(0.0, 0.0, 0.0, 0.0);
            }
        }
        return this.bbox;
    }

    private BBox calculateBBox(Set<PrimitiveId> set) {
        if (set.contains(this)) {
            return null;
        }
        set.add(this);
        if (this.members.isEmpty()) {
            return null;
        }
        BBox bBox = null;
        for (RelationMember relationMember : this.members) {
            BBox bBox2 = relationMember.isRelation() ? relationMember.getRelation().calculateBBox(set) : relationMember.getMember().getBBox();
            if (bBox2 == null) continue;
            if (bBox == null) {
                bBox = bBox2;
                continue;
            }
            bBox.add(bBox2);
        }
        return bBox;
    }

    @Override
    public void updatePosition() {
        this.bbox = this.calculateBBox(new HashSet<PrimitiveId>());
    }

    @Override
    public void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkMembers();
    }

    private void checkMembers() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            for (RelationMember relationMember : this.members) {
                if (relationMember.getMember().getDataSet() == dataSet) continue;
                throw new DataIntegrityProblemException(String.format("Relation member must be part of the same dataset as relation(%s, %s)", this.getPrimitiveId(), relationMember.getMember().getPrimitiveId()));
            }
            if (Main.pref.getBoolean("debug.checkDeleteReferenced")) {
                for (RelationMember relationMember : this.members) {
                    if (!relationMember.getMember().isDeleted()) continue;
                    throw new DataIntegrityProblemException("Deleted member referenced: " + this.toString());
                }
            }
        }
    }

    private void fireMembersChanged() {
        this.checkMembers();
        if (this.getDataSet() != null) {
            this.getDataSet().fireRelationMembersChanged(this);
        }
    }
}

