/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBox {
    private double xmin = Double.POSITIVE_INFINITY;
    private double xmax = Double.NEGATIVE_INFINITY;
    private double ymin = Double.POSITIVE_INFINITY;
    private double ymax = Double.NEGATIVE_INFINITY;

    public BBox(Bounds bounds) {
        this.add(bounds.getMin());
        this.add(bounds.getMax());
    }

    public BBox(LatLon latLon, LatLon latLon2) {
        this.add(latLon);
        this.add(latLon2);
    }

    public BBox(double d, double d2, double d3, double d4) {
        this.xmin = Math.min(d, d3);
        this.xmax = Math.max(d, d3);
        this.ymin = Math.min(d2, d4);
        this.ymax = Math.max(d2, d4);
        this.sanity();
    }

    public BBox(Way way) {
        for (Node node : way.getNodes()) {
            LatLon latLon = node.getCoor();
            if (latLon == null) continue;
            this.add(latLon);
        }
    }

    private void sanity() {
        if (this.xmin < -180.0) {
            this.xmin = -180.0;
        }
        if (this.xmax > 180.0) {
            this.xmax = 180.0;
        }
        if (this.ymin < -90.0) {
            this.ymin = -90.0;
        }
        if (this.ymax > 90.0) {
            this.ymax = 90.0;
        }
    }

    public void add(LatLon latLon) {
        this.add(latLon.lon(), latLon.lat());
    }

    public void add(double d, double d2) {
        this.xmin = Math.min(this.xmin, d);
        this.xmax = Math.max(this.xmax, d);
        this.ymin = Math.min(this.ymin, d2);
        this.ymax = Math.max(this.ymax, d2);
        this.sanity();
    }

    public void add(BBox bBox) {
        this.add(bBox.getTopLeft());
        this.add(bBox.getBottomRight());
    }

    public void addPrimitive(OsmPrimitive osmPrimitive, double d) {
        BBox bBox = osmPrimitive.getBBox();
        this.add(bBox.xmin - d, bBox.ymin - d);
        this.add(bBox.xmax + d, bBox.ymax + d);
    }

    public double height() {
        return this.ymax - this.ymin;
    }

    public double width() {
        return this.xmax - this.xmin;
    }

    public boolean bounds(BBox bBox) {
        return this.xmin <= bBox.xmin && this.xmax >= bBox.xmax && this.ymin <= bBox.ymin && this.ymax >= bBox.ymax;
    }

    public boolean bounds(LatLon latLon) {
        return this.xmin <= latLon.lon() && this.xmax >= latLon.lon() && this.ymin <= latLon.lat() && this.ymax >= latLon.lat();
    }

    public boolean inside(BBox bBox) {
        if (this.xmin > bBox.xmax) {
            return false;
        }
        if (this.xmax < bBox.xmin) {
            return false;
        }
        if (this.ymin > bBox.ymax) {
            return false;
        }
        return !(this.ymax < bBox.ymin);
    }

    public boolean intersects(BBox bBox) {
        return this.inside(bBox) || bBox.inside(this);
    }

    public List<LatLon> points() {
        LatLon latLon = new LatLon(this.ymin, this.xmin);
        LatLon latLon2 = new LatLon(this.ymin, this.xmax);
        LatLon latLon3 = new LatLon(this.ymax, this.xmin);
        LatLon latLon4 = new LatLon(this.ymax, this.xmax);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        arrayList.add(latLon);
        arrayList.add(latLon2);
        arrayList.add(latLon3);
        arrayList.add(latLon4);
        return arrayList;
    }

    public LatLon getTopLeft() {
        return new LatLon(this.ymax, this.xmin);
    }

    public LatLon getBottomRight() {
        return new LatLon(this.ymin, this.xmax);
    }

    public int hashCode() {
        return (int)(this.ymin * this.xmin);
    }

    public boolean equals(Object object) {
        if (object instanceof BBox) {
            BBox bBox = (BBox)object;
            return bBox.xmax == this.xmax && bBox.ymax == this.ymax && bBox.xmin == this.xmin && bBox.ymin == this.ymin;
        }
        return false;
    }

    public String toString() {
        return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
    }
}

