/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class UndoRedoHandler
implements MapView.LayerChangeListener {
    public final LinkedList<Command> commands = new LinkedList();
    private final Stack<Command> redoCommands = new Stack();
    public final LinkedList<OsmDataLayer.CommandQueueListener> listenerCommands = new LinkedList();

    public UndoRedoHandler() {
        MapView.addLayerChangeListener(this);
    }

    public void addNoRedraw(Command command) {
        command.executeCommand();
        this.commands.add(command);
        this.redoCommands.clear();
    }

    public void afterAdd() {
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer osmDataLayer = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            osmDataLayer.fireDataChange();
        }
        this.fireCommandsChanged();
        Main.main.getCurrentDataSet().fireSelectionChanged();
    }

    public synchronized void add(Command command) {
        this.addNoRedraw(command);
        this.afterAdd();
    }

    public synchronized void undo() {
        Object object;
        if (this.commands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        Command command = this.commands.removeLast();
        command.undoCommand();
        this.redoCommands.push(command);
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            object = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            ((OsmDataLayer)object).fireDataChange();
        }
        this.fireCommandsChanged();
        object = Main.main.getCurrentDataSet().getSelected();
        if (!((Object)collection).equals(object)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void redo() {
        Object object;
        if (this.redoCommands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        Command command = this.redoCommands.pop();
        command.executeCommand();
        this.commands.add(command);
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            object = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            ((OsmDataLayer)object).fireDataChange();
        }
        this.fireCommandsChanged();
        object = Main.main.getCurrentDataSet().getSelected();
        if (!((Object)collection).equals(object)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void fireCommandsChanged() {
        for (OsmDataLayer.CommandQueueListener commandQueueListener : this.listenerCommands) {
            commandQueueListener.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void clean(Layer layer) {
        if (layer == null) {
            return;
        }
        boolean bl = false;
        Iterator iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            if (!((Command)iterator.next()).invalidBecauselayerRemoved(layer)) continue;
            iterator.remove();
            bl = true;
        }
        iterator = this.redoCommands.iterator();
        while (iterator.hasNext()) {
            if (!((Command)iterator.next()).invalidBecauselayerRemoved(layer)) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            this.fireCommandsChanged();
        }
    }

    public void layerRemoved(Layer layer) {
        this.clean(layer);
    }

    public void layerAdded(Layer layer) {
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }
}

