/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiedConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<? extends OsmPrimitive> conflict;

    public ModifiedConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        this.conflict = conflict;
    }

    @Override
    public MutableTreeNode description() {
        String string = "";
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                string = I18n.marktr("Set the ''modified'' flag for node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("Set the ''modified'' flag for way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("Set the ''modified'' flag for relation {0}");
            }
        }
        return new DefaultMutableTreeNode(new JLabel(I18n.tr(string, this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.conflict.getMy().isNew() && this.conflict.getMy().hasEqualSemanticAttributes(this.conflict.getTheir())) {
            this.conflict.getMy().setModified(this.conflict.getTheir().isModified());
        }
        this.getLayer().getConflicts().remove(this.conflict);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

