/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.actionsupport.DeleteFromRelationConfirmationDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> toDelete;
    private final Map<OsmPrimitive, PrimitiveData> clonedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();

    public DeleteCommand(Collection<? extends OsmPrimitive> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be empty");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection"));
        }
        this.toDelete = collection;
    }

    public DeleteCommand(OsmPrimitive osmPrimitive) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "data");
        this.toDelete = Collections.singleton(osmPrimitive);
    }

    public DeleteCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive) throws IllegalArgumentException {
        super(osmDataLayer);
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "data");
        this.toDelete = Collections.singleton(osmPrimitive);
    }

    public DeleteCommand(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) throws IllegalArgumentException {
        super(osmDataLayer);
        if (collection == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be empty");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection"));
        }
        this.toDelete = collection;
    }

    @Override
    public boolean executeCommand() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive.isDeleted()) {
                throw new IllegalArgumentException(osmPrimitive.toString() + " is already deleted");
            }
            this.clonedPrimitives.put(osmPrimitive, osmPrimitive.save());
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).setNodes(null);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ((Relation)osmPrimitive).setMembers(null);
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        for (OsmPrimitive object : this.toDelete) {
            object.setDeleted(false);
        }
        for (Map.Entry entry : this.clonedPrimitives.entrySet()) {
            ((OsmPrimitive)entry.getKey()).load((PrimitiveData)entry.getValue());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection2.addAll(this.toDelete);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableTreeNode description() {
        void var3_8;
        Object object;
        if (this.toDelete.size() == 1) {
            OsmPrimitive osmPrimitive = this.toDelete.iterator().next();
            String string = "";
            switch (OsmPrimitiveType.from(osmPrimitive)) {
                case NODE: {
                    string = I18n.marktr("Delete node {0}");
                    break;
                }
                case WAY: {
                    string = I18n.marktr("Delete way {0}");
                    break;
                }
                case RELATION: {
                    string = I18n.marktr("Delete relation {0}");
                }
            }
            return new DefaultMutableTreeNode(new JLabel(I18n.tr(string, osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0));
        }
        HashSet<OsmPrimitiveType> hashSet = new HashSet<OsmPrimitiveType>();
        for (OsmPrimitive object22 : this.toDelete) {
            hashSet.add(OsmPrimitiveType.from(object22));
        }
        Object object3 = "";
        String string = "object";
        if (hashSet.size() > 1) {
            object3 = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            object = (OsmPrimitiveType)((Object)hashSet.iterator().next());
            String string2 = ((OsmPrimitiveType)((Object)object)).getAPIName();
            switch (1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[((Enum)object).ordinal()]) {
                case 1: {
                    object3 = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case 2: {
                    object3 = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case 3: {
                    object3 = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                }
            }
        }
        object = new DefaultMutableTreeNode(new JLabel((String)object3, ImageProvider.get("data", (String)var3_8), 0));
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0)));
        }
        return object;
    }

    public static Command deleteWithReferences(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Set<OsmPrimitive> set = OsmPrimitive.getReferrer(collection);
        set.addAll(collection);
        if (set.isEmpty()) {
            return null;
        }
        if (!DeleteCommand.checkAndConfirmOutlyingDeletes(osmDataLayer, set) && !bl) {
            return null;
        }
        return new DeleteCommand(osmDataLayer, set);
    }

    public static Command deleteWithReferences(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.deleteWithReferences(osmDataLayer, collection, false);
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.delete(osmDataLayer, collection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Way way : OsmPrimitive.getFilteredList(collection, Way.class)) {
            for (Node node : way.getNodes()) {
                if (node.isTagged()) continue;
                List<OsmPrimitive> list = node.getReferrers();
                list.removeAll(collection);
                int n = 0;
                for (OsmPrimitive osmPrimitive : list) {
                    if (osmPrimitive.isDeleted()) continue;
                    ++n;
                }
                if (n != 0) continue;
                hashSet.add(node);
            }
        }
        return hashSet;
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl) {
        return DeleteCommand.delete(osmDataLayer, collection, bl, false);
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl, boolean bl2) {
        Object object;
        Collection<Node> collection2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        HashSet<Way> hashSet2 = new HashSet<Way>();
        if (bl) {
            collection2 = DeleteCommand.computeNodesToDelete(osmDataLayer, hashSet);
            hashSet.addAll(collection2);
        }
        if (!bl2 && !DeleteCommand.checkAndConfirmOutlyingDeletes(osmDataLayer, hashSet)) {
            return null;
        }
        hashSet2.addAll(OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(hashSet), Way.class));
        collection2 = new LinkedList<Node>();
        for (Way object2 : hashSet2) {
            object = new Way(object2);
            ((Way)object).removeNodes(hashSet);
            if (((Way)object).getNodesCount() < 2) {
                hashSet.add(object2);
                continue;
            }
            collection2.add((Node)((Object)new ChangeCommand(object2, (OsmPrimitive)object)));
        }
        if (!bl2) {
            Iterator iterator = RelationToChildReference.getRelationToChildReferences(hashSet);
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                object = (RelationToChildReference)iterator2.next();
                if (!((RelationToChildReference)object).getParent().isDeleted()) continue;
                iterator2.remove();
            }
            if (!iterator.isEmpty()) {
                object = DeleteFromRelationConfirmationDialog.getInstance();
                ((DeleteFromRelationConfirmationDialog)object).getModel().populate((Collection<RelationToChildReference>)((Object)iterator));
                ((DeleteFromRelationConfirmationDialog)object).setVisible(true);
                if (((DeleteFromRelationConfirmationDialog)object).isCanceled()) {
                    return null;
                }
            }
        }
        for (Relation relation : OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(hashSet), Relation.class)) {
            object = new Relation(relation);
            ((Relation)object).removeMembersFor(hashSet);
            collection2.add((Node)((Object)new ChangeCommand(relation, (OsmPrimitive)object)));
        }
        if (!hashSet.isEmpty()) {
            collection2.add((Node)((Object)new DeleteCommand(osmDataLayer, hashSet)));
        }
        return new SequenceCommand(I18n.tr("Delete"), collection2);
    }

    public static Command deleteWaySegment(OsmDataLayer osmDataLayer, WaySegment waySegment) {
        if (waySegment.way.getNodesCount() < 3) {
            return DeleteCommand.delete(osmDataLayer, Collections.singleton(waySegment.way));
        }
        if (waySegment.way.firstNode() == waySegment.way.lastNode()) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.addAll(waySegment.way.getNodes().subList(waySegment.lowerIndex + 1, waySegment.way.getNodesCount() - 1));
            arrayList.addAll(waySegment.way.getNodes().subList(0, waySegment.lowerIndex + 1));
            Way way = new Way(waySegment.way);
            way.setNodes(arrayList);
            return new ChangeCommand(waySegment.way, way);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList.addAll(waySegment.way.getNodes().subList(0, waySegment.lowerIndex + 1));
        arrayList2.addAll(waySegment.way.getNodes().subList(waySegment.lowerIndex + 1, waySegment.way.getNodesCount()));
        Way way = new Way(waySegment.way);
        if (arrayList.size() < 2) {
            way.setNodes(arrayList2);
            return new ChangeCommand(waySegment.way, way);
        }
        if (arrayList2.size() < 2) {
            way.setNodes(arrayList);
            return new ChangeCommand(waySegment.way, way);
        }
        ArrayList<List<Node>> arrayList3 = new ArrayList<List<Node>>(2);
        arrayList3.add(arrayList);
        arrayList3.add(arrayList2);
        return SplitWayAction.splitWay(waySegment.way, arrayList3).getCommand();
    }

    private static boolean checkAndConfirmOutlyingDeletes(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        Area area = osmDataLayer.data.getDataSourceArea();
        if (area != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                Node node;
                if (!(osmPrimitive instanceof Node) || osmPrimitive.isNew() || area.contains((node = (Node)osmPrimitive).getCoor())) continue;
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add(new JLabel("<html>" + I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to delete?") + "</html>"));
                return ConditionalOptionPaneUtil.showConfirmationDialog("delete_outside_nodes", Main.parent, jPanel, I18n.tr("Delete confirmation"), 0, 3, 0);
            }
        }
        return true;
    }
}

