/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAction
extends JosmAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 10;
    public static final LinkedList<SearchSetting> searchHistory = new LinkedList();
    private static SearchSetting lastSearch = null;

    public SearchAction() {
        super(I18n.tr("Search..."), "dialogs/search", I18n.tr("Search for objects."), Shortcut.registerShortcut("system:find", I18n.tr("Search..."), 70, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SearchSetting searchSetting;
        if (!this.isEnabled()) {
            return;
        }
        SearchSetting searchSetting2 = lastSearch;
        if (searchSetting2 == null) {
            searchSetting2 = new SearchSetting();
        }
        if ((searchSetting = SearchAction.showSearchDialog(searchSetting2)) != null) {
            SearchAction.searchWithHistory(searchSetting);
        }
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(searchHistory.size());
        for (SearchSetting searchSetting : searchHistory) {
            arrayList.add(searchSetting.text);
        }
        return arrayList;
    }

    public static SearchSetting showSearchDialog(SearchSetting searchSetting) {
        JLabel jLabel = new JLabel(searchSetting instanceof Filter ? I18n.tr("Please enter a filter string.") : I18n.tr("Please enter a search string."));
        HistoryComboBox historyComboBox = new HistoryComboBox();
        historyComboBox.setText(searchSetting.text);
        historyComboBox.getEditor().selectAll();
        historyComboBox.getEditor().getEditorComponent().requestFocusInWindow();
        historyComboBox.setToolTipText(I18n.tr("Enter the search expression"));
        List<String> list = SearchAction.getSearchExpressionHistory();
        Collections.reverse(list);
        historyComboBox.setPossibleItems(list);
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("replace selection"), searchSetting.mode == SearchMode.replace);
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("add to selection"), searchSetting.mode == SearchMode.add);
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("remove from selection"), searchSetting.mode == SearchMode.remove);
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("find in selection"), searchSetting.mode == SearchMode.in_selection);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("case sensitive"), searchSetting.caseSensitive);
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("regular expression"), searchSetting.regexSearch);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.eop());
        jPanel.add((Component)historyComboBox, GBC.eop().fill(2));
        jPanel.add((Component)jRadioButton, GBC.eol());
        jPanel.add((Component)jRadioButton2, GBC.eol());
        jPanel.add((Component)jRadioButton3, GBC.eol());
        jPanel.add((Component)jRadioButton4, GBC.eop());
        jPanel.add((Component)jCheckBox, GBC.eol());
        jPanel.add((Component)jCheckBox2, GBC.eol());
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel("<html><ul><li>" + I18n.tr("<b>Baker Street</b> - ''Baker'' and ''Street'' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>\"Baker Street\"</b> - ''Baker Street'' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>name:Bak</b> - ''Bak'' anywhere in the name.") + "</li>" + "<li>" + I18n.tr("<b>type=route</b> - key ''type'' with value exactly ''route''.") + "</li>" + "<li>" + I18n.tr("<b>type=*</b> - key ''type'' with any value. Try also <b>*=value</b>, <b>type=</b>, <b>*=*</b>, <b>*=</b>") + "</li>" + "<li>" + I18n.tr("<b>-name:Bak</b> - not ''Bak'' in the name.") + "</li>" + "<li>" + I18n.tr("<b>oneway?</b> - oneway=yes, true, 1 or on") + "</li>" + "<li>" + I18n.tr("<b>foot:</b> - key=foot set to any value.") + "</li>" + "<li>" + I18n.tr("<u>Special targets:</u>") + "</li>" + "<li>" + I18n.tr("<b>type:</b> - type of the object (<b>node</b>, <b>way</b>, <b>relation</b>)") + "</li>" + "<li>" + I18n.tr("<b>user:</b>... - all objects changed by user") + "</li>" + "<li>" + I18n.tr("<b>user:anonymous</b> - all objects changed by anonymous users") + "</li>" + "<li>" + I18n.tr("<b>id:</b>... - object with given ID (0 for new objects)") + "</li>" + "<li>" + I18n.tr("<b>version:</b>... - object with given version (0 objects without an assigned version)") + "</li>" + "<li>" + I18n.tr("<b>changeset:</b>... - object with given changeset id (0 objects without assigned changeset)") + "</li>" + "<li>" + I18n.tr("<b>nodes:</b>... - object with given number of nodes (nodes:count or nodes:min-max)") + "</li>" + "<li>" + I18n.tr("<b>tags:</b>... - object with given number of tags (tags:count or tags:min-max)") + "</li>" + "<li>" + I18n.tr("<b>timestamp:</b>... -  objects with this timestamp (<b>2009-11-12T14:51:09Z</b>, <b>2009-11-12</b> or <b>T14:51</b> ...)") + "</li>" + "<li>" + I18n.tr("<b>modified</b> - all changed objects") + "</li>" + "<li>" + I18n.tr("<b>selected</b> - all selected objects") + "</li>" + "<li>" + I18n.tr("<b>incomplete</b> - all incomplete objects") + "</li>" + "<li>" + I18n.tr("<b>untagged</b> - all untagged objects") + "</li>" + "<li>" + I18n.tr("<b>child <i>expr</i></b> - all children of objects matching the expression") + "</li>" + "<li>" + I18n.tr("<b>parent <i>expr</i></b> - all parents of objects matching the expression") + "</li>" + "<li>" + I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or") + "</li>" + "<li>" + I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains <b>:</b>)") + "<br/>" + I18n.tr("Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).") + "</li>" + "<li>" + I18n.tr("Use <b>(</b> and <b>)</b> to group expressions") + "</li>" + "</ul></html>");
        jLabel2.setFont(jLabel2.getFont().deriveFont(0));
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, searchSetting instanceof Filter ? I18n.tr("Filter") : I18n.tr("Search"), new String[]{searchSetting instanceof Filter ? I18n.tr("Submit filter") : I18n.tr("Start Search"), I18n.tr("Cancel")});
        extendedDialog.setButtonIcons(new String[]{"dialogs/search.png", "cancel.png"});
        extendedDialog.configureContextsensitiveHelp("/Action/Search", true);
        extendedDialog.setContent(jPanel3);
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n != 1) {
            return null;
        }
        SearchMode searchMode = jRadioButton.isSelected() ? SearchMode.replace : (jRadioButton2.isSelected() ? SearchMode.add : (jRadioButton3.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        searchSetting.text = historyComboBox.getText();
        searchSetting.mode = searchMode;
        searchSetting.caseSensitive = jCheckBox.isSelected();
        searchSetting.regexSearch = jCheckBox2.isSelected();
        return searchSetting;
    }

    public static void searchWithHistory(SearchSetting searchSetting) {
        if (searchHistory.isEmpty() || !searchSetting.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(searchSetting));
        }
        int n = Main.pref.getInteger("search.history-size", 10);
        while (searchHistory.size() > n) {
            searchHistory.removeLast();
        }
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static void searchWithoutHistory(SearchSetting searchSetting) {
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static int getSelection(SearchSetting searchSetting, Collection<OsmPrimitive> collection, Function function) {
        int n = 0;
        try {
            String string = searchSetting.text;
            if (searchSetting instanceof Filter) {
                string = "(" + searchSetting.text + ")" + (((Filter)searchSetting).applyForChildren != false ? "| child (" + searchSetting.text + ")" : "");
                string = (((Filter)searchSetting).inverted != false ? "-" : "") + "(" + string + ")";
            }
            SearchCompiler.Match match = SearchCompiler.compile(string, searchSetting.caseSensitive, searchSetting.regexSearch);
            if (searchSetting.mode == SearchMode.replace) {
                collection.clear();
            }
            for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives()) {
                if (searchSetting.mode == SearchMode.replace) {
                    if (!match.match(osmPrimitive)) continue;
                    collection.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode == SearchMode.add && !function.isSomething(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    collection.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode == SearchMode.remove && function.isSomething(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    collection.remove(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode != SearchMode.in_selection || !function.isSomething(osmPrimitive).booleanValue() || match.match(osmPrimitive)) continue;
                collection.remove(osmPrimitive);
                ++n;
            }
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error"), 0);
        }
        return n;
    }

    public static void search(String string, SearchMode searchMode, boolean bl, boolean bl2) {
        SearchAction.search(new SearchSetting(string, searchMode, bl, bl2));
    }

    public static void search(SearchSetting searchSetting) {
        final DataSet dataSet = Main.main.getCurrentDataSet();
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(dataSet.getSelected());
        int n = SearchAction.getSelection(searchSetting, hashSet, new Function(){

            public Boolean isSomething(OsmPrimitive osmPrimitive) {
                return dataSet.isSelected(osmPrimitive);
            }
        });
        dataSet.setSelected(hashSet);
        if (n == 0) {
            String string = null;
            if (searchSetting.mode == SearchMode.replace) {
                string = I18n.tr("No match found for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.add) {
                string = I18n.tr("Nothing added to selection by searching for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.remove) {
                string = I18n.tr("Nothing removed from selection by searching for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.in_selection) {
                string = I18n.tr("Nothing found in selection by searching for ''{0}''", searchSetting.text);
            }
            Main.map.statusLine.setHelpText(string);
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning"), 2);
        } else {
            Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", n));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;

        public SearchSetting() {
            this("", SearchMode.replace, false, false);
        }

        public SearchSetting(String string, SearchMode searchMode, boolean bl, boolean bl2) {
            this.caseSensitive = bl;
            this.regexSearch = bl2;
            this.mode = searchMode;
            this.text = string;
        }

        public SearchSetting(SearchSetting searchSetting) {
            this(searchSetting.text, searchSetting.mode, searchSetting.caseSensitive, searchSetting.regexSearch);
        }

        public String toString() {
            String string = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
            String string2 = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
            return "\"" + this.text + "\" (" + string + string2 + ", " + (Object)((Object)this.mode) + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchSetting)) {
                return false;
            }
            SearchSetting searchSetting = (SearchSetting)object;
            return searchSetting.caseSensitive == this.caseSensitive && searchSetting.regexSearch == this.regexSearch && searchSetting.mode.equals((Object)this.mode) && searchSetting.text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }
    }

    public static interface Function {
        public Boolean isSomething(OsmPrimitive var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace,
        add,
        remove,
        in_selection;

    }
}

