/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    public SaveActionBase(String string, String string2, String string3, Shortcut shortcut) {
        super(string, string2, string3, shortcut);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.doSave();
    }

    public boolean doSave() {
        Layer layer = null;
        if (Main.isDisplayingMapView() && (Main.map.mapView.getActiveLayer() instanceof OsmDataLayer || Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            layer = Main.map.mapView.getActiveLayer();
        }
        if (layer == null) {
            return false;
        }
        return this.doSave(layer);
    }

    public boolean doSave(Layer layer) {
        if (layer == null) {
            return false;
        }
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        if (!this.checkSaveConditions(layer)) {
            return false;
        }
        File file = this.getFile(layer);
        if (file == null) {
            return false;
        }
        try {
            boolean bl = false;
            for (FileExporter fileExporter : ExtensionFileFilter.exporters) {
                if (!fileExporter.acceptFile(file, layer)) continue;
                fileExporter.exportData(file, layer);
                bl = true;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No Exporter found! Nothing saved."), I18n.tr("Warning"), 2);
                return false;
            }
            layer.setName(file.getName());
            layer.setAssociatedFile(file);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).onPostSaveToFile();
            }
            Main.parent.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    protected abstract File getFile(Layer var1);

    public boolean checkSaveConditions(Layer layer) {
        Object object;
        if (layer instanceof OsmDataLayer && this.isDataSetEmpty((OsmDataLayer)layer)) {
            object = new ExtendedDialog(Main.parent, I18n.tr("Empty document"), new String[]{I18n.tr("Save anyway"), I18n.tr("Cancel")});
            ((ExtendedDialog)object).setContent(I18n.tr("The document contains no data."));
            ((ExtendedDialog)object).setButtonIcons(new String[]{"save.png", "cancel.png"});
            ((ExtendedDialog)object).showDialog();
            if (((ExtendedDialog)object).getValue() != 1) {
                return false;
            }
        }
        if (layer instanceof GpxLayer && ((GpxLayer)layer).data == null) {
            return false;
        }
        if (layer instanceof OsmDataLayer && (object = ((OsmDataLayer)layer).getConflicts()) != null && !((ConflictCollection)object).isEmpty()) {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Conflicts"), new String[]{I18n.tr("Reject Conflicts and Save"), I18n.tr("Cancel")});
            extendedDialog.setContent(I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?"));
            extendedDialog.setButtonIcons(new String[]{"save.png", "cancel.png"});
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                return false;
            }
        }
        return true;
    }

    public static File openFileDialog(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save OSM file"), "osm");
        }
        if (layer instanceof GpxLayer) {
            return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file"), "gpx");
        }
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer"), "lay");
    }

    private boolean isDataSetEmpty(OsmDataLayer osmDataLayer) {
        for (OsmPrimitive osmPrimitive : osmDataLayer.data.allNonDeletedPrimitives()) {
            if (osmPrimitive.isDeleted() && osmPrimitive.isNew()) continue;
            return false;
        }
        return true;
    }

    protected void updateEnabledState() {
        boolean bl;
        if (Main.applet) {
            this.setEnabled(false);
            return;
        }
        boolean bl2 = bl = Main.map != null && Main.map.mapView != null && Main.map.mapView.getActiveLayer() != null;
        if (!bl) {
            this.setEnabled(false);
            return;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        this.setEnabled(layer instanceof OsmDataLayer || layer instanceof GpxLayer);
    }

    public static File createAndOpenSaveFileChooser(String string, String string2) {
        Object object;
        String string3 = Main.pref.get("lastDirectory");
        if (string3.equals("")) {
            string3 = ".";
        }
        JFileChooser jFileChooser = new JFileChooser(new File(string3));
        if (string != null) {
            jFileChooser.setDialogTitle(string);
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter.applyChoosableExportFileFilters(jFileChooser, string2);
        int n = jFileChooser.showSaveDialog(Main.parent);
        if (n != 0) {
            return null;
        }
        if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string3)) {
            Main.pref.put("lastDirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
        }
        File file = jFileChooser.getSelectedFile();
        if (string2 != null && ((String)(object = file.getPath())).indexOf(46) == -1) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            object = fileFilter instanceof ExtensionFileFilter ? (String)object + "." + ((ExtensionFileFilter)fileFilter).getDefaultExtension() : (String)object + string2;
            file = new File((String)object);
        }
        if (file == null || file.exists()) {
            object = new ExtendedDialog(Main.parent, I18n.tr("Overwrite"), new String[]{I18n.tr("Overwrite"), I18n.tr("Cancel")});
            ((ExtendedDialog)object).setContent(I18n.tr("File exists. Overwrite?"));
            ((ExtendedDialog)object).setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            ((ExtendedDialog)object).showDialog();
            if (((ExtendedDialog)object).getValue() != 1) {
                return null;
            }
        }
        return file;
    }
}

