/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle"), "aligncircle", I18n.tr("Move the selected nodes into a circle."), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle")), 79, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInCircle"));
    }

    public double distance(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        return Math.sqrt(d * d + d2 * d2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Comparable<OsmPrimitive> comparable;
        Object object;
        Comparable<BigDecimal> comparable2;
        Object object2;
        Object object3;
        Object object5;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        Serializable serializable2 = new LinkedList<Node>();
        LinkedList<Way> linkedList = new LinkedList<Way>();
        EastNorth eastNorth = null;
        double d = 0.0;
        boolean bl = false;
        for (OsmPrimitive object62 : collection) {
            if (object62 instanceof Node) {
                serializable2.add((Node)object62);
                continue;
            }
            if (!(object62 instanceof Way)) continue;
            linkedList.add((Way)object62);
        }
        if (serializable2.size() <= 2 && linkedList.size() == 1) {
            object5 = (Way)linkedList.get(0);
            if (serializable2.size() > 0) {
                if (serializable2.size() == 1 && ((Way)object5).containsNode((Node)serializable2.get(0))) {
                    bl = true;
                } else {
                    eastNorth = ((Node)serializable2.get(((Way)object5).containsNode((Node)serializable2.get(0)) ? 1 : 0)).getEastNorth();
                    if (serializable2.size() == 2) {
                        d = this.distance(((Node)serializable2.get(0)).getEastNorth(), ((Node)serializable2.get(1)).getEastNorth());
                    }
                }
                serializable2 = new LinkedList();
            }
            for (Node node : ((Way)object5).getNodes()) {
                if (serializable2.contains(node)) continue;
                serializable2.add(node);
            }
        }
        if (serializable2.size() < 4) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least four nodes."), I18n.tr("Information"), 1);
            return;
        }
        if (linkedList.size() != 1) {
            void var10_13;
            object5 = new BigDecimal(0);
            BigDecimal bigDecimal = new BigDecimal(0);
            Iterator iterator = serializable2.iterator();
            while (iterator.hasNext()) {
                object3 = (Node)iterator.next();
                object2 = new BigDecimal(((Node)object3).getEastNorth().east());
                BigDecimal bigDecimal2 = new BigDecimal(((Node)object3).getEastNorth().north());
                object5 = ((BigDecimal)object5).add((BigDecimal)object2, MathContext.DECIMAL128);
                BigDecimal bigDecimal3 = var10_13.add(bigDecimal2, MathContext.DECIMAL128);
            }
            BigDecimal bigDecimal4 = new BigDecimal(serializable2.size());
            object5 = ((BigDecimal)object5).divide(bigDecimal4, MathContext.DECIMAL128);
            BigDecimal bigDecimal5 = var10_13.divide(bigDecimal4, MathContext.DECIMAL128);
            object3 = new EastNorth(((BigDecimal)object5).doubleValue(), bigDecimal5.doubleValue());
            object2 = new LinkedList();
            while (!serializable2.isEmpty()) {
                double d2 = -1.0;
                comparable2 = null;
                object = serializable2.iterator();
                while (object.hasNext()) {
                    comparable = (Node)object.next();
                    double d3 = ((EastNorth)object3).heading(comparable.getEastNorth());
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                    comparable2 = comparable;
                }
                object2.add(comparable2);
                serializable2.remove(comparable2);
            }
            serializable2 = object2;
        }
        if (eastNorth == null) {
            void var10_18;
            void var11_32;
            object5 = new BigDecimal(0);
            BigDecimal bigDecimal = new BigDecimal(0);
            BigDecimal bigDecimal6 = new BigDecimal(0);
            for (int i = 0; i < serializable2.size(); ++i) {
                object2 = ((Node)serializable2.get(i)).getEastNorth();
                EastNorth eastNorth2 = ((Node)serializable2.get((i + 1) % serializable2.size())).getEastNorth();
                serializable = new BigDecimal(((EastNorth)object2).east());
                comparable2 = new BigDecimal(((EastNorth)object2).north());
                object = new BigDecimal(eastNorth2.east());
                comparable = new BigDecimal(eastNorth2.north());
                BigDecimal bigDecimal7 = ((BigDecimal)serializable).multiply((BigDecimal)comparable, MathContext.DECIMAL128).subtract(((BigDecimal)comparable2).multiply((BigDecimal)object, MathContext.DECIMAL128));
                object5 = ((BigDecimal)object5).add(bigDecimal7, MathContext.DECIMAL128);
                BigDecimal bigDecimal8 = var11_32.add(bigDecimal7.multiply(((BigDecimal)serializable).add((BigDecimal)object, MathContext.DECIMAL128), MathContext.DECIMAL128));
                BigDecimal bigDecimal9 = var10_18.add(bigDecimal7.multiply(((BigDecimal)comparable2).add((BigDecimal)comparable, MathContext.DECIMAL128), MathContext.DECIMAL128));
            }
            object3 = new BigDecimal(3, MathContext.DECIMAL128);
            object5 = ((BigDecimal)object5).multiply((BigDecimal)object3, MathContext.DECIMAL128);
            BigDecimal bigDecimal10 = var10_18.divide((BigDecimal)object5, MathContext.DECIMAL128);
            BigDecimal bigDecimal11 = var11_32.divide((BigDecimal)object5, MathContext.DECIMAL128);
            eastNorth = new EastNorth(bigDecimal11.doubleValue(), bigDecimal10.doubleValue());
        }
        if (d == 0.0) {
            object5 = serializable2.iterator();
            while (object5.hasNext()) {
                Node node = (Node)object5.next();
                d += this.distance(eastNorth, node.getEastNorth());
            }
            d /= (double)serializable2.size();
        }
        object5 = new LinkedList();
        if (bl) {
            double d4 = Math.PI * 2 / (double)serializable2.size();
            PolarCoor polarCoor = new PolarCoor(((Node)serializable2.get(0)).getEastNorth(), eastNorth, 0.0);
            PolarCoor polarCoor2 = new PolarCoor(((Node)serializable2.get(1)).getEastNorth(), eastNorth, 0.0);
            if (polarCoor.angle > polarCoor2.angle) {
                d4 *= -1.0;
            }
            polarCoor.radius = d;
            object2 = serializable2.iterator();
            while (object2.hasNext()) {
                Node node = (Node)object2.next();
                serializable = polarCoor.toEastNorth();
                object5.add(new MoveCommand(node, ((EastNorth)serializable).east() - node.getEastNorth().east(), ((EastNorth)serializable).north() - node.getEastNorth().north()));
                polarCoor.angle += d4;
            }
        } else {
            Iterator iterator = serializable2.iterator();
            while (iterator.hasNext()) {
                object3 = (Node)iterator.next();
                PolarCoor polarCoor = new PolarCoor(((Node)object3).getEastNorth(), eastNorth, 0.0);
                polarCoor.radius = d;
                object2 = polarCoor.toEastNorth();
                object5.add(new MoveCommand((OsmPrimitive)object3, ((EastNorth)object2).east() - ((Node)object3).getEastNorth().east(), ((EastNorth)object2).north() - ((Node)object3).getEastNorth().north()));
            }
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle"), (Collection<Command>)object5));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    public class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double d, double d2) {
            this(d, d2, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double d, double d2, EastNorth eastNorth, double d3) {
            this.radius = d;
            this.angle = d2;
            this.origin = eastNorth;
            this.azimuth = d3;
        }

        PolarCoor(EastNorth eastNorth) {
            this(eastNorth, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            this.radius = AlignInCircleAction.this.distance(eastNorth, eastNorth2);
            this.angle = Math.atan2(eastNorth.north() - eastNorth2.north(), eastNorth.east() - eastNorth2.east());
            this.origin = eastNorth2;
            this.azimuth = d;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }
    }
}

