/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import java.util.HashMap;
import java.util.Map;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SignatureMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthConsumer
implements OAuthConsumer {
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private SignatureMethod signatureMethod;
    private OAuthMessageSigner messageSigner;

    public AbstractOAuthConsumer(String consumerKey, String consumerSecret, SignatureMethod signatureMethod) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.signatureMethod = signatureMethod;
        this.messageSigner = OAuthMessageSigner.create(signatureMethod);
        this.messageSigner.setConsumerSecret(consumerSecret);
    }

    @Override
    public HttpRequest sign(HttpRequest request) throws OAuthMessageSignerException, OAuthExpectationFailedException {
        if (this.consumerKey == null) {
            throw new OAuthExpectationFailedException("consumer key not set");
        }
        if (this.consumerSecret == null) {
            throw new OAuthExpectationFailedException("consumer secret not set");
        }
        Map<String, String> oauthParams = this.buildOAuthParameterMap();
        String signature = this.messageSigner.sign(request, oauthParams);
        request.setHeader("Authorization", this.buildOAuthHeader(oauthParams, signature));
        return request;
    }

    @Override
    public HttpRequest sign(Object request) throws OAuthMessageSignerException, OAuthExpectationFailedException {
        return this.sign(this.wrap(request));
    }

    protected abstract HttpRequest wrap(Object var1);

    @Override
    public void setTokenWithSecret(String token, String tokenSecret) {
        this.token = token;
        this.messageSigner.setTokenSecret(tokenSecret);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getTokenSecret() {
        return this.messageSigner.getTokenSecret();
    }

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Override
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    private Map<String, String> buildOAuthParameterMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("oauth_consumer_key", this.consumerKey);
        map.put("oauth_signature_method", this.signatureMethod.toString());
        map.put("oauth_timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        map.put("oauth_nonce", Long.toString(System.nanoTime()));
        map.put("oauth_version", "1.0");
        map.put("oauth_token", this.token);
        return map;
    }

    private String buildOAuthHeader(Map<String, String> oauthParams, String signature) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ");
        for (String key : oauthParams.keySet()) {
            String value = oauthParams.get(key);
            sb.append(this.oauthHeaderElement(key, value));
            sb.append(",");
        }
        sb.append(this.oauthHeaderElement("oauth_signature", signature));
        return sb.toString();
    }

    private String oauthHeaderElement(String name, String value) {
        return OAuth.percentEncode(name) + "=\"" + OAuth.percentEncode(value) + "\"";
    }
}

