/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String string) {
        this.baseurl = string;
    }

    public WikiReader() {
        this.baseurl = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
    }

    public String read(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "utf-8"));
        if (string.startsWith(this.baseurl) && !string.endsWith("?format=txt")) {
            return this.readFromTrac(bufferedReader);
        }
        return this.readNormal(bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLang(String string) {
        String string2 = LanguageInfo.getLanguageCodeWiki();
        String string3 = this.baseurl + "/wiki/" + string2 + string;
        String string4 = "";
        InputStream inputStream = null;
        try {
            inputStream = new URL(string3).openStream();
            string4 = this.readFromTrac(new BufferedReader(new InputStreamReader(inputStream, "utf-8")));
        }
        catch (IOException iOException) {
            System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}''. Exception was: {1}", string3, iOException.toString()));
        }
        catch (SecurityException securityException) {
            System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}'' for security reasons. Exception was: {1}", string3, securityException.toString()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (string4.length() == 0 && string2.length() != 0) {
            string3 = this.baseurl + "/wiki/" + string;
            try {
                inputStream = new URL(string3).openStream();
            }
            catch (IOException iOException) {
                System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}''. Exception was: {1}", string3, iOException.toString()));
                return string4;
            }
            catch (SecurityException securityException) {
                System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}'' for security reasons. Exception was: {1}", string3, securityException.toString()));
                return string4;
            }
            try {
                string4 = this.readFromTrac(new BufferedReader(new InputStreamReader(inputStream, "utf-8")));
            }
            catch (IOException iOException) {
                System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}''. Exception was: {1}", string3, iOException.toString()));
                String string5 = string4;
                return string5;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return string4;
    }

    private String readNormal(BufferedReader bufferedReader) throws IOException {
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.contains("[[TranslatedPages]]")) {
                string = string + string2.replaceAll(" />", ">") + "\n";
            }
            string2 = bufferedReader.readLine();
        }
        return "<html>" + string + "</html>";
    }

    private String readFromTrac(BufferedReader bufferedReader) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.contains("<div id=\"searchable\">")) {
                bl = true;
            } else if (string2.contains("<div class=\"wiki-toc trac-nav\"")) {
                bl2 = true;
            } else if (string2.contains("<div class=\"wikipage searchable\">")) {
                bl = true;
            } else if (string2.contains("<div class=\"buttons\">")) {
                bl = false;
            }
            if (bl && !bl2) {
                string = string + string2.replaceAll("<img src=\"/", "<img src=\"" + this.baseurl + "/").replaceAll("href=\"/", "href=\"" + this.baseurl + "/").replaceAll(" />", ">") + "\n";
            } else if (bl2 && string2.contains("</div>")) {
                bl2 = false;
            }
            string2 = bufferedReader.readLine();
        }
        if (string.indexOf("      Describe ") >= 0) {
            return "";
        }
        return "<html>" + string + "</html>";
    }
}

