/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.tools.OpenBrowser;

public class UrlLabel
extends JEditorPane
implements HyperlinkListener {
    private String url = "";
    private String description = "";

    public UrlLabel() {
        this.addHyperlinkListener(this);
        this.setEditable(false);
        this.setOpaque(false);
    }

    public UrlLabel(String string) {
        this(string, string);
    }

    public UrlLabel(String string, String string2) {
        this();
        this.setUrl(string);
        this.setDescription(string2);
        this.refresh();
    }

    protected void refresh() {
        this.setContentType("text/html");
        if (this.url != null) {
            this.setText("<html><a href=\"" + this.url + "\">" + this.description + "</a></html>");
        } else {
            this.setText("<html>" + this.description + "</html>");
        }
        this.setToolTipText(this.url);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            OpenBrowser.displayUrl(this.url);
        }
    }

    public void setUrl(String string) {
        this.url = string == null ? "" : string;
        this.refresh();
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
        this.refresh();
    }
}

