/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.HashMap;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmUrlToBounds {
    /*
     * WARNING - void declaration
     */
    public static Bounds parse(String string) {
        void var4_10;
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        String[] stringArray = string.substring(n + 1).split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            hashMap.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        Object var4_5 = null;
        try {
            if (hashMap.containsKey("bbox")) {
                String[] stringArray2 = ((String)hashMap.get("bbox")).split(",");
                Bounds bounds = new Bounds(new LatLon(Double.parseDouble(stringArray2[1]), Double.parseDouble(stringArray2[0])), new LatLon(Double.parseDouble(stringArray2[3]), Double.parseDouble(stringArray2[2])));
            } else if (hashMap.containsKey("minlat")) {
                String string3 = (String)hashMap.get("minlat");
                Double d = Double.parseDouble(string3);
                string3 = (String)hashMap.get("minlon");
                Double d2 = Double.parseDouble(string3);
                string3 = hashMap.get("maxlat");
                Double d3 = Double.parseDouble(string3);
                string3 = hashMap.get("maxlon");
                Double d4 = Double.parseDouble(string3);
                Bounds bounds = new Bounds(new LatLon(d, d2), new LatLon(d3, d4));
            } else {
                double d = 180.0 / Math.pow(2.0, Integer.parseInt((String)hashMap.get("zoom")));
                Bounds bounds = new Bounds(new LatLon(OsmUrlToBounds.parseDouble(hashMap, "lat") - d / 2.0, OsmUrlToBounds.parseDouble(hashMap, "lon") - d), new LatLon(OsmUrlToBounds.parseDouble(hashMap, "lat") + d / 2.0, OsmUrlToBounds.parseDouble(hashMap, "lon") + d));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return var4_10;
    }

    private static double parseDouble(HashMap<String, String> hashMap, String string) {
        if (hashMap.containsKey(string)) {
            return Double.parseDouble(hashMap.get(string));
        }
        return Double.parseDouble(hashMap.get("m" + string));
    }

    public static int getZoom(Bounds bounds) {
        int n;
        double d = Math.log(Math.tan(0.7853981633974483 + bounds.min.lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d2 = Math.log(Math.tan(0.7853981633974483 + bounds.max.lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d3 = Math.max(Math.abs(d2 - d), Math.abs(bounds.max.lon() - bounds.min.lon()));
        for (n = 0; n <= 20 && !(d3 >= 180.0); d3 *= 2.0, ++n) {
        }
        return n;
    }

    public static String getURL(Bounds bounds) {
        return OsmUrlToBounds.getURL(bounds.getCenter(), OsmUrlToBounds.getZoom(bounds));
    }

    public static String getURL(LatLon latLon, int n) {
        int n2 = (int)Math.pow(10.0, n / 3);
        double d = Math.round(latLon.lat() * (double)n2);
        double d2 = Math.round(latLon.lon() * (double)n2);
        return new String("http://www.openstreetmap.org/?lat=" + (d /= (double)n2) + "&lon=" + (d2 /= (double)n2) + "&zoom=" + n);
    }
}

