/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.AbstractList;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyList<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable {
    private E[] array;
    private int size;
    private boolean pristine;

    public CopyList(E[] EArray) {
        this(EArray, EArray.length);
    }

    private CopyList(E[] EArray, int n) {
        this.array = EArray;
        this.size = n;
        this.pristine = true;
    }

    @Override
    public E get(int n) {
        this.rangeCheck(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E set(int n, E e) {
        this.rangeCheck(n);
        this.changeCheck();
        E e2 = this.array[n];
        this.array[n] = e;
        return e2;
    }

    @Override
    public void add(int n, E e) {
        this.ensureCapacity(this.size + 1);
        this.changeCheck();
        System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        this.array[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.rangeCheck(n);
        this.changeCheck();
        ++this.modCount;
        E e = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        } else {
            this.array[n] = null;
        }
        --this.size;
        return e;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.changeCheck();
        this.array[this.size++] = e;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        while (this.size > 0) {
            this.array[--this.size] = null;
        }
    }

    public Object clone() {
        return new CopyList<E>(this.array, this.size);
    }

    private void rangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void changeCheck() {
        if (this.pristine) {
            this.array = (Object[])this.array.clone();
            this.pristine = false;
        }
    }

    private void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this.array.length) {
            E[] EArray = this.array;
            int n2 = Math.max(n, this.array.length * 3 / 2 + 1);
            this.array = new Object[n2];
            System.arraycopy(EArray, 0, this.array, 0, this.size);
            this.pristine = false;
        }
    }
}

