/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.DateUtils;

public class OsmWriter
extends XmlWriter
implements Visitor {
    public final String DEFAULT_API_VERSION = "0.6";
    private long newIdCounter = -1L;
    public HashMap<OsmPrimitive, Long> usedNewIds = new HashMap();
    private boolean osmConform;
    private boolean withBody = true;
    private String version;
    private Changeset changeset;

    public OsmWriter(PrintWriter printWriter, boolean bl, String string) {
        super(printWriter);
        this.osmConform = bl;
        this.version = string == null ? "0.6" : string;
    }

    public void setWithBody(boolean bl) {
        this.withBody = bl;
    }

    public void setChangeset(Changeset changeset) {
        this.changeset = changeset;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void header() {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    public void writeContent(DataSet dataSet) {
        for (Node osmPrimitive : dataSet.nodes) {
            if (!this.shouldWrite(osmPrimitive)) continue;
            this.visit(osmPrimitive);
        }
        for (Way way : dataSet.ways) {
            if (!this.shouldWrite(way)) continue;
            this.visit(way);
        }
        for (Relation relation : dataSet.relations) {
            if (!this.shouldWrite(relation)) continue;
            this.visit(relation);
        }
    }

    private boolean shouldWrite(OsmPrimitive osmPrimitive) {
        return osmPrimitive.getId() != 0L || !osmPrimitive.isDeleted();
    }

    public void writeDataSources(DataSet dataSet) {
        for (DataSource dataSource : dataSet.dataSources) {
            this.out.println("  <bounds minlat='" + dataSource.bounds.min.lat() + "' minlon='" + dataSource.bounds.min.lon() + "' maxlat='" + dataSource.bounds.max.lat() + "' maxlon='" + dataSource.bounds.max.lon() + "' origin='" + XmlWriter.encode(dataSource.origin) + "' />");
        }
    }

    public void visit(Node node) {
        if (node.incomplete) {
            return;
        }
        this.addCommon(node, "node");
        this.out.print(" lat='" + node.getCoor().lat() + "' lon='" + node.getCoor().lon() + "'");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.addTags(node, "node", true);
        }
    }

    public void visit(Way way) {
        if (way.incomplete) {
            return;
        }
        this.addCommon(way, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (Node node : way.getNodes()) {
                this.out.println("    <nd ref='" + this.getUsedId(node) + "' />");
            }
            this.addTags(way, "way", false);
        }
    }

    public void visit(Relation relation) {
        if (relation.incomplete) {
            return;
        }
        this.addCommon(relation, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (RelationMember relationMember : relation.getMembers()) {
                this.out.print("    <member type='");
                this.out.print(OsmPrimitiveType.from(relationMember.getMember()).getAPIName());
                this.out.println("' ref='" + this.getUsedId(relationMember.getMember()) + "' role='" + XmlWriter.encode(relationMember.getRole()) + "' />");
            }
            this.addTags(relation, "relation", false);
        }
    }

    public void visit(Changeset changeset) {
        this.out.print("  <changeset ");
        this.out.print(" id='" + changeset.getId() + "'");
        if (changeset.getUser() != null) {
            this.out.print(" user='" + changeset.getUser().getName() + "'");
            this.out.print(" uid='" + changeset.getUser().getId() + "'");
        }
        if (changeset.getCreatedAt() != null) {
            this.out.print(" created_at='" + DateUtils.fromDate(changeset.getCreatedAt()) + "'");
        }
        if (changeset.getClosedAt() != null) {
            this.out.print(" closed_at='" + DateUtils.fromDate(changeset.getClosedAt()) + "'");
        }
        this.out.print(" open='" + (changeset.isOpen() ? "true" : "false") + "'");
        if (changeset.getMin() != null) {
            this.out.print(" min_lon='" + changeset.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" min_lat='" + changeset.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        if (changeset.getMax() != null) {
            this.out.print(" max_lon='" + changeset.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" max_lat='" + changeset.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        this.out.println(">");
        this.addTags(changeset, "changeset", false);
    }

    private long getUsedId(OsmPrimitive osmPrimitive) {
        long l;
        if (osmPrimitive.getId() != 0L) {
            return osmPrimitive.getId();
        }
        if (this.usedNewIds.containsKey(osmPrimitive)) {
            return this.usedNewIds.get(osmPrimitive);
        }
        this.usedNewIds.put(osmPrimitive, this.newIdCounter);
        if (this.osmConform) {
            l = 0L;
        } else {
            long l2 = this.newIdCounter;
            l = l2;
            this.newIdCounter = l2 - 1L;
        }
        return l;
    }

    private void addTags(Tagged tagged, String string, boolean bl) {
        if (tagged.hasKeys()) {
            if (bl) {
                this.out.println(">");
            }
            for (Map.Entry<String, String> entry : tagged.getKeys().entrySet()) {
                if (!(tagged instanceof Changeset) && "created_by".equals(entry.getKey())) continue;
                this.out.println("    <tag k='" + XmlWriter.encode(entry.getKey()) + "' v='" + XmlWriter.encode(entry.getValue()) + "' />");
            }
            this.out.println("  </" + string + ">");
        } else if (bl) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + string + ">");
        }
    }

    private void addCommon(OsmPrimitive osmPrimitive, String string) {
        long l = this.getUsedId(osmPrimitive);
        this.out.print("  <" + string);
        if (l != 0L) {
            this.out.print(" id='" + this.getUsedId(osmPrimitive) + "'");
        }
        if (!this.osmConform) {
            String string2 = null;
            if (osmPrimitive.isDeleted()) {
                string2 = "delete";
            } else if (osmPrimitive.isModified()) {
                string2 = "modify";
            }
            if (string2 != null) {
                this.out.print(" action='" + string2 + "'");
            }
        }
        if (!osmPrimitive.isTimestampEmpty()) {
            this.out.print(" timestamp='" + DateUtils.fromDate(osmPrimitive.getTimestamp()) + "'");
        }
        if (osmPrimitive.user != null) {
            if (osmPrimitive.user.isLocalUser()) {
                this.out.print(" user='" + XmlWriter.encode(osmPrimitive.user.getName()) + "'");
            } else if (osmPrimitive.user.isOsmUser()) {
                this.out.print(" uid='" + osmPrimitive.user.getId() + "'");
                this.out.print(" user='" + XmlWriter.encode(osmPrimitive.user.getName()) + "'");
            }
        }
        this.out.print(" visible='" + osmPrimitive.isVisible() + "'");
        if (osmPrimitive.getVersion() != 0L) {
            this.out.print(" version='" + osmPrimitive.getVersion() + "'");
        }
        if (this.changeset != null && this.changeset.getId() != 0L) {
            this.out.print(" changeset='" + this.changeset.getId() + "'");
        }
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }
}

