/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerObjectReader
extends OsmServerReader {
    long id;
    OsmPrimitiveType type;
    boolean full;

    public OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) {
        this.id = l;
        this.type = osmPrimitiveType;
        this.full = bl;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        InputStream inputStream = null;
        try {
            DataSet dataSet;
            progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.type.getAPIName());
            stringBuffer.append("/");
            stringBuffer.append(this.id);
            if (this.full && !this.type.equals((Object)OsmPrimitiveType.NODE)) {
                stringBuffer.append("/full");
            }
            if ((inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true))) == null) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            DataSet dataSet3 = dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(-1, false));
            return dataSet3;
        }
        catch (OsmTransferException osmTransferException) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            this.activeConnection = null;
        }
    }
}

