/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmHistoryReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerHistoryReader
extends OsmServerReader {
    private OsmPrimitiveType primitiveType;
    private long id;

    public OsmServerHistoryReader(OsmPrimitiveType osmPrimitiveType, long l) throws IllegalArgumentException {
        if (osmPrimitiveType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        if (l < 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' >= 0 expected. Got ''{1}''.", "id", l));
        }
        this.primitiveType = osmPrimitiveType;
        this.id = l;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public HistoryDataSet parseHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream inputStream = null;
        progressMonitor.beginTask("");
        try {
            HistoryDataSet historyDataSet;
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/history");
            inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                HistoryDataSet historyDataSet2 = null;
                return historyDataSet2;
            }
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading history..."));
            OsmHistoryReader osmHistoryReader = new OsmHistoryReader(inputStream);
            HistoryDataSet historyDataSet3 = historyDataSet = osmHistoryReader.parse(progressMonitor.createSubTaskMonitor(1, true));
            return historyDataSet3;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                HistoryDataSet historyDataSet = null;
                return historyDataSet;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                this.activeConnection = null;
            }
        }
    }
}

