/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmReader {
    private static final Logger logger = Logger.getLogger(OsmReader.class.getName());
    private DataSet ds = new DataSet();
    private Map<String, OsmPrimitive> externalIdMap = new HashMap<String, OsmPrimitive>();
    private Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    private Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();

    public DataSet getDataSet() {
        return this.ds;
    }

    private OsmReader() {
        this.externalIdMap = new HashMap<String, OsmPrimitive>();
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Long l : this.ways.keySet()) {
            Way way = (Way)this.externalIdMap.get("w" + l);
            boolean bl = false;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (long l2 : this.ways.get(l)) {
                Node node = (Node)this.externalIdMap.get("n" + l2);
                if (node == null) {
                    if (l2 <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", l, l2));
                    }
                    node = new Node(l2);
                    node.incomplete = true;
                    bl = true;
                }
                arrayList.add(node);
            }
            way.setNodes(arrayList);
            if (bl) {
                logger.warning(I18n.tr("Marked way {0} with {1} nodes incomplete because at least one node was missing in the loaded data and is therefore incomplete too.", l, way.getNodesCount()));
                way.incomplete = true;
                this.ds.addPrimitive(way);
                continue;
            }
            way.incomplete = false;
            this.ds.addPrimitive(way);
        }
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive osmPrimitive : this.externalIdMap.values()) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.ds.addPrimitive(osmPrimitive);
        }
    }

    private void processRelationsAfterParsing() throws IllegalDataException {
        for (Long l : this.relations.keySet()) {
            Relation relation = (Relation)this.externalIdMap.get("r" + l);
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMemberData relationMemberData : this.relations.get(l)) {
                OsmPrimitive osmPrimitive = null;
                if (relationMemberData.type.equals("node")) {
                    osmPrimitive = this.externalIdMap.get("n" + relationMemberData.id);
                } else if (relationMemberData.type.equals("way")) {
                    osmPrimitive = this.externalIdMap.get("w" + relationMemberData.id);
                } else if (relationMemberData.type.equals("relation")) {
                    osmPrimitive = this.externalIdMap.get("r" + relationMemberData.id);
                } else {
                    throw new IllegalDataException(I18n.tr("Unknown relation member type ''{0}'' in relation with external id ''{1}''.", relationMemberData.type, l));
                }
                if (osmPrimitive == null) {
                    if (relationMemberData.id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", l, relationMemberData.id));
                    }
                    if (relationMemberData.type.equals("node")) {
                        osmPrimitive = new Node(relationMemberData.id);
                    } else if (relationMemberData.type.equals("way")) {
                        osmPrimitive = new Way(relationMemberData.id);
                    } else if (relationMemberData.type.equals("relation")) {
                        osmPrimitive = new Relation(relationMemberData.id);
                    }
                    this.ds.addPrimitive(osmPrimitive);
                }
                arrayList.add(new RelationMember(relationMemberData.role, osmPrimitive));
            }
            relation.setMembers(arrayList);
            this.ds.addPrimitive(relation);
        }
    }

    public static DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        OsmReader osmReader = new OsmReader();
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.subTask(I18n.tr("Parsing OSM data..."));
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmReader osmReader2 = osmReader;
            osmReader2.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmReader2.new Parser());
            progressMonitor.worked(1);
            progressMonitor.subTask(I18n.tr("Preparing data set..."));
            osmReader.processNodesAfterParsing();
            osmReader.processWaysAfterParsing();
            osmReader.processRelationsAfterParsing();
            progressMonitor.worked(1);
            DataSet dataSet = osmReader.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException illegalDataException) {
            throw illegalDataException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalDataException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalDataException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            throw new IllegalDataException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private OsmPrimitiveData current;
        private String generator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws OsmDataParsingException {
            throw new OsmDataParsingException(string).rememberLocation(this.locator);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("osm")) {
                String string4;
                if (attributes == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                }
                if ((string4 = attributes.getValue("version")) == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                }
                if (!string4.equals("0.5") && !string4.equals("0.6")) {
                    this.throwException(I18n.tr("Unsupported version: {0}", string4));
                }
                this.generator = attributes.getValue("generator");
                ((OsmReader)OsmReader.this).ds.version = string4;
            } else if (string3.equals("bounds")) {
                String string5 = attributes.getValue("minlon");
                String string6 = attributes.getValue("minlat");
                String string7 = attributes.getValue("maxlon");
                String string8 = attributes.getValue("maxlat");
                String string9 = attributes.getValue("origin");
                if (string5 != null && string7 != null && string6 != null && string8 != null) {
                    if (string9 == null) {
                        string9 = this.generator;
                    }
                    Bounds bounds = new Bounds(new LatLon(Double.parseDouble(string6), Double.parseDouble(string5)), new LatLon(Double.parseDouble(string8), Double.parseDouble(string7)));
                    DataSource dataSource = new DataSource(bounds, string9);
                    ((OsmReader)OsmReader.this).ds.dataSources.add(dataSource);
                } else {
                    this.throwException(I18n.tr("Missing manadatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", string5, string6, string7, string8, string9));
                }
            } else if (string3.equals("node")) {
                this.current = new OsmPrimitiveData();
                this.current.latlon = new LatLon(this.getDouble(attributes, "lat"), this.getDouble(attributes, "lon"));
                this.readCommon(attributes, this.current);
                Node node = this.current.createNode();
                OsmReader.this.externalIdMap.put("n" + this.current.id, node);
            } else if (string3.equals("way")) {
                this.current = new OsmPrimitiveData();
                this.readCommon(attributes, this.current);
                Way way = this.current.createWay();
                OsmReader.this.externalIdMap.put("w" + this.current.id, way);
                OsmReader.this.ways.put(this.current.id, new ArrayList());
            } else if (string3.equals("nd")) {
                long l;
                Collection collection = (Collection)OsmReader.this.ways.get(this.current.id);
                if (collection == null) {
                    this.throwException(I18n.tr("Found XML element <nd> not as direct child of element <way>."));
                }
                if (attributes.getValue("ref") == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", this.current.id));
                }
                if ((l = this.getLong(attributes, "ref")) == 0L) {
                    this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", l));
                }
                collection.add(l);
            } else if (string3.equals("relation")) {
                this.current = new OsmPrimitiveData();
                this.readCommon(attributes, this.current);
                Relation relation = this.current.createRelation();
                OsmReader.this.externalIdMap.put("r" + this.current.id, relation);
                OsmReader.this.relations.put(this.current.id, new LinkedList());
            } else if (string3.equals("member")) {
                Collection collection = (Collection)OsmReader.this.relations.get(this.current.id);
                if (collection == null) {
                    this.throwException(I18n.tr("Found XML element <member> not as direct child of element <relation>."));
                }
                RelationMemberData relationMemberData = new RelationMemberData();
                String string10 = attributes.getValue("ref");
                if (string10 == null) {
                    this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", this.current.id));
                }
                try {
                    relationMemberData.id = Long.parseLong(string10);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(this.current.id), string10));
                }
                string10 = attributes.getValue("type");
                if (string10 == null) {
                    this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(relationMemberData.id), Long.toString(this.current.id)));
                }
                if (!(string10.equals("way") || string10.equals("node") || string10.equals("relation"))) {
                    this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(relationMemberData.id), Long.toString(this.current.id), string10));
                }
                relationMemberData.type = string10;
                relationMemberData.role = string10 = attributes.getValue("role");
                if (relationMemberData.id == 0L) {
                    this.throwException(I18n.tr("Incomplete <member> specification with ref=0"));
                }
                collection.add(relationMemberData);
            } else if (string3.equals("tag")) {
                String string11 = attributes.getValue("k");
                String string12 = attributes.getValue("v");
                this.current.rememberTag(string11, string12);
            } else {
                System.out.println(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", string3));
            }
        }

        private double getDouble(Attributes attributes, String string) {
            return Double.parseDouble(attributes.getValue(string));
        }

        private User createUser(String string, String string2) throws SAXException {
            if (string == null) {
                if (string2 == null) {
                    return null;
                }
                return User.createLocalUser(string2);
            }
            try {
                long l = Long.parseLong(string);
                return User.createOsmUser(l, string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''uid''. Got ''{0}''.", string));
                return null;
            }
        }

        void readCommon(Attributes attributes, OsmPrimitiveData osmPrimitiveData) throws SAXException {
            String string;
            osmPrimitiveData.id = this.getLong(attributes, "id");
            if (osmPrimitiveData.id == 0L) {
                this.throwException(I18n.tr("Illegal object with ID=0."));
            }
            if ((string = attributes.getValue("timestamp")) != null && string.length() != 0) {
                osmPrimitiveData.timestamp = DateUtils.fromString(string);
            }
            String string2 = attributes.getValue("user");
            String string3 = attributes.getValue("uid");
            osmPrimitiveData.user = this.createUser(string3, string2);
            String string4 = attributes.getValue("visible");
            if (string4 != null) {
                osmPrimitiveData.visible = Boolean.parseBoolean(string4);
            }
            String string5 = attributes.getValue("version");
            osmPrimitiveData.version = 0;
            if (string5 != null) {
                try {
                    osmPrimitiveData.version = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(osmPrimitiveData.id), string5));
                }
                if (((OsmReader)OsmReader.this).ds.version.equals("0.6")) {
                    if (osmPrimitiveData.version <= 0 && osmPrimitiveData.id > 0L) {
                        this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(osmPrimitiveData.id), string5));
                    } else if (osmPrimitiveData.version < 0 && osmPrimitiveData.id <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", osmPrimitiveData.id, osmPrimitiveData.version, 0, "0.6"));
                        osmPrimitiveData.version = 0;
                    }
                } else if (((OsmReader)OsmReader.this).ds.version.equals("0.5")) {
                    if (osmPrimitiveData.version <= 0 && osmPrimitiveData.id > 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", osmPrimitiveData.id, osmPrimitiveData.version, 1, "0.5"));
                        osmPrimitiveData.version = 1;
                    } else if (osmPrimitiveData.version < 0 && osmPrimitiveData.id <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", osmPrimitiveData.id, osmPrimitiveData.version, 0, "0.5"));
                        osmPrimitiveData.version = 0;
                    }
                } else {
                    this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", ((OsmReader)OsmReader.this).ds.version));
                }
            } else if (osmPrimitiveData.id > 0L && ((OsmReader)OsmReader.this).ds.version != null && ((OsmReader)OsmReader.this).ds.version.equals("0.6")) {
                this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(osmPrimitiveData.id)));
            }
            String string6 = attributes.getValue("action");
            if (string6 == null) {
                return;
            }
            if (string6.equals("delete")) {
                osmPrimitiveData.deleted = true;
            } else if (string6.startsWith("modify")) {
                osmPrimitiveData.modified = true;
            }
        }

        private long getLong(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing required attribute ''{0}''.", string));
            }
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", string, string2));
                return 0L;
            }
        }
    }

    private static class RelationMemberData {
        public String type;
        public long id;
        public String role;

        private RelationMemberData() {
        }
    }

    private static class OsmPrimitiveData {
        public long id = 0L;
        public boolean modified = false;
        public boolean deleted = false;
        public Date timestamp = new Date();
        public User user = null;
        public boolean visible = true;
        public int version = 0;
        public LatLon latlon = new LatLon(0.0, 0.0);
        private OsmPrimitive primitive;

        private OsmPrimitiveData() {
        }

        public void copyTo(OsmPrimitive osmPrimitive) {
            if (this.id <= 0L) {
                osmPrimitive.clearOsmId();
            } else {
                osmPrimitive.setOsmId(this.id, this.version);
            }
            osmPrimitive.setDeleted(this.deleted);
            osmPrimitive.setModified(this.modified);
            osmPrimitive.setTimestamp(this.timestamp);
            osmPrimitive.user = this.user;
            osmPrimitive.setVisible(this.visible);
            osmPrimitive.mappaintStyle = null;
        }

        public Node createNode() {
            Node node = new Node();
            node.setCoor(this.latlon);
            this.copyTo(node);
            this.primitive = node;
            return node;
        }

        public Way createWay() {
            Way way = new Way();
            this.copyTo(way);
            this.primitive = way;
            return way;
        }

        public Relation createRelation() {
            Relation relation = new Relation();
            this.copyTo(relation);
            this.primitive = relation;
            return relation;
        }

        public void rememberTag(String string, String string2) {
            this.primitive.put(string, string2);
        }
    }
}

