/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.CredentialsManager;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OsmConnection {
    private static final Logger logger = Logger.getLogger(OsmConnection.class.getName());
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    public static CredentialsManager credentialsManager = new PlainCredentialsManager();
    private static OsmAuth authentication = new OsmAuth();

    protected final void initAuthentication() {
        OsmConnection.authentication.authCancelled = false;
        OsmConnection.authentication.passwordtried = false;
    }

    protected final boolean isAuthCancelled() {
        return OsmConnection.authentication.authCancelled;
    }

    public void cancel() {
        this.cancel = true;
        if (this.activeConnection != null) {
            this.activeConnection.setConnectTimeout(100);
            this.activeConnection.setReadTimeout(100);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.activeConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuth(HttpURLConnection httpURLConnection) throws CharacterCodingException {
        String string;
        Object object;
        CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
        try {
            object = credentialsManager;
            synchronized (object) {
                string = credentialsManager.lookup(CredentialsManager.Key.USERNAME) + ":" + credentialsManager.lookup(CredentialsManager.Key.PASSWORD);
            }
        }
        catch (CredentialsManager.CMException cMException) {
            string = ":";
        }
        object = charsetEncoder.encode(CharBuffer.wrap(string));
        httpURLConnection.addRequestProperty("Authorization", "Basic " + Base64.encode((ByteBuffer)object));
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
            Authenticator.setDefault(authentication);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static class PlainCredentialsManager
    implements CredentialsManager {
        public String lookup(CredentialsManager.Key key) throws CredentialsManager.CMException {
            String string = Main.pref.get("osm-server." + key.toString(), null);
            if (string == null) {
                throw new CredentialsManager.NoContentException();
            }
            return string;
        }

        public void store(CredentialsManager.Key key, String string) {
            Main.pref.put("osm-server." + key.toString(), string);
        }

        public PasswordAuthentication getPasswordAuthentication(OsmAuth osmAuth) {
            String string;
            String string2;
            try {
                string2 = this.lookup(CredentialsManager.Key.USERNAME);
            }
            catch (CredentialsManager.CMException cMException) {
                string2 = "";
            }
            try {
                string = this.lookup(CredentialsManager.Key.PASSWORD);
            }
            catch (CredentialsManager.CMException cMException) {
                string = "";
            }
            if (osmAuth.passwordtried || string2.equals("") || string.equals("")) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                if (!string2.equals("") && !string.equals("")) {
                    jPanel.add((Component)new JLabel(I18n.tr("Incorrect password or username.")), GBC.eop());
                }
                jPanel.add((Component)new JLabel(I18n.tr("Username")), GBC.std().insets(0, 0, 10, 0));
                JTextField jTextField = new JTextField(string2, 20);
                jPanel.add((Component)jTextField, GBC.eol());
                jPanel.add((Component)new JLabel(I18n.tr("Password")), GBC.std().insets(0, 0, 10, 0));
                JPasswordField jPasswordField = new JPasswordField(string, 20);
                jPanel.add((Component)jPasswordField, GBC.eol());
                JLabel jLabel = new JLabel(I18n.tr("Warning: The password is transferred unencrypted."));
                jLabel.setFont(jLabel.getFont().deriveFont(2));
                jPanel.add((Component)jLabel, GBC.eop());
                JCheckBox jCheckBox = new JCheckBox(I18n.tr("Save user and password (unencrypted)"), !string2.equals("") && !string.equals(""));
                jPanel.add((Component)jCheckBox, GBC.eop());
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Enter Password"), new String[]{I18n.tr("Login"), I18n.tr("Cancel")});
                extendedDialog.setContent(jPanel);
                extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                extendedDialog.showDialog();
                if (extendedDialog.getValue() != 1) {
                    osmAuth.authCancelled = true;
                    return null;
                }
                string2 = jTextField.getText();
                string = String.valueOf(jPasswordField.getPassword());
                if (jCheckBox.isSelected()) {
                    this.store(CredentialsManager.Key.USERNAME, string2);
                    this.store(CredentialsManager.Key.PASSWORD, string);
                }
                if (string2.equals("")) {
                    return null;
                }
            }
            osmAuth.passwordtried = true;
            return new PasswordAuthentication(string2, string.toCharArray());
        }

        public CredentialsManager.PreferenceAdditions newPreferenceAdditions() {
            return new CredentialsManager.PreferenceAdditions(){
                private final JTextField osmDataServerURL = new JTextField(20);
                private final JTextField osmDataUsername = new JTextField(20);
                private final JPasswordField osmDataPassword = new JPasswordField(20);
                private String oldServerURL = "";
                private String oldUsername = "";
                private String oldPassword = "";

                public void addPreferenceOptions(JPanel jPanel) {
                    try {
                        this.oldServerURL = PlainCredentialsManager.this.lookup(CredentialsManager.Key.OSM_SERVER_URL);
                    }
                    catch (CredentialsManager.CMException cMException) {
                        this.oldServerURL = "";
                    }
                    if (this.oldServerURL.equals("")) {
                        this.oldServerURL = "http://api.openstreetmap.org/api";
                    }
                    try {
                        this.oldUsername = PlainCredentialsManager.this.lookup(CredentialsManager.Key.USERNAME);
                    }
                    catch (CredentialsManager.CMException cMException) {
                        this.oldUsername = "";
                    }
                    try {
                        this.oldPassword = PlainCredentialsManager.this.lookup(CredentialsManager.Key.PASSWORD);
                    }
                    catch (CredentialsManager.CMException cMException) {
                        this.oldPassword = "";
                    }
                    this.osmDataServerURL.setText(this.oldServerURL);
                    this.osmDataUsername.setText(this.oldUsername);
                    this.osmDataPassword.setText(this.oldPassword);
                    this.osmDataServerURL.setToolTipText(I18n.tr("The base URL for the OSM server (REST API)"));
                    this.osmDataUsername.setToolTipText(I18n.tr("Login name (e-mail) to the OSM account."));
                    this.osmDataPassword.setToolTipText(I18n.tr("Login password to the OSM account. Leave blank to not store any password."));
                    jPanel.add((Component)new JLabel(I18n.tr("Base Server URL")), GBC.std());
                    jPanel.add((Component)this.osmDataServerURL, GBC.eol().fill(2).insets(5, 0, 0, 5));
                    jPanel.add((Component)new JLabel(I18n.tr("OSM username (e-mail)")), GBC.std());
                    jPanel.add((Component)this.osmDataUsername, GBC.eol().fill(2).insets(5, 0, 0, 5));
                    jPanel.add((Component)new JLabel(I18n.tr("OSM password")), GBC.std());
                    jPanel.add((Component)this.osmDataPassword, GBC.eol().fill(2).insets(5, 0, 0, 0));
                    JLabel jLabel = new JLabel(I18n.tr("<html>WARNING: The password is stored in plain text in the preferences file.<br>The password is transferred in plain text to the server, encoded in the URL.<br><b>Do not use a valuable Password.</b></html>"));
                    jLabel.setFont(jLabel.getFont().deriveFont(2));
                    jPanel.add((Component)jLabel, GBC.eop().fill(2));
                }

                public void preferencesChanged() {
                    String string = this.osmDataServerURL.getText();
                    String string2 = this.osmDataUsername.getText();
                    String string3 = String.valueOf(this.osmDataPassword.getPassword());
                    if (!this.oldServerURL.equals(string)) {
                        PlainCredentialsManager.this.store(CredentialsManager.Key.OSM_SERVER_URL, string);
                    }
                    if (!this.oldUsername.equals(string2)) {
                        PlainCredentialsManager.this.store(CredentialsManager.Key.USERNAME, string2);
                    }
                    if (!this.oldPassword.equals(string3)) {
                        PlainCredentialsManager.this.store(CredentialsManager.Key.PASSWORD, string3);
                    }
                }
            };
        }
    }

    public static class OsmAuth
    extends Authenticator {
        public boolean passwordtried = false;
        public boolean authCancelled = false;

        protected PasswordAuthentication getPasswordAuthentication() {
            return credentialsManager.getPasswordAuthentication(this);
        }
    }
}

