/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResultReader
extends AbstractVisitor {
    private Map<String, Long[]> versions = new HashMap<String, Long[]>();
    private Collection<OsmPrimitive> processed;
    private Map<OsmPrimitive, Long> newIdMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseDiffResult(String string, Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Map<OsmPrimitive, Long> map, ProgressMonitor progressMonitor) throws SAXException, IOException {
        progressMonitor.beginTask(I18n.tr("Preparing data..."));
        try {
            DiffResultReader diffResultReader = new DiffResultReader();
            diffResultReader.processed = collection2;
            diffResultReader.newIdMap = map;
            InputSource inputSource = new InputSource(new StringReader(string));
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                DiffResultReader diffResultReader2 = diffResultReader;
                diffResultReader2.getClass();
                sAXParser.parse(inputSource, (DefaultHandler)diffResultReader2.new Parser());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                throw new SAXException(parserConfigurationException);
            }
            for (OsmPrimitive osmPrimitive : collection) {
                osmPrimitive.visit(diffResultReader);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public void visit(Node node) {
        String string = "node:" + (this.newIdMap.containsKey(node) ? this.newIdMap.get(node).longValue() : node.getId());
        Long[] longArray = this.versions.get(string);
        if (longArray != null) {
            this.processed.add(node);
            if (!node.isDeleted()) {
                node.setOsmId(longArray[0], longArray[1].intValue());
            }
        }
    }

    @Override
    public void visit(Way way) {
        String string = "way:" + (this.newIdMap.containsKey(way) ? this.newIdMap.get(way).longValue() : way.getId());
        Long[] longArray = this.versions.get(string);
        if (longArray != null) {
            this.processed.add(way);
            if (!way.isDeleted()) {
                way.setOsmId(longArray[0], longArray[1].intValue());
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        String string = "relation:" + (this.newIdMap.containsKey(relation) ? this.newIdMap.get(relation).longValue() : relation.getId());
        Long[] longArray = this.versions.get(string);
        if (longArray != null) {
            this.processed.add(relation);
            if (!relation.isDeleted()) {
                relation.setOsmId(longArray[0], longArray[1].intValue());
            }
        }
    }

    private class Parser
    extends DefaultHandler {
        private Parser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!string3.equals("osm") && (string3.equals("node") || string3.equals("way") || string3.equals("relation"))) {
                    String string4 = string3 + ":" + attributes.getValue("old_id");
                    String string5 = attributes.getValue("new_id");
                    String string6 = attributes.getValue("new_version");
                    Long[] longArray = new Long[]{string5 == null ? null : new Long(string5), string6 == null ? null : new Long(string6)};
                    DiffResultReader.this.versions.put(string4, longArray);
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SAXException(I18n.tr("NullPointerException, possibly some missing tags."), nullPointerException);
            }
        }
    }
}

